<?php
if ( ! class_exists( 'NISHIKI_PRO_CSS_VARIABLES' ) ) {

	/**
	 * CSS Variables
	 */
	class NISHIKI_PRO_CSS_VARIABLES {

		/**
		 * Root
		 *
		 * @return $output
		 */
		public function output() {
			$output = '';

			$nishiki_pro_block_gap = apply_filters( 'nishiki_pro_block_gap', '2rem' );
			$output            .= "--nishiki-pro-block-gap:{$nishiki_pro_block_gap};";

			// Site Contents Width
			$site_content_width = absint( get_theme_mod( 'setting_site_contents_width', '1000' ) );

			// Site Contents Width(Custom)
			$site_custom_content_width = absint( get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_content_width_' . get_post_type(), true ) );
		
			// 0 または空じゃなければ変数定義 & 出力
			if ( '0' !== $site_custom_content_width && ! empty( $site_custom_content_width ) ) {
				$output .= "--nishiki-pro-site-content-width:{$site_custom_content_width}px;";
			} else {
				$output .= "--nishiki-pro-site-content-width:{$site_content_width}px;";
			}

			// Site Wide Width
			$site_wide_width = absint( get_theme_mod( 'setting_site_wide_width', '1200' ) );
			$output         .= "--nishiki-pro-site-wide-width:{$site_wide_width}px;";

			// Header Contents Width
			$header_contents_width = absint( get_theme_mod( 'setting_header_contents_width', '1000' ) );
			$output        .= "--nishiki-pro-header-content-width:{$header_contents_width}px;";

			// Archive Contents Width
			$archive_contents_width = absint( get_theme_mod( 'setting_archive_contents_width', '1000' ) );
			$output        .= "--nishiki-pro-archive-content-width:{$archive_contents_width}px;";

			// Footer Contents Width
			$footer_contents_width = absint( get_theme_mod( 'setting_footer_contents_width', '1000' ) );
			$output        .= "--nishiki-pro-footer-content-width:{$footer_contents_width}px;";

			// Base Color
			$site_background_color = esc_html( get_theme_mod( 'setting_site_background_color', '#ffffff' ) );
			$output               .= "--nishiki-pro-base-color:{$site_background_color};";

			// Main Color 01
			$site_main_color_01 = esc_html( get_theme_mod( 'setting_site_main_color_01', '#222222' ) );
			$output            .= "--nishiki-pro-main-color-01:{$site_main_color_01};";

			// Main Color 02
			$site_main_color_02 = esc_html( get_theme_mod( 'setting_site_main_color_02', '#ffffff' ) );
			$output            .= "--nishiki-pro-main-color-02:{$site_main_color_02};";

			// Accent Color 01
			$site_accent_color_01 = esc_html( get_theme_mod( 'setting_site_accent_color_01', '#8d728f' ) );
			$output              .= "--nishiki-pro-accent-color-01:{$site_accent_color_01};";

			// Accent Color 02
			$site_accent_color_02 = esc_html( get_theme_mod( 'setting_site_accent_color_02', '#ffffff' ) );
			$output              .= "--nishiki-pro-accent-color-02:{$site_accent_color_02};";

			// Text Color 01
			$site_main_text_color = esc_html( get_theme_mod( 'setting_site_main_text_color', '#222222' ) );
			$output              .= "--nishiki-pro-text-color-01:{$site_main_text_color};";

			// Text Color 02
			$site_sub_text_color = esc_html( get_theme_mod( 'setting_site_sub_text_color', '#aaaaaa' ) );
			$output             .= "--nishiki-pro-text-color-02:{$site_sub_text_color};";

			// Link Color 01
			$site_main_color = esc_html( get_theme_mod( 'setting_site_main_color', '#0a88cc' ) );
			$output         .= "--nishiki-pro-link-color-01:{$site_main_color};";

			// Link Color 02
			$site_sub_color = esc_html( get_theme_mod( 'setting_site_sub_color', '#0044a3' ) );
			$output        .= "--nishiki-pro-link-color-02:{$site_sub_color};";

			// Site Logo
			$site_logo_mobile_width = apply_filters( 'nishiki_pro_site_logo_mobile_width', get_theme_mod( 'setting_site_logo_mobile_width', 120 ) );
			$site_logo_mobile_height = apply_filters( 'nishiki_pro_site_logo_mobile_height', get_theme_mod( 'setting_site_logo_mobile_height', 40 ) );

			$output        .= "--nishiki-pro-site-logo-mobile-width:{$site_logo_mobile_width}px;";
			$output        .= "--nishiki-pro-site-logo-mobile-height:{$site_logo_mobile_height}px;";

			// Header Color
			$header_overlay = apply_filters( 'nishiki_pro_header_overlay', get_theme_mod( 'setting_header_overlay', false ) );

			// Header Height
			$output        .= "--nishiki-pro-header-height:70px;";
			$output        .= "--nishiki-pro-header-mobile-height:60px;";

			if ( $header_overlay ) {
				// text color
				$header_text_color = esc_html( apply_filters( 'nishiki_pro_header_overlay_text_color', get_theme_mod( 'setting_header_overlay_text_color', '#ffffff' ) ) );

				// background color
				$header_background_color = esc_html( apply_filters( 'nishiki_pro_header_overlay_background_color', get_theme_mod( 'setting_header_overlay_background_color', '#222222' ) ) );

				// Opacity
				$header_background_opacity = absint( apply_filters( 'nishiki_pro_header_overlay_background_color_opacity', get_theme_mod( 'setting_header_overlay_background_color_opacity', 30 ) ) );
			} else {

				// text color
				if( get_theme_mod( 'header_textcolor', '#222222' ) ){
					$core_header_text_color = '#' . get_theme_mod( 'header_textcolor', '222222' );
				} else {
					$core_header_text_color = '#222222';
				}

				$header_text_color = esc_html( apply_filters( 'nishiki_pro_header_text_color', get_theme_mod( 'setting_header_text_color', $core_header_text_color ) ) );

				// background color
				$header_background_color = esc_html( apply_filters( 'nishiki_pro_header_background_color', get_theme_mod( 'setting_header_background_color', '#ffffff' ) ) );

				// Opacity
				$header_background_opacity = absint( apply_filters( 'nishiki_pro_header_background_color_opacity', get_theme_mod( 'setting_header_background_color_opacity', 100 ) ) );
			}

			$output .= "--nishiki-pro-header-text-color:{$header_text_color};";
			$output .= "--nishiki-pro-header-background-color:{$header_background_color};";

			if ( $header_background_color ) {

				$header_background_color_rgb = 'rgba(' . implode( ',', nishiki_pro_hex_to_rgb( $header_background_color, $header_background_opacity ) ) . ')';

				$output .= "--nishiki-pro-header-background-color-rgba:{$header_background_color_rgb};";
			}
			
			// Search Overlay
			$search_overlay_background_color = get_theme_mod( 'setting_header_search_overlay_background_color', '#222222' ) ? esc_html( get_theme_mod( 'setting_header_search_overlay_background_color', '#222222' ) ) : '#222222';
			$search_overlay_background_opacity = get_theme_mod( 'setting_header_search_overlay_background_color_opacity', 90 );
			$search_overlay_text_color = get_theme_mod( 'setting_header_search_overlay_text_color', '#ffffff' ) ? esc_html( get_theme_mod( 'setting_header_search_overlay_text_color', '#ffffff' ) ) : '#ffffff';

			if( $search_overlay_background_color ){
				$seach_overlay_background_color_rgba = implode( ',', nishiki_pro_hex_to_rgb( $search_overlay_background_color, $search_overlay_background_opacity ) );
				$output .= "--nishiki-pro-search-overlay-background-color-rgba:rgba({$seach_overlay_background_color_rgba});";
			}

			$output .= "--nishiki-pro-search-overlay-text-color:{$search_overlay_text_color};";
			$output .= "--nishiki-pro-search-overlay-background-color:{$search_overlay_background_color};";

			// Menu Overlay
			$menu_overlay_background_color = get_theme_mod( 'setting_header_menu_overlay_background_color', '#222222' ) ? esc_html( get_theme_mod( 'setting_header_menu_overlay_background_color', '#222222' ) ) : '#222222';
			$menu_overlay_background_opacity = get_theme_mod( 'setting_header_menu_overlay_background_color_opacity', 90 );
			$menu_overlay_text_color = get_theme_mod( 'setting_header_menu_overlay_text_color', '#ffffff' ) ? esc_html( get_theme_mod( 'setting_header_menu_overlay_text_color', '#ffffff' ) ) : '#ffffff';

			if( $menu_overlay_background_color ){
				$menu_overlay_background_color_rgba = implode( ',', nishiki_pro_hex_to_rgb( $menu_overlay_background_color, $menu_overlay_background_opacity ) );
				$output .= "--nishiki-pro-menu-overlay-background-color-rgba:rgba({$menu_overlay_background_color_rgba});";
			}

			$output .= "--nishiki-pro-menu-overlay-text-color:{$menu_overlay_text_color};";
			$output .= "--nishiki-pro-menu-overlay-background-color:{$menu_overlay_background_color};";

			// TOC Overlay
			$toc_fixed_background_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_background_color', '#000000' ) ? esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_background_color', '#000000' ) ) : '#000000';
			$toc_fixed_text_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_text_color', '#ffffff' ) ? esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_text_color', '#ffffff' ) ) : '#ffffff';

			$output .= "--nishiki-pro-toc-fixed-text-color:{$toc_fixed_text_color};";
			$output .= "--nishiki-pro-toc-fixed-background-color:{$toc_fixed_background_color};";

			$toc_overlay_background_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color', '#222222' ) ? esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color', '#222222' ) ) : '#222222';
			$toc_overlay_background_opacity = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color_opacity', 90 );
			$toc_overlay_text_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_text_color', '#ffffff' ) ? esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_text_color', '#ffffff' ) ) : '#ffffff';

			if( $toc_overlay_background_color ){
				$toc_overlay_background_color_rgba = implode( ',', nishiki_pro_hex_to_rgb( $toc_overlay_background_color, $toc_overlay_background_opacity ) );
				$output .= "--nishiki-pro-toc-overlay-background-color-rgba:rgba({$toc_overlay_background_color_rgba});";
			}

			$output .= "--nishiki-pro-toc-overlay-text-color:{$toc_overlay_text_color};";
			$output .= "--nishiki-pro-toc-overlay-background-color:{$toc_overlay_background_color};";

			// Post Title Text Color
			$single_post_title_text_color = esc_html( get_theme_mod( 'setting_post_title_text_color', '#ffffff' ) );
			$single_post_title_background_color = esc_html( get_theme_mod( 'setting_post_title_background_color', '#222222' ) );

			$output .= "--nishiki-pro-post-title-text-color:{$single_post_title_text_color};";
			$output .= "--nishiki-pro-post-title-background-color:{$single_post_title_background_color};";

			// Page Title Text Color
			$single_page_title_text_color = esc_html( get_theme_mod( 'setting_page_title_text_color', '#ffffff' ) );
			$single_page_title_background_color = esc_html( get_theme_mod( 'setting_page_title_background_color', '#222222' ) );

			$output .= "--nishiki-pro-page-title-text-color:{$single_page_title_text_color};";
			$output .= "--nishiki-pro-page-title-background-color:{$single_page_title_background_color};";
			
			// PR Color
			$pr_before_content_color_01 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_01', '#222222' ) );
			$pr_before_content_color_02 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_02', '#ffffff' ) );

			$output .= "--nishiki-pro-pr-before-content-color-01:{$pr_before_content_color_01};";
			$output .= "--nishiki-pro-pr-before-content-color-02:{$pr_before_content_color_02};";

			// Social Button Color
			$social_text_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_text_color', '#fff' ) );
			$output           .= "--nishiki-pro-social-button-text-color:{$social_text_color};";

			$social_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_background_color', '#222222' ) );
			$output                 .= "--nishiki-pro-social-button-background-color:{$social_background_color};";

			// image style
			$block_style_image_water_color_01 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/water-color01.svg)';
			$output                          .= "--nishiki-pro-image-style-water-color-01:{$block_style_image_water_color_01};";

			$block_style_image_water_color_02 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/water-color02.svg)';
			$output                          .= "--nishiki-pro-image-style-water-color-02:{$block_style_image_water_color_02};";

			$block_style_image_water_color_03 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/water-color03.svg)';
			$output                          .= "--nishiki-pro-image-style-water-color-03:{$block_style_image_water_color_03};";

			$block_style_image_ink_01 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/ink01.svg)';
			$output                  .= "--nishiki-pro-image-style-ink-01:{$block_style_image_ink_01};";

			$block_style_image_ink_02 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/ink02.svg)';
			$output                  .= "--nishiki-pro-image-style-ink-02:{$block_style_image_ink_02};";

			$block_style_image_ink_03 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/ink03.svg)';
			$output                  .= "--nishiki-pro-image-style-ink-03:{$block_style_image_ink_03};";

			$block_style_image_fluid_01 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/fluid01.svg)';
			$output                    .= "--nishiki-pro-image-style-fluid-01:{$block_style_image_fluid_01};";

			$block_style_image_fluid_02 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/fluid02.svg)';
			$output                    .= "--nishiki-pro-image-style-fluid-02:{$block_style_image_fluid_02};";

			$block_style_image_fluid_03 = 'url(' . get_template_directory_uri() . '/assets/images/block-style/fluid03.svg)';
			$output                    .= "--nishiki-pro-image-style-fluid-03:{$block_style_image_fluid_03};";

			// Output
			if ( '' === $output ) {
				return false;
			}

			return $output;
		}
	}
}

