<?php
/**
 * 初期設定
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

//update_option( 'fresh_site', 1 );
//var_dump(get_option( 'fresh_site' ));
//delete_option('sidebars_widgets');
//delete_option('widget_text');
//var_dump(get_option( 'show_on_front' ));
//remove_theme_mods();
//remove_theme_mod( 'nav_menu_locations' );

// Default Setting
require_once 'default-setting.php';

// Prefix
require_once 'prefix.php';

// Content Width
if ( ! isset( $content_width ) && get_theme_mod( 'setting_site_contents_width', 1000 ) ) {
	$content_width = 1000;
}

/*****************
 * Break Point
 */

// PC
if ( ! defined( 'NISHIKI_PRO_BREAK_POINT_PC' ) ) {
	define( 'NISHIKI_PRO_BREAK_POINT_PC', '1000px' );
}

// Tablet
if ( ! defined( 'NISHIKI_PRO_BREAK_POINT_TABLET' ) ) {
	define( 'NISHIKI_PRO_BREAK_POINT_TABLET', '781px' );
}

// SP
if ( ! defined( 'NISHIKI_PRO_BREAK_POINT_SP' ) ) {
	define( 'NISHIKI_PRO_BREAK_POINT_SP', '680px' );
}

/*****************
 * Add Theme Support
 */

if ( ! function_exists( 'nishiki_pro_custom_theme_support' ) ) {
	/**
	 * テーマサポート
	 *
	 * @return void
	 */
	function nishiki_pro_custom_theme_support() {
		// Starter Content
		add_theme_support( 'starter-content', nishiki_pro_register_starter_content() );

		// Html5
		add_theme_support(
			'html5',
			array(
				'navigation-widgets',
				'comment-form',
				'comment-list',
			)
		);

		// Title Tag
		add_theme_support( 'title-tag' );

		// Thumbnails
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 640, 360, true );
		add_image_size( 'nishiki-thumbnail', 64, 36, true );

		// Custom Header
		add_theme_support(
			'custom-header',
			array(
				'width'       => 1280,
				'height'      => 720,
				'flex-height' => true,
				'video'       => true,
			)
		);

		// Custom Logo
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 80,
				'width'       => 240,
				'flex-height' => true,
				'flex-width'  => true,
				'header-text' => array( 'site-title', 'site-description' ),
			)
		);

		// Feed Links
		add_theme_support( 'automatic-feed-links' );

		/*****************
		 * Gutenberg
		 */

		// Editor Style
		// add_theme_support( 'wp-block-styles' );

		// Responsive embedded content
		add_theme_support( 'responsive-embeds' );

		// Align Wide
		add_theme_support( 'align-wide' );

		// Line Height
		add_theme_support( 'custom-line-height' );

		// Unit
		add_theme_support( 'custom-units' );

		// Custom Spacing
		add_theme_support( 'custom-spacing' );

		// Color Palette
		$block_editor_colors = get_option( 'nishiki_pro_block_editor_colors' );
		if ( empty( $block_editor_colors ) ) {
			$block_editor_colors = NISHIKI_PRO_BLOCK_EDITOR_DEFAULT_COLORS;
			update_option( 'nishiki_pro_block_editor_colors', $block_editor_colors );
		}

		// Color Plette Add Main & Accent
		$block_editor_main_color_01   = NISHIKI_PRO_MAIN_COLOR_01;
		$block_editor_main_color_02   = NISHIKI_PRO_MAIN_COLOR_02;
		$block_editor_accent_color_01 = NISHIKI_PRO_ACCENT_COLOR_01;
		$block_editor_accent_color_02 = NISHIKI_PRO_ACCENT_COLOR_02;

		$block_editor_colors[] = array(
			'name'  => $block_editor_main_color_01['name'],
			'color' => $block_editor_main_color_01['color'],
			'slug'  => $block_editor_main_color_01['slug'],
		);

		$block_editor_colors[] = array(
			'name'  => $block_editor_main_color_02['name'],
			'color' => $block_editor_main_color_02['color'],
			'slug'  => $block_editor_main_color_02['slug'],
		);

		$block_editor_colors[] = array(
			'name'  => $block_editor_accent_color_01['slug'],
			'color' => $block_editor_accent_color_01['color'],
			'slug'  => $block_editor_accent_color_01['slug'],
		);

		$block_editor_colors[] = array(
			'name'  => $block_editor_accent_color_02['slug'],
			'color' => $block_editor_accent_color_02['color'],
			'slug'  => $block_editor_accent_color_02['slug'],
		);

		// var_dump($block_editor_colors);

		add_theme_support( 'editor-color-palette', $block_editor_colors );

		// Disable Custom Colors
		// add_theme_support( 'disable-custom-colors' );

		// Disable Custom Font Size
		// add_theme_support('disable-custom-font-sizes');

		// Starter Content
		add_theme_support(
			'starter-content',
			array(
				'widgets' =>
				array(
					'sidebar_main'  =>
					array(
						'search',
						'recent-posts',
						'categories',
					),
					'footer_widget' =>
					array(
						'recent-posts',
						'categories',
						'search',
					),
				),
			)
		);

	}
	add_action( 'after_setup_theme', 'nishiki_pro_custom_theme_support' );
}

/*****************
 * Remove Excerpt Auto P Element
 */

remove_filter( 'the_excerpt', 'wpautop' );

/*****************
 * Add Short Code
 */

add_filter( 'widget_text', 'do_shortcode' );

/*****************
 * Add WP Body Open
 */
if ( ! function_exists( 'wp_body_open' ) ) {
	/**
	 * アクション追加（wp_body_open）
	 *
	 * @return void
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}

/*****************
 * Add Editor Style
 */

if ( ! function_exists( 'nishiki_pro_editor_style' ) ) {
	/**
	 * エディタースタイル追加
	 *
	 * @return void
	 */
	function nishiki_pro_editor_style() {
		add_editor_style();
	}

	add_action( 'admin_init', 'nishiki_pro_editor_style' );
}

/*****************
 * Add Body Class(skin)
 */

if ( ! function_exists( 'nishiki_pro_add_body_class_design_btn' ) ) {
	/**
	 * ボタンデザインのためのクラス追加
	 *
	 * @param array $classes クラス名
	 * @return $classes
	 */
	function nishiki_pro_add_body_class_design_btn( $classes ) {
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type', 'simple' ) !== 'simple' ) {
			$skin      = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type' ) );
			$classes[] = 'nishiki-pro-design-btn-' . $skin;
		}

		return $classes;
	}

	add_filter( 'body_class', 'nishiki_pro_add_body_class_design_btn' );
}

/*****************
 * Add Heading Class(skin)
 */

if ( ! function_exists( 'nishiki_pro_add_body_class_design_heading' ) ) {
	/**
	 * 見出しデザインのためのクラス追加
	 *
	 * @param array $classes クラス名
	 * @return $classes
	 */
	function nishiki_pro_add_body_class_design_heading( $classes ) {
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type', 'simple' ) !== 'simple' ) {
			$skin      = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type' ) );
			$classes[] = 'nishiki-pro-design-heading-' . $skin;
		}

		return $classes;
	}

	add_filter( 'body_class', 'nishiki_pro_add_body_class_design_heading' );
}

/*****************
 * Add Masthead Class
 */
if ( ! function_exists( 'nishiki_pro_masthead_class' ) ) {
	/**
	 * ヘッダーに追加するクラス
	 *
	 * @param string $class クラス名
	 */
	function nishiki_pro_masthead_class( $class = '' ) {

		// 初期値
		$header_sticky        = false;
		$header_sticky_mobile = false;
		$header_overlay       = false;

		// Stickyかどうか
		if ( get_theme_mod( 'setting_header_layout', 'default' ) === 'default' ) {
			if ( get_theme_mod( 'setting_header_fixed', true ) ) {
				$header_sticky = true;
			}
		}

		if ( get_theme_mod( 'setting_header_layout', 'default' ) === 'center' ) {
			if ( get_theme_mod( 'setting_header_fixed_mobile', true ) ) {
				$header_sticky_mobile = true;
			}
		}

		// overlayかどうか
		if ( get_theme_mod( 'setting_header_overlay' ) ) {
			$header_overlay = true;
		}

		// 個別設定
		if ( nishiki_pro_is_static_front_page() || is_singular() ) {

			$specific_post_sticky = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_header_sticky_' . get_post_type(), true );

			if ( '' !== $specific_post_sticky ) {
				$header_sticky = $specific_post_sticky;
			}

			$specific_post_sticky_mobile = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_header_sticky_mobile_' . get_post_type(), true );

			if ( '' !== $specific_post_sticky_mobile ) {
				$header_sticky_mobile = $specific_post_sticky_mobile;
			}

			$specific_post_overlay = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_header_overlay_' . get_post_type(), true );

			if ( '' !== $specific_post_overlay ) {
				$header_overlay = $specific_post_overlay;
			}
		}

		// var_dump($header_sticky);
		// var_dump($header_sticky_mobile);
		// var_dump($header_overlay);

		$fixed = '';

		// 横レイアウトの場合
		if ( get_theme_mod( 'setting_header_layout', 'default' ) === 'default' ) {
			// Stickyのみ
			if ( $header_sticky ) {
				$fixed = 'sticky';
			}

			// オーバーレイのみ
			if ( $header_overlay ) {
				$fixed = 'header-overlay';
			}

			// 両方
			if ( $header_sticky && $header_overlay ) {
				$fixed = 'header-overlay-sticky';
			}
		}

		// 縦レイアウトの場合
		if ( get_theme_mod( 'setting_header_layout', 'default' ) === 'center' ) {
			// Stickyのみ
			if ( $header_sticky_mobile ) {
				$fixed = 'sticky-mobile';
			}

			// オーバーレイのみ
			if ( $header_overlay ) {
				$fixed = 'header-overlay';
			}

			// 両方
			if ( $header_sticky_mobile && $header_overlay ) {
				$fixed = 'sticky-mobile header-overlay';
			}
		}

		if ( get_theme_mod( 'setting_header_global_nav_design_pattern', '01' ) ) {
			$fixed .= ' nishiki-pro-global-nav-style nishiki-pro-global-nav-style-' . get_theme_mod( 'setting_header_global_nav_design_pattern', '01' );
		}

		if ( get_theme_mod( 'setting_header_button_design_pattern', '02' ) ) {
			$fixed .= ' nishiki-pro-header-button-style nishiki-pro-header-button-style-' . get_theme_mod( 'setting_header_button_design_pattern', '02' );
		}

		// 背景ぼかし
		if ( get_theme_mod( 'setting_header_backdrop_blur' ) ) {
			$fixed .= ' ' . get_theme_mod( 'setting_header_backdrop_blur' );
		}

		$classes = apply_filters( 'nishiki_pro_masthead_class', $fixed );

		if ( empty( $classes ) ) {
			return false;
		}

		echo ' class="' . esc_attr( $classes ) . '"';
	}
}

/*****************
 * Add Campaign Link
 */

if ( ! function_exists( 'nishiki_pro_add_campaign_link' ) ) {
	/**
	 * キャンペーンリンク（お知らせ）の表示/非表示
	 *
	 * @return void
	 */
	function nishiki_pro_add_campaign_link() {
		$options = get_option( 'nishiki_pro_campaign_link' );

		$flag = false;

		if ( is_front_page() && is_home() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_top' ) ) {
				$flag = true;
			}
		} elseif ( is_front_page() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_top' ) ) {
				$flag = true;
			}
		} elseif ( is_home() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_archive' ) ) {
				$flag = true;
			}
		} elseif ( is_singular() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_singular' ) ) {
				$flag = true;
			}

			if ( get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_campaign_' . get_post_type(), true ) ) {
				$flag = false;
			}
		} elseif ( is_archive() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_archive' ) ) {
				$flag = true;
			}
		} elseif ( is_404() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_404' ) ) {
				$flag = true;
			}
		} elseif ( is_search() ) {
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_search' ) ) {
				$flag = true;
			}
		}

		if ( false === $flag ) {
			return;
		}

		$output = '';

		$campaign_layout = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout', 'text-button' );

		$output .= '<section id="nishiki-pro-campaign-before-content" class="nishiki-pro-campaign"><div class="nishiki-pro-campaign-wrap ' . esc_attr( $campaign_layout ) . '">';

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text' ) ) {
			$campaign_text           = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text' );
			$campaign_text_target    = '';
			$campaign_text_animation = '';

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_text_typewriter' ) ) {
				$campaign_text_animation = ' effect-text-typewriter';
			}

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target' ) ) {
				$campaign_text_target = ' target="_blank" rel="noopener noreferrer"';
			}

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link' ) ) {
				$campaign_text = '<a class="campaign-text-link"' . $campaign_text_target . ' href="' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link' ) . '">' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text' ) . '</a>';
			}

			$output .= '<div class="campaign-text' . $campaign_text_animation . '"><p>' . $campaign_text . '</p></div>';
		}

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text' ) ) {
			$campaign_button_text        = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text' );
			$campaign_button_link_target = '';
			$campaign_button_animation   = '';

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_button_shine' ) ) {
				$campaign_button_animation = ' effect-button-shine';
			}

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link_target' ) ) {
				$campaign_button_link_target = ' target="_blank" rel="noopener noreferrer"';
			}

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link' ) ) {
				$campaign_button_text = '<a class="campaign-button-link"' . $campaign_button_link_target . ' href="' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link' ) . '">' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text' ) . '</a>';
			}

			$output .= '<p class="campaign-button' . $campaign_button_animation . '">' . $campaign_button_text . '</p>';
		}

		$output .= '</div></section>';

		echo wp_kses_post( $output );
	}

	add_action( 'nishiki_pro_before_content', 'nishiki_pro_add_campaign_link', 10 );
}

/*****************
 * Add Body Class(global_nav)
 */

if ( ! function_exists( 'nishiki_pro_add_body_class_global_nav' ) ) {
	/**
	 * Body 要素に追加するクラス
	 *
	 * @param array $classes クラス名
	 * @return $classes
	 */
	function nishiki_pro_add_body_class_global_nav( $classes ) {
		if ( get_theme_mod( 'setting_header_layout' ) === 'center' ) {
			$classes[] = 'header-center';
		}

		$header_ovarlay       = false;
		$header_sticky        = false;
		$header_menu_collapse = false;

		// カスタマイザーの設定
		if ( get_theme_mod( 'setting_header_overlay' ) ) {
			$header_ovarlay = true;
		}

		if ( get_theme_mod( 'setting_header_fixed' ) ) {
			$header_sticky = true;
		}

		if ( get_theme_mod( 'setting_header_menu_collapse' ) ) {
			$header_menu_collapse = true;
		}

		// 個別設定を優先
		if ( is_singular() ) {
			// Overlay
			$specific_post_overlay = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_header_overlay_' . get_post_type(), true );

			if ( '' !== $specific_post_overlay ) {
				switch ( $specific_post_overlay ) {
					case 0:
						$header_ovarlay = false;
						break;
					case 1:
						$header_ovarlay = true;
						break;
				}
			}

			// Sticky
			$specific_post_sticky = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_header_sticky_' . get_post_type(), true );

			if ( '' !== $specific_post_sticky ) {
				switch ( $specific_post_sticky ) {
					case 0:
						$header_sticky = false;
						break;
					case 1:
						$header_sticky = true;
						break;
				}
			}
		}

		if ( $header_ovarlay ) {
			$classes[] = 'header-overlay';
		}

		if ( $header_sticky ) {
			$classes[] = 'header-sticky';
		}

		if ( $header_menu_collapse ) {
			$classes[] = 'header-menu-collapse';
		}

		return $classes;
	}

	add_filter( 'body_class', 'nishiki_pro_add_body_class_global_nav' );
}

/*****************
 * Enqueue block editor style
 */

if ( ! function_exists( 'nishiki_pro_back_end_styles' ) ) {
	/**
	 * バックエンド用 CSS の読み込み
	 *
	 * @return void
	 */
	function nishiki_pro_back_end_styles() {
		wp_enqueue_style( 'nishiki-pro-back-end', get_theme_file_uri( '/assets/css/back-end.min.css' ), false, '1.0', 'all' );

		if( function_exists( 'nishiki_pro_customizer_css_block_editor' ) ) {
			wp_add_inline_style( 'nishiki-pro-back-end', nishiki_pro_customizer_css_block_editor() );
		}
	}

	add_action( 'enqueue_block_editor_assets', 'nishiki_pro_back_end_styles' );
}

/*****************
 * Remove Default block editor style
 */

if ( ! function_exists( 'nishiki_pro_remove_block_editor_styles' ) ) {
	/**
	 * ブロックエディターのスタイルを削除
	 *
	 * @return void
	 */
	function nishiki_pro_remove_block_editor_styles() {
		// wp_dequeue_style( 'wp-block-library' );
		// wp_dequeue_style( 'wp-block-library-theme' );
	}

	// add_action( 'wp_enqueue_scripts', 'nishiki_pro_remove_block_editor_styles' );
}

/*****************
 * Add Pingback
 */

if ( ! function_exists( 'nishiki_pro_custom_theme_support' ) ) {
	/**
	 * ピンバックの設定
	 *
	 * @return void
	 */
	function nishiki_pro_custom_theme_support() {
		if ( is_singular() && pings_open() ) {
			printf( '<link rel="pingback" href="%s">' . "\n", esc_url( get_bloginfo( 'pingback_url' ) ) );
		}
	}

	add_action( 'wp_head', 'nishiki_pro_pingback_header' );

}

/*****************
 * Check Front Page
 */

// Setting Front Page Check
if ( ! function_exists( 'nishiki_pro_front_page_template' ) ) {
	/**
	 * フロントページのテンプレート判別
	 *
	 * @param string $template テンプレート名
	 * @return string
	 */
	function nishiki_pro_front_page_template( $template ) {
		return is_home() ? '' : $template;
	}

	add_filter( 'frontpage_template', 'nishiki_pro_front_page_template' );
}

// Check Front Page
if ( ! function_exists( 'nishiki_pro_is_static_front_page' ) ) {
	/**
	 * フロントページかどうか判別
	 *
	 * @return boolean
	 */
	function nishiki_pro_is_static_front_page() {
		return ( is_front_page() && ! is_home() );
	}
}

/*****************
 * Check AMP Page
 */

// Check Front Page
if ( ! function_exists( 'nishiki_pro_is_amp' ) ) {
	/**
	 * AMP が有効かどうか判別
	 *
	 * @return boolean
	 */
	function nishiki_pro_is_amp() {
		if ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) {
			return true;
		} else {
			return false;
		}
	}
}

/*****************
 * Check Top Page
 */

// Check Top Page
if ( ! function_exists( 'nishiki_pro_is_top_page' ) ) {
	/**
	 * トップページかどうか判別
	 *
	 * @return boolean
	 */
	function nishiki_pro_is_top_page() {
		return ( is_front_page() || is_home() );
	}
}

/*****************
 * Check function exists
 */

// Check has_header_video()
if ( ! function_exists( 'nishiki_pro_has_header_video' ) ) {
	/**
	 * 動画に対応してるかどうか判別
	 *
	 * @return has_header_video()
	 */
	function nishiki_pro_has_header_video() {
		if ( function_exists( 'has_header_video' ) ) {
			return has_header_video();
		}

		return false;
	}
}

/*****************
 * Custom header
 */

if ( ! function_exists( 'nishiki_pro_header_video_settings' ) ) {
	/**
	 * メインビジュアルの動画設定
	 *
	 * @param array $settings 設定
	 * @return $settings
	 */
	function nishiki_pro_header_video_settings( $settings ) {
		$settings['width']         = 1280;
		$settings['height']        = 720;
		$settings['minWidth']      = 640;
		$settings['minHeight']     = 360;
		$settings['l10n']['pause'] = '<i class="icomoon icon-pause2"></i>';
		$settings['l10n']['play']  = '<i class="icomoon icon-play3"></i>';

		return $settings;
	}

	add_filter( 'header_video_settings', 'nishiki_pro_header_video_settings' );
}

if ( ! function_exists( 'nishiki_pro_header_image_tag' ) ) {
	/**
	 * メインビジュアルの画像関連
	 *
	 * @param string $html 文字列
	 * @param object $header オブジェクト
	 * @param array  $attr 属性
	 * @return string
	 */
	function nishiki_pro_header_image_tag( $html, $header, $attr ) {
		if ( empty( $attr['srcset'] ) ) {
			$attr['srcset'] = '';
		}
		if ( empty( $attr['sizes'] ) ) {
			$attr['sizes'] = '';
		}

		return '<img class="header-image" src="" data-src="' . $attr['src'] . '" width="' . $attr['width'] . '" height="' . $attr['height'] . '" alt="' . $attr['alt'] . '" data-srcset="' . $attr['srcset'] . '" sizes="' . $attr['sizes'] . '">';
	}

	add_filter( 'get_header_image_tag', 'nishiki_pro_header_image_tag', 10, 3 );
}

/*****************
 * Translate
 */

if( ! function_exists( 'nishiki_pro_load_textdomain' ) ) {
	function nishiki_pro_load_textdomain(){
		load_theme_textdomain( 'nishiki-pro', get_template_directory() . '/languages' );
	}

	add_action( 'after_setup_theme', 'nishiki_pro_load_textdomain' );
}

/*****************
 * Register Nav
 */

// Add Nav
if ( ! function_exists( 'nishiki_pro_register_nav' ) ) {
	/**
	 * ナビゲーションメニューの登録
	 *
	 * @return void
	 */
	function nishiki_pro_register_nav() {
		// Global Nav
		register_nav_menu( 'global', __( 'Global', 'nishiki-pro' ) );

		// Footer Nav
		register_nav_menu( 'footer', __( 'Footer', 'nishiki-pro' ) );
	}

	add_action( 'after_setup_theme', 'nishiki_pro_register_nav' );
}

/*****************
 * Disable & Delete
 */

// Disable Default Gallery Style
add_filter( 'use_default_gallery_style', '__return_false' );

/*****************
 * Add Post Type Support
 */
if ( ! function_exists( 'nishiki_pro_home_excerpt_length' ) ) {
	/**
	 * 固定ページに抜粋を追加
	 *
	 * @return void
	 */
	function nishiki_pro_add_page_excerpt() {
		add_post_type_support( 'page', 'excerpt' );
	}
	add_action( 'init', 'nishiki_pro_add_page_excerpt' );
}

/*****************
 * Excerpt
 */

// Excerpt
if ( ! function_exists( 'nishiki_pro_home_excerpt_length' ) ) {
	/**
	 * 抜粋の文字数
	 *
	 * @param int $excerpt 文字数
	 * @return $excerpt
	 */
	function nishiki_pro_home_excerpt_length( $excerpt ) {
		if ( is_admin() ) {
			return $excerpt;
		}

		if ( get_theme_mod( 'setting_archive_excerpt_text_num' ) ) {
			$excerpt = absint( get_theme_mod( 'setting_archive_excerpt_text_num' ) );
		} else {
			$excerpt = 50;
		}

		return $excerpt;
	}

	add_filter( 'excerpt_length', 'nishiki_pro_home_excerpt_length', 999 );
}

add_filter( 'get_the_excerpt', 'custom_trim_manual_excerpt', 10, 2 );

function custom_trim_manual_excerpt( $excerpt, $post ) {
    $max_length = 100; // 最大文字数
    if ( mb_strlen( $excerpt ) > $max_length ) {
        $excerpt = mb_substr( $excerpt, 0, $max_length ) . '…';
    }
    return $excerpt;
}

// Excerpt More
if ( ! function_exists( 'nishiki_pro_new_excerpt_more' ) ) {
	/**
	 * 抜粋を超えた時の文字列指定
	 *
	 * @param string $more 文字列
	 * @return $more
	 */
	function nishiki_pro_new_excerpt_more( $more ) {
		if ( is_admin() ) {
			return $more;
		}

		if ( get_theme_mod( 'setting_archive_excerpt_text' ) ) {
			$more = esc_html( get_theme_mod( 'setting_archive_excerpt_text' ) );
		} else {
			$more = '...';
		}

		return $more;
	}

	add_filter( 'excerpt_more', 'nishiki_pro_new_excerpt_more' );
}

/*****************
 * Title
 */

// Title Separator
if ( ! function_exists( 'nishiki_pro_header_title_sep' ) ) {
	/**
	 * タイトル要素のセパレーター
	 *
	 * @return string
	 */
	function nishiki_pro_header_title_sep() {
		return '|';
	}

	add_filter( 'document_title_separator', 'nishiki_pro_header_title_sep' );
}

// Archive Title
if ( ! function_exists( 'nishiki_pro_change_archive_title' ) ) {
	/**
	 * アーカイブページのタイトル
	 *
	 * @param string $title タイトル名
	 * @return $title
	 */
	function nishiki_pro_change_archive_title( $title ) {
		if ( is_category() || is_tag() ) {
			$title = single_cat_title( '', false );
		} elseif ( is_author() ) {
			$title = get_the_author_meta( 'display_name' );
		} elseif ( is_search() ) {
			$title = __( 'Search Result', 'nishiki-pro' );
		} elseif ( is_tax() ) {
			global $wp_query;
			$term  = $wp_query->get_queried_object();
			$title = $term->name;
		} elseif ( is_archive() ) {
			$get_title = single_cat_title( '', false );

			if ( ! empty( $get_title ) ) {
				$title = $get_title;
			}
		}

		return $title;
	}

	add_filter( 'get_the_archive_title', 'nishiki_pro_change_archive_title' );
}

// Change Title
if ( ! function_exists( 'nishiki_pro_change_title' ) ) {
	/**
	 * タイトル変更
	 *
	 * @param array $title タイトル
	 * @return $title
	 */
	function nishiki_pro_change_title( $title ) {
		if ( is_singular() && ! is_front_page() ) {
			$post_id        = get_the_ID();
			$singular_title = get_post_meta( $post_id, '_nishiki_pro_meta_box_title_' . get_post_type(), true );

			if ( ! empty( $singular_title ) ) {
				$title['title'] = esc_html( $singular_title );
			}
		}

		return $title;
	}

	add_filter( 'document_title_parts', 'nishiki_pro_change_title' );
}

// Change Top Title
if ( ! function_exists( 'nishiki_pro_change_top_title' ) ) {
	/**
	 * トップページのタイトル変更
	 *
	 * @param array $title タイトル
	 * @return $title
	 */
	function nishiki_pro_change_top_title( $title ) {
		$options = get_option( 'nishiki_pro_general_top' );

		if( is_singular() ){

			if( is_front_page() ){

				if ( ! empty( $options['title'] ) ) {
					$title['title']   = $options['title'];
				}

				if( ! empty( $options['description'] ) ){
					$title['tagline'] = $options['description'];
				} else {
					if( has_excerpt() ){
						$title['tagline'] = get_the_excerpt();
					} else {
						$title['tagline'] = get_bloginfo( 'description' );
					}
				}

			}

		}

		if( is_home() ){

			if ( ! empty( $options['title'] ) ) {
				$title['title']   = $options['title'];
			}

			if( ! empty( $options['description'] ) ){
				$title['tagline'] = $options['description'];
			} else {
				if( has_excerpt() ){
					$title['tagline'] = get_the_excerpt();
				} else {
					$title['tagline'] = get_bloginfo( 'description' );
				}
			}

		}

		return $title;
	}

	add_filter( 'document_title_parts', 'nishiki_pro_change_top_title' );
}

/*****************
 * OGP(Title)
 */

if ( ! function_exists( 'nishiki_pro_ogp_title' ) ) {
	/**
	 * OGP のタイトル
	 *
	 * @param array $og_title タイトル
	 * @return $og_title
	 */
	function nishiki_pro_ogp_title( $og_title ) {

		// Top
		if ( is_home() || is_front_page() ) {
			$options = get_option( 'nishiki_pro_general_top' );
			if ( ! empty( $options['title'] ) ) {
				$og_title = $options['title'];
			}
		}

		if ( is_category() || is_tag() || is_tax() ) {
			$og_title = wp_get_document_title();
		}

		return $og_title;
	}

	add_filter( NISHIKI_PRO_PREFIX_META . '_ogp_title', 'nishiki_pro_ogp_title' );
	add_filter( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_title', 'nishiki_pro_ogp_title' );
}

/*****************
 * OGP(Description)
 */

if ( ! function_exists( 'nishiki_pro_ogp_description' ) ) {
	/**
	 * OGP のディスクリプション
	 *
	 * @param array $og_description ディスクリプション
	 * @return $og_description
	 */
	function nishiki_pro_ogp_description( $og_description ) {

		// Top
		if ( is_home() || is_front_page() ) {
			$options = get_option( 'nishiki_pro_general_top' );
			if ( ! empty( $options['description'] ) ) {
				$og_description = $options['description'];
			}
		}

		// Archive
		if ( is_category() || is_tag() || is_tax() ) {
			if ( ! empty( term_description() ) ) {
				$og_description = str_replace( PHP_EOL, '', wp_strip_all_tags( term_description() ) );
			}
		}

		return $og_description;
	}

	add_filter( NISHIKI_PRO_PREFIX_META . '_ogp_description', 'nishiki_pro_ogp_description' );
	add_filter( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_description', 'nishiki_pro_ogp_description' );
}

/*****************
 * OGP(image)
 */

if ( ! function_exists( 'nishiki_pro_ogp_image' ) ) {
	/**
	 * OGP の画像
	 *
	 * @param string $og_image 画像の URL
	 * @return $og_image
	 */
	function nishiki_pro_ogp_image( $og_image ) {

		// Archive
		if ( is_category() || is_tag() || is_tax() ) {
			if ( ! empty( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;

				$attachment_id = get_term_meta( $term_id, 'eye_catch', true );
				$og_image      = wp_get_attachment_image_url( $attachment_id, 'thumbnail' );
			}
		}

		return $og_image;
	}

	add_filter( NISHIKI_PRO_PREFIX_META . '_ogp_image', 'nishiki_pro_ogp_image' );
	add_filter( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_image', 'nishiki_pro_ogp_image' );
}

/*****************
 * Register Widget Area
 */

// Register Widget Area
if ( ! function_exists( 'nishiki_pro_custom_widgets_init' ) ) {
	/**
	 * ウィジェットエリアの登録
	 *
	 * @return void
	 */
	function nishiki_pro_custom_widgets_init() {

		// Sidebar
		register_sidebar(
			array(
				'name'          => __( 'Sidebar', 'nishiki-pro' ),
				'id'            => 'sidebar_main',
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2>',
				'after_title'   => '</h2>',
			)
		);

		// Footer
		register_sidebar(
			array(
				'name'          => __( 'Footer', 'nishiki-pro' ),
				'id'            => 'footer_widget',
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2>',
				'after_title'   => '</h2>',
			)
		);
	}

	add_action( 'widgets_init', 'nishiki_pro_custom_widgets_init' );
}

/*****************
 * Tag Cloud
 */

// Custom Tag Cloud
if ( ! function_exists( 'nishiki_pro_custom_tag_cloud' ) ) {
	/**
	 * タグクラウドの設定
	 *
	 * @param array $args 設定
	 * @return $args
	 */
	function nishiki_pro_custom_tag_cloud( $args ) {
		$args['smallest'] = 10;
		$args['largest']  = 10;

		return $args;
	}

	add_filter( 'widget_tag_cloud_args', 'nishiki_pro_custom_tag_cloud' );
}

/**
 * Hides the custom post template for pages on WordPress 4.6 and older
 *
 * @param array $post_templates Array of page templates. Keys are filenames, values are translated names.
 * @return array Filtered array of page templates.
 */
if ( ! function_exists( 'nishiki_pro_makewp_exclude_page_templates' ) ) {
	/**
	 * テンプレートの除外
	 *
	 * @param array $post_templates テンプレート
	 * @return $post_templates
	 */
	function nishiki_pro_makewp_exclude_page_templates( $post_templates ) {
		if ( version_compare( $GLOBALS['wp_version'], '4.7', '<' ) || nishiki_pro_is_static_front_page() ) {
			unset( $post_templates['templates/sidebar-left.php'] );
			unset( $post_templates['templates/sidebar-bottom.php'] );
			unset( $post_templates['templates/sidebar-right.php'] );
			unset( $post_templates['templates/sidebar-none.php'] );
			unset( $post_templates['templates/content-full-width.php'] );
			unset( $post_templates['templates/content-only.php'] );
		}

		return $post_templates;
	}

	add_filter( 'theme_page_templates', 'nishiki_pro_makewp_exclude_page_templates' );
}

/*****************
 * Related Posts
 */

if ( ! function_exists( 'nishiki_pro_related_posts' ) ) {
	/**
	 * 関連記事
	 *
	 * @return void
	 */
	function nishiki_pro_related_posts() {
		if ( ! is_single() ) {
			return;
		}

		if ( ! apply_filters( 'nishiki_pro_is_singular_related_posts', get_theme_mod( 'setting_post_related_posts_display', false ) ) ) {
			return;
		}

		$post_id         = get_the_ID();
		$exclude_post_id = array( $post_id );

		$related_posts_num     = apply_filters( 'nishiki_pro_related_posts_num', get_theme_mod( 'setting_post_related_posts_number', 3 ) );
		$related_posts_text    = apply_filters( 'nishiki_pro_related_posts_text', get_theme_mod( 'setting_post_related_posts_text', __( 'Related Posts', 'nishiki-pro' ) ) );
		$related_posts_orderby = apply_filters( 'nishiki_pro_related_posts_orderby', get_theme_mod( 'setting_post_related_posts_orderby', 'date' ) );
		$related_posts_order   = apply_filters( 'nishiki_pro_related_posts_order', get_theme_mod( 'setting_post_related_posts_order', 'DESC' ) );
		$related_posts_columns = apply_filters( 'nishiki_pro_related_posts_columns', get_theme_mod( 'setting_post_related_posts_columns', 3 ) );
		?>
			<section class="related-posts">
			<?php
			// Related Posts
			// $tags = wp_get_post_tags( $post_id );
			$terms = apply_filters( 'nishiki_pro_related_posts_terms', wp_get_post_tags( $post_id ) );

			if ( $terms ) {
				$term_ids = array();
				foreach ( $terms as $term ) {
					$term_ids[] = $term->term_id;
				}
				$args = array(
					'tag__in'             => $term_ids,
					'post__not_in'        => $exclude_post_id,
					'posts_per_page'      => $related_posts_num,
					'orderby'             => $related_posts_orderby,
					'order'               => $related_posts_order,
					'ignore_sticky_posts' => 1,
				);

				$related_query = new WP_Query( apply_filters( 'nishiki_pro_related_posts_query', $args ) );

				$found_posts   = $related_query->found_posts;
				$request_posts = $related_query->query['posts_per_page'];

				$layout       = apply_filters( 'nishiki_pro_archive_article_layout', get_theme_mod( 'setting_archive_article_layout', '' ) );
				$layout_class = '';

				if ( $layout ) {
					$layout_class = ' is-' . $layout;
				}

				if ( $related_query->have_posts() ) {
					?>
					<div class="archives">
						<?php if ( '' !== $related_posts_text ) { ?>
						<h1 class="title"><?php echo esc_html( $related_posts_text ); ?></h1>
						<?php } ?>
						<div class="articles flex<?php echo esc_attr( $layout_class ) . ' column-' . esc_attr( $related_posts_columns ); ?>">
						<?php
						while ( $related_query->have_posts() ) {
							$related_query->the_post();
							$exclude_post_id[] = $related_query->post->ID;
							nishiki_pro_get_template_part( 'parts/archive/post' );
						}
						wp_reset_postdata();

						if ( $request_posts > $found_posts ) {
							$same_cat_post = $request_posts - $found_posts;
							nishiki_pro_category_posts( $same_cat_post, $exclude_post_id );
						}
						?>
						</div>
					</div>
					<?php
				} else {
					nishiki_pro_category_posts( $related_posts_num, $exclude_post_id, 'category', $related_posts_text, $related_posts_columns, $related_posts_order, $related_posts_orderby );
				}
			} else {
				nishiki_pro_category_posts( $related_posts_num, $exclude_post_id, 'category', $related_posts_text, $related_posts_columns, $related_posts_order, $related_posts_orderby );
			}
			?>
			</section>
		<?php
	}

	add_action( 'nishiki_pro_after_related_posts', 'nishiki_pro_related_posts' );
}

// Same Category Posts
if ( ! function_exists( 'nishiki_pro_category_posts' ) ) {
	/**
	 * カテゴリー別記事
	 *
	 * @param int    $num 投稿数
	 * @param array  $exclude 除外 ID
	 * @param string $type 投稿タイプ
	 * @param string $text 文字列
	 * @param string $columns カラム
	 * @return void
	 */
	function nishiki_pro_category_posts( $num, $exclude, $type = '', $text = '', $columns = '', $order = '', $orderby = '' ) {
		$cat = get_the_category();

		if ( $cat ) {
			$cat           = $cat[0];
			$category_link = get_category_link( $cat->cat_ID );

			$args = array(
				'cat'            => $cat->cat_ID,
				'posts_per_page' => $num,
				'post__not_in'   => $exclude,
				'offset'         => '0',
				'orderby'        => $orderby,
				'order'          => $order,
			);

			$cat_query = new wp_query( apply_filters( 'nishiki_pro_category_posts_query', $args ) );

			$found_posts   = $cat_query->found_posts;
			$request_posts = $cat_query->query['posts_per_page'];

			$layout       = apply_filters( 'nishiki_pro_archive_article_layout', get_theme_mod( 'setting_archive_article_layout', '' ) );
			$layout_class = '';

			if ( $layout ) {
				$layout_class = ' is-' . $layout;
			}

			if ( $cat_query->have_posts() ) {
				if ( 'category' === $type ) {
					?>
					<aside class="archives">
					<?php if ( '' !== $text ) { ?>
					<h1 class="title"><?php echo esc_html( $text ); ?></h1>
					<?php } ?>
						<div class="articles flex<?php echo esc_attr( $layout_class ) . ' column-' . esc_attr( $columns ); ?>">
					<?php
				}
				while ( $cat_query->have_posts() ) {
					$cat_query->the_post();
					nishiki_pro_get_template_part( 'parts/archive/post' );
				}
				wp_reset_postdata();

				if ( 'category' === $type ) {
					?>
						</div>
					</aside>
					<?php
				}
			}
		}
	}
}

// Get All Post Types.
if ( ! function_exists( 'nishiki_pro_get_all_post_types' ) ) {
	/**
	 * 全投稿タイプ取得
	 *
	 * @return $post_types_array
	 */
	function nishiki_pro_get_all_post_types() {

		$args = array(
			'public'   => true,
			'_builtin' => false,
		);

		$output   = 'names';
		$operator = 'and';

		$post_types = get_post_types( $args, $output, $operator );

		$post_types_array = array( 'post', 'page' );
		foreach ( $post_types  as $post_type ) {
			$post_types_array[] = $post_type;
		}

		return $post_types_array;
	}
}

// TOC Fixed Content.
if ( ! function_exists( 'nishiki_pro_toc_fixed' ) ) {
	/**
	 * 固定 TOCの設定
	 *
	 * @return void
	 */
	function nishiki_pro_toc_fixed() {
		if ( ! get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display', true ) ) {
			return;
		}

		if ( is_singular() && empty( get_post_meta( get_the_ID(), '_nishiki_pro_toc_disable_' . get_post_type(), true ) ) ) {
			do_action( 'nishiki_pro_toc_fixed_list' );
		}
	}

	add_action( 'nishiki_pro_after_inner_content', 'nishiki_pro_toc_fixed' );
}

/*****************
 * Output Meta(Description)
 */

if ( ! function_exists( 'nishiki_pro_meta_description' ) ) {
	/**
	 * メタ情報（ディスクリプション）
	 *
	 * @return void
	 */
	function nishiki_pro_meta_description() {
		$content = '';

		// Singular
		if ( is_singular() ) {
			
			global $post;
			setup_postdata( $post );
			$content = esc_attr( get_the_excerpt() );

			if( is_front_page() ){
				$options = get_option( 'nishiki_pro_general_top' );

				if ( ! empty( $options['description'] ) ) {
					$content = esc_attr( $options['description'] );
				} else {
					if( has_excerpt() ) {
						$content = esc_attr( get_the_excerpt() );
					} else {
						$content = esc_attr( get_bloginfo( 'description' ) );
					}
				}
			}

			wp_reset_postdata();
		}

		// Top
		if ( is_home() ) {
			global $post;
			setup_postdata( $post );
			$content = esc_attr( get_the_excerpt() );

			$options = get_option( 'nishiki_pro_general_top' );

			if ( ! empty( $options['description'] ) ) {
				$content = esc_attr( $options['description'] );
			} else {
				if( has_excerpt() ) {
					$content = esc_attr( get_the_excerpt() );
				} else {
					$content = esc_attr( get_bloginfo( 'description' ) );
				}
			}
		}

		// Archive
		if ( is_category() || is_tag() || is_tax() ) {
			if ( ! empty( term_description() ) ) {
				$content = str_replace( PHP_EOL, '', wp_strip_all_tags( term_description() ) );
			}
		}

		if ( ! empty( $content ) ) {
			echo '<meta name="description" content="' . $content . '">' . "\n"; // phpcs:ignore
		}

	}

	add_action( 'wp_head', 'nishiki_pro_meta_description', 1 );
}

/*****************
 * Output Meta(Thumbnail)
 */

if ( ! function_exists( 'nishiki_pro_meta_thumbnail' ) ) {
	/**
	 * メタ情報（サムネイル）
	 *
	 * @return boolean
	 */
	function nishiki_pro_meta_thumbnail() {
		$content = '';
		$flag    = true;

		if ( apply_filters( 'nishiki_pro_meta_thumbnail_display', $flag ) === false ) {
			return false;
		}

		// Singular
		if ( is_singular() ) {
			global $post;
			setup_postdata( $post );

			if ( has_post_thumbnail( $post->ID ) ) {
				$content = esc_url( get_the_post_thumbnail_url( $post->ID ) );
			}

			wp_reset_postdata();
		}

		// Archive
		if ( is_category() || is_tag() || is_tax() ) {
			if ( ! empty( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;

				$attachment_id = get_term_meta( $term_id, 'eye_catch', true );
				$content       = wp_get_attachment_image_url( $attachment_id, 'thumbnail' );
			}
		}

		// Content Filter
		$content = apply_filters( 'nishiki_pro_meta_thumbnail_content', $content );

		if ( ! empty( $content ) ) {
			echo '<meta name="thumbnail" content="' . esc_url( $content ) . '">' . "\n";
		}

	}

	add_action( 'wp_head', 'nishiki_pro_meta_thumbnail', 1 );
}

/*****************
 * Output Meta(noindex,nofollow)
 */

if ( ! function_exists( 'nishiki_pro_meta_noindex_nofollow' ) ) {
	/**
	 * Noindex nofollow 設定
	 *
	 * @return void
	 */
	function nishiki_pro_meta_noindex_nofollow() {

		if ( is_singular() ) {
			global $post;
			setup_postdata( $post );

			$post_setting_array = array();

			$post_noindex  = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_noindex_' . get_post_type(), true );
			$post_nofollow = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_nofollow_' . get_post_type(), true );

			if ( ! empty( $post_noindex ) ) {
				$post_setting_array[] = 'noindex';
			}

			if ( ! empty( $post_nofollow ) ) {
				$post_setting_array[] = 'nofollow';
			}

			if ( ! empty( $post_setting_array ) ) {
				echo '<meta name="robots" content="' . esc_html( trim( implode( ',', $post_setting_array ) ) ) . '">';
			}

			wp_reset_postdata();
		}

	}

	add_action( 'wp_head', 'nishiki_pro_meta_noindex_nofollow', 10 );
}

/*****************
 * Image Decoding Async
 */

if ( ! function_exists( 'nishiki_pro_decoding_async' ) ) {
	/**
	 * 画像のでコード設定
	 *
	 * @param string $content 文字列
	 * @return string
	 */
	function nishiki_pro_decoding_async( $content ) {
		return str_ireplace( '<img ', '<img decoding="async" ', $content );
	}
	add_filter( 'the_content', 'nishiki_pro_decoding_async', 10, 3 );
}

if ( ! function_exists( 'nishiki_pro_attachment_image_attributes' ) ) {
	/**
	 * 添付画像の属性
	 *
	 * @param array   $atts 属性
	 * @param WP_Post $attachment 添付
	 * @return $atts
	 */
	function nishiki_pro_attachment_image_attributes( $atts, $attachment ) {
		if ( ! array_key_exists( 'decoding', $atts ) ) {
			$atts['decoding'] = 'async';
		}

		return $atts;
	}
	add_filter( 'wp_get_attachment_image_attributes', 'nishiki_pro_attachment_image_attributes', 10, 3 );
}

/*****************
 * RSS Feed
 */

if ( ! function_exists( 'nishiki_pro_feed_rss2' ) ) {
	remove_action( 'do_feed_rss2', 'do_feed_rss2', 10 );
	/**
	 * RSS 設定
	 *
	 * @return void
	 */
	function nishiki_pro_feed_rss2() {
		$template_file = '/feed/feed-rss2.php';
		load_template( get_template_directory() . $template_file );
	}
	add_action( 'do_feed_rss2', 'nishiki_pro_feed_rss2', 10 );
}

// Rss にアイキャッチ画像を追加
if ( ! function_exists( 'nishiki_pro_feed_add_thumbnail' ) ) {
	/**
	 * RSS にアイキャッチ画像を追加
	 *
	 * @param string $content 文字列
	 * @return $content
	 */
	function nishiki_pro_feed_add_thumbnail( $content ) {
		global $post;

		$image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'thumbnail' );

		if ( has_post_thumbnail( $post->ID ) ) {
			$content = '<thumbnail>' . $image_url[0] . '</thumbnail><text>' . $content . '</text>';
		}
		return $content;
	}
}

// add_filter('the_excerpt_rss', 'rss_post_thumbnail');

/*****************
 * Sidebar Settings
 */
if ( ! function_exists( 'nishiki_pro_sidebar_settings' ) ) {
	/**
	 * サイドバーの設定
	 *
	 * @return void
	 */
	function nishiki_pro_sidebar_settings() {
		if ( ! apply_filters( 'nishiki_pro_is_sidebar', true ) ) {
			return;
		}

		$display_sidebar = false;

		// Singular
		if ( is_singular() ) {
			if ( ! is_page_template( 'templates/sidebar-none.php' ) ) {
				if (
					( is_single() && get_theme_mod( 'setting_post_column', 'none' ) !== 'none' ) ||
					( is_page() && get_theme_mod( 'setting_page_column', 'none' ) !== 'none' ) ||
					is_page_template( 'templates/sidebar-left.php' ) ||
					is_page_template( 'templates/sidebar-right.php' ) ||
					is_page_template( 'templates/sidebar-bottom.php' )
					) {

					$display_sidebar = true;
				}

			}
		}

		// Archive
		if ( is_archive() ) {
			if ( get_theme_mod( 'setting_archive_column', 'none' ) !== 'none' ) {
					$display_sidebar = true;
			}
		}

		// Index
		if ( ( is_home() && ! nishiki_pro_is_static_front_page() ) && get_theme_mod( 'setting_archive_column', 'none' ) !== 'none' ) {
			$display_sidebar = true;
		}

		// Error404
		if ( is_404() && get_theme_mod( 'setting_error404_column', 'none' ) !== 'none' ) {
			$display_sidebar = true;
		}

		// Search
		if ( is_search() && get_theme_mod( 'setting_search_column', 'none' ) !== 'none' ) {
			$display_sidebar = true;
		}

		if ( $display_sidebar ) {
			nishiki_pro_get_sidebar( apply_filters( 'nishiki_pro_sidebar_template_path', '' ) );
		}

	}
	add_action( 'nishiki_pro_sidebar', 'nishiki_pro_sidebar_settings', 10 );
}

/*****************
 * Get Sidebar
 */
if ( ! function_exists( 'nishiki_pro_load_template' ) ) {
	function nishiki_pro_get_sidebar( $file_path = '',  $require_once = true, $args = array() ) {
		if ( '' !== $file_path ) {

			if ( file_exists( $file_path ) ) {
				load_template( $file_path, $require_once );
			}
		} else {
			get_sidebar( apply_filters( 'nishiki_pro_sidebar_template', '' ) );
		}
	}
}

/*****************
 * Get Template
 */
if ( ! function_exists( 'nishiki_pro_get_template_part' ) ) {
	/**
	 * テンプレートファイル読み込み
	 *
	 * @param string  $slug スラッグ
	 * @param string  $name 名前
	 * @param array   $args 変数の配列
	 * @param string  $file_path パス
	 * @param boolean $require_once require か require_once
	 * @return void
	 */
	function nishiki_pro_get_template_part( $slug, $name = null, $args = array(), $file_path = '' ) {

		do_action( "nishiki_pro_get_template_part_{$slug}", $slug, $name, $args, $file_path );

		$name      = apply_filters( "nishiki_pro_get_template_part_name_{$slug}", $name );
		$args      = apply_filters( "nishiki_pro_get_template_part_args_{$slug}", $args );
		$file_path = apply_filters( "nishiki_pro_get_template_part_path_{$slug}", $file_path );

		$templates = array();
		$name      = (string) $name;
		if ( '' !== $name ) {
			$templates[] = "{$slug}-{$name}.php";
		}

		$templates[] = "{$slug}.php";

		do_action( 'nishiki_pro_get_template_part', $slug, $name, $templates, $args, $file_path );

		if ( ! nishiki_pro_locate_template( $templates, true, false, $args, $file_path ) ) {
			return false;
		}

	}
}

/*****************
 * Locate Template
 */

if ( ! function_exists( 'nishiki_pro_locate_template' ) ) {
	function nishiki_pro_locate_template( $template_names, $load = false, $require_once = true, $args = array(), $file_path = '' ){
		$located = '';
		foreach ( (array) $template_names as $template_name ) {
			if ( ! $template_name ) {
				continue;
			}

			if ( '' !== $file_path && file_exists( $file_path . '/' . $template_name ) ) {
				$located = $file_path . '/' . $template_name;
				break;
			} elseif ( file_exists( STYLESHEETPATH . '/' . $template_name ) ) {
				$located = STYLESHEETPATH . '/' . $template_name;
				break;
			} elseif ( file_exists( TEMPLATEPATH . '/' . $template_name ) ) {
				$located = TEMPLATEPATH . '/' . $template_name;
				break;
			} elseif ( file_exists( ABSPATH . WPINC . '/theme-compat/' . $template_name ) ) {
				$located = ABSPATH . WPINC . '/theme-compat/' . $template_name;
				break;
			}
		}
	
		if ( $load && '' !== $located ) {
			load_template( $located, $require_once, $args );
		}
	
		return $located;
	}
}

/*****************
 * Load Template
 */

if ( ! function_exists( 'nishiki_pro_load_template' ) ) {
	function nishiki_pro_load_template( $_template_file, $require_once = true, $args = array(), $filepath = '' ) {
		global $posts, $post, $wp_did_header, $wp_query, $wp_rewrite, $wpdb, $wp_version, $wp, $id, $comment, $user_ID;
	
		if ( is_array( $wp_query->query_vars ) ) {
			/*
			 * This use of extract() cannot be removed. There are many possible ways that
			 * templates could depend on variables that it creates existing, and no way to
			 * detect and deprecate it.
			 *
			 * Passing the EXTR_SKIP flag is the safest option, ensuring globals and
			 * function variables cannot be overwritten.
			 */
			// phpcs:ignore WordPress.PHP.DontExtract.extract_extract
			extract( $wp_query->query_vars, EXTR_SKIP );
		}
	
		if ( isset( $s ) ) {
			$s = esc_attr( $s );
		}
	
		do_action( 'nishiki_pro_before_load_template', $_template_file, $require_once, $args, $file_path );
	
		if ( $require_once ) {
			require_once $_template_file;
		} else {
			require $_template_file;
		}
	
		do_action( 'nishiki_pro_after_load_template', $_template_file, $require_once, $args, $file_path );
	}
}

/*****************
 * Content Sidebar Class
 */

// Add Content Class
if ( ! function_exists( 'nishiki_pro_content_sidebar_class' ) ) {
	/**
	 * サイドバーのクラス名
	 *
	 * @param string $class クラス名
	 * @return $class
	 */
	function nishiki_pro_content_sidebar_class( $class ) {
		if ( is_single() && get_theme_mod( 'setting_post_column', 'none' ) ) {
			$class = ' sidebar-' . get_theme_mod( 'setting_post_column', 'none' );
		} elseif ( is_page() && ! is_front_page() && get_theme_mod( 'setting_page_column', 'none' ) ) {
			$class = ' sidebar-' . get_theme_mod( 'setting_page_column', 'none' );
		} elseif( is_search() && get_theme_mod( 'setting_search_column', 'none' ) ) {
			$class = ' sidebar-' . get_theme_mod( 'setting_search_column', 'none' );
		} elseif( is_404() && get_theme_mod( 'setting_error404_column', 'none' ) ) {
			$class = ' sidebar-' . get_theme_mod( 'setting_error404_column', 'none' );
		} elseif ( ( is_archive() || ! nishiki_pro_is_static_front_page() ) && get_theme_mod( 'setting_archive_column', 'none' ) ) {
			$class = ' sidebar-' . get_theme_mod( 'setting_archive_column', 'none' );
		}

		if ( is_front_page() && get_option( 'show_on_front' ) === 'page' ) {
			$class .= ' show-on-front-page';
		}

		return $class;
	}

	add_filter( 'nishiki_pro_content_class', 'nishiki_pro_content_sidebar_class', 10 );
}

/*****************
 * Dark Mode
 */
if ( ! function_exists( 'nishiki_pro_dark_mode_enable' ) ) {
	/**
	 * ダークモードの設定
	 *
	 * @return void
	 */
	function nishiki_pro_dark_mode_enable() {
		if ( ! get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_enable' ) ) {
			return;
		}
		?>
		<div class="theme-switch-wrapper">
			<label class="theme-switch" for="checkbox">
				<input type="checkbox" id="checkbox" />
				<i class="icomoon icon-brightness-contrast"></i>
			</label>
		</div>
		<?php
	}

	add_action( 'nishiki_pro_after_site_footer_content_inner', 'nishiki_pro_dark_mode_enable', 100 );
}

/*****************
 * Heading Style Elements
 */
if ( ! function_exists( 'nishiki_pro_heading_style_elements' ) ) {
	/**
	 * カスタマイザーの見出しのスタイル
	 *
	 * @param string  $element 要素名
	 * @param string  $pseudo_element 擬似要素名
	 * @param boolean $frontend フロントエンド用
	 * @param boolean $backend バックエンド用
	 * @return $elements
	 */
	function nishiki_pro_heading_style_elements( $element, $pseudo_element = '', $frontend = true, $backend = true ) {
		if ( '' !== $pseudo_element ) {
			$pseudo_element = '::' . $pseudo_element;
		}

		$elements_array = array();

		if ( $frontend ) {
			array_push(
				$elements_array,
				".entry-content {$element}:not([class*='is-style-']):not(.articles .post-title){$pseudo_element}",
				".nishiki-pro-content {$element}:not([class*='is-style-']):not(.articles .post-title){$pseudo_element}"
			);
		}

		if ( $backend ) {
			array_push(
				$elements_array,
				"body#tinymce.wp-editor {$element}:not([class*='is-style-']):not(.articles .post-title){$pseudo_element}",
				".editor-styles-wrapper {$element}:not([class*='is-style-']):not(.articles .post-title){$pseudo_element}"
			);
		}

		$elements = implode( ',', $elements_array );

		$elements .= '{';

		// var_dump($elements);
		// var_dump($elements2);

		return $elements;
	}
}

/*****************
 * Eye Catch Layout(Blog Page)
 */

if ( ! function_exists( 'nishiki_pro_blog_page_eye_catch_layout' ) ) {
	/**
	 * アイキャッチ画像のレイアウト
	 *
	 * @param int    $page_id ページ ID
	 * @param string $class 文字列
	 * @return $output
	 */
	function nishiki_pro_blog_page_eye_catch_layout( $page_id, $class = '' ) {
		if ( ! has_post_thumbnail( $page_id ) ) {
			return false;
		}

		$output    = '';
		$eye_catch = get_the_post_thumbnail( $page_id, 'full' );
		if ( ! empty( $class ) ) {
			$class = ' ' . $class;
		}

		$output .= '<div class="eye-catch' . $class . '">';
		$output .= $eye_catch;
		$output .= '</div>';

		return $output;
	}
}

if ( ! function_exists( 'nishiki_pro_blog_page_eye_catch_output' ) ) {
	/**
	 * ページのアイキャッチ画像の出力
	 *
	 * @return boolean
	 */
	function nishiki_pro_blog_page_eye_catch_output() {
		// ブログページ
		if ( ! is_front_page() && is_home() ) {
			$blog_page_id     = get_option( 'page_for_posts' );
			$eye_catch_layout = get_theme_mod( 'setting_page_eye_catch_layout', 'background' );
			$value            = get_post_meta( $blog_page_id, '_nishiki_pro_meta_box_eye_catch_layout_page', true );
			$class            = '';
			$hook_name        = '';

			if ( $value ) {
				$eye_catch_layout = $value;
			}

			switch ( $eye_catch_layout ){

				case 'top':

					$hook_name = 'nishiki_pro_before_home_header';
					$class = 'title-top';

					break;

				case 'bottom':

					$hook_name = 'nishiki_pro_after_home_header';
					$class = 'title-bottom';

					break;

				case 'content':

					$hook_name = 'nishiki_pro_before_home_inner_container';
					$class = 'inner-content';

					break;

				case 'content-wide':

					$hook_name = 'nishiki_pro_before_home_container';
					$class = 'container content-wide';

					break;
			}

			if( ! empty( $hook_name ) ){
				add_action(
					$hook_name,
					function() use ( $blog_page_id, $class ) {
						do_action( 'nishiki_pro_before_blog_page_eye_catch' );
						echo wp_kses_post( nishiki_pro_blog_page_eye_catch_layout( $blog_page_id, $class ) );
						do_action( 'nishiki_pro_after_blog_page_eye_catch' );
					},
					100
				);
			}

		} else {
			return false;
		}
	}
	add_action( 'template_redirect', 'nishiki_pro_blog_page_eye_catch_output', 100 );
}

/*****************
 * Eye Catch Layout(Post)
 */

if ( ! function_exists( 'nishiki_pro_post_eye_catch_layout' ) ) {
	/**
	 * 投稿ページのアイキャッチ画像のレイアウト
	 *
	 * @param object $post 投稿オブジェクト
	 * @param string $class クラス名
	 * @return $output
	 */
	function nishiki_pro_post_eye_catch_layout( $post, $class = '' ) {
		if ( ! has_post_thumbnail( $post->ID ) ) {
			return false;
		}

		$output    = '';
		$eye_catch = get_the_post_thumbnail( $post->ID, 'full' );
		if ( ! empty( $class ) ) {
			$class = ' ' . $class;
		}

		$output .= '<div class="eye-catch' . $class . '">';
		$output .= $eye_catch;
		$output .= '</div>';

		return $output;
	}
}

// 投稿のアイキャッチレイアウト
if ( ! function_exists( 'nishiki_pro_post_eye_catch_output' ) ) {
	/**
	 * 投稿のアイキャッチレイアウト（出力）
	 *
	 * @return boolean
	 */
	function nishiki_pro_post_eye_catch_output() {
		if ( ! is_singular() ) {
			return false;
		}

		global $post;

		if ( ! has_post_thumbnail( $post->ID ) ) {
			return false;
		}

		$eye_catch_layout = '';

		// if( is_single() && get_theme_mod( 'setting_post_eye_catch', false ) == true ){
		// $eye_catch_layout = get_theme_mod( 'setting_post_eye_catch_layout', 'background' );
		// }

		if ( is_single() ) {
			$eye_catch_layout = get_theme_mod( 'setting_post_eye_catch_layout', 'background' );

			if ( get_theme_mod( 'setting_post_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}
		}

		if ( is_page() ) {
			$eye_catch_layout = get_theme_mod( 'setting_page_eye_catch_layout', 'background' );

			if ( get_theme_mod( 'setting_page_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}
		}

		$value     = get_post_meta( $post->ID, '_nishiki_pro_meta_box_eye_catch_layout_' . get_post_type(), true );
		$class     = '';
		$hook_name = '';

		if ( $value ) {
			$eye_catch_layout = $value;
		}

		switch ( $eye_catch_layout ){

			case 'top':

				$hook_name = 'nishiki_pro_before_singular_header';
				$class = 'title-top';

				break;

			case 'bottom':

				$hook_name = 'nishiki_pro_after_singular_header';
				$class = 'title-bottom';

				break;

			case 'content':

				$hook_name = 'nishiki_pro_before_singular_inner_content';
				$class = 'inner-content';

				break;

			case 'content-wide':

				$hook_name = 'nishiki_pro_before_singular_container';
				$class = 'container content-wide';

				break;
		}

		if( ! empty( $hook_name ) ){
			add_action(
				$hook_name,
				function() use ( $post, $class ) {
					do_action( 'nishiki_pro_before_singular_eye_catch' );
					echo wp_kses_post( nishiki_pro_post_eye_catch_layout( $post, $class ) );
					do_action( 'nishiki_pro_after_singular_eye_catch' );
				},
				100
			);
		}

	}

	add_action( 'template_redirect', 'nishiki_pro_post_eye_catch_output', 100 );
}

/*****************
 * Eye Catch Layout(Archive)
 */

if ( ! function_exists( 'nishiki_pro_archive_eye_catch_layout' ) ) {
	/**
	 * アーカイブページのアイキャッチ画像レイアウト
	 *
	 * @param int    $term_id ターム ID
	 * @param string $class クラス名
	 * @return $output
	 */
	function nishiki_pro_archive_eye_catch_layout( $term_id, $class = '' ) {
		if ( ! $term_id ) {
			return false;
		}

		$output = '';

		$attachment_id = get_term_meta( $term_id, 'eye_catch', true );
		$eye_catch_alt = get_term_meta( $term_id, 'eye_catch_alt', true );

		$args = array(
			'alt' => $eye_catch_alt,
		);

		$eye_catch = wp_get_attachment_image( $attachment_id, '', '', $args );
		if ( ! empty( $class ) ) {
			$class = ' ' . $class;
		}

		$output .= '<div class="eye-catch' . $class . '">';
		$output .= $eye_catch;
		$output .= '</div>';

		return $output;
	}
}

// アーカイブページのアイキャッチレイアウト
if ( ! function_exists( 'nishiki_pro_archive_eye_catch_output' ) ) {
	/**
	 * アーカイブページのアイキャッチ画像レイアウト（アウトプット）
	 *
	 * @return boolean
	 */
	function nishiki_pro_archive_eye_catch_output() {
		if ( ! is_archive() ) {
			return false;
		}

		if ( empty( get_queried_object()->term_id ) ) {
			return false;
		}

		$term_id = get_queried_object()->term_id;

		// カスタマイザーの設定（レイアウト）
		$eye_catch_layout = get_theme_mod( 'setting_archive_eye_catch_layout', 'background' );

		// カスタマイザーの設定が非表示の場合
		if ( get_theme_mod( 'setting_archive_eye_catch', false ) === false ) {
			$eye_catch_layout = 'none';
		}

		// metaboxの設定があれば優先
		$value = get_term_meta( $term_id, 'eye_catch_layout', true );
		$class     = '';
		$hook_name = '';

		if ( $value ) {
			$eye_catch_layout = $value;
		}

		switch ( $eye_catch_layout ){

			case 'top':

				$hook_name = 'nishiki_pro_before_archive_header';
				$class = 'title-top';

				break;

			case 'bottom':

				$hook_name = 'nishiki_pro_after_archive_header';
				$class = 'title-bottom';

				break;

			case 'content':

				$hook_name = 'nishiki_pro_before_archive_inner_archives';
				$class = 'inner-content';

				break;

			case 'content-wide':

				$hook_name = 'nishiki_pro_before_archive_container';
				$class = 'container content-wide';

				break;
		}

		if( ! empty( $hook_name ) ){
			add_action(
				$hook_name,
				function() use ( $term_id, $class ) {
					do_action( 'nishiki_pro_before_archive_eye_catch' );
					echo wp_kses_post( nishiki_pro_archive_eye_catch_layout( $term_id, $class ) );
					do_action( 'nishiki_pro_after_archive_eye_catch' );
				},
				100
			);
		}

	}

	add_action( 'template_redirect', 'nishiki_pro_archive_eye_catch_output', 100 );
}

/*****************
 * Eye Catch Layout(Search)
 */

if ( ! function_exists( 'nishiki_pro_search_eye_catch_layout' ) ) {
	/**
	 * 検索結果ページのアイキャッチ画像レイアウト
	 *
	 * @param string $class クラス名
	 * @return $output
	 */
	function nishiki_pro_search_eye_catch_layout( $class = '' ) {

		$output = '';

		$image         = get_theme_mod( 'setting_search_title_eye_catch' );
		$eye_catch_alt = get_theme_mod( 'setting_search_title_eye_catch_alt' );
		$attachment_id = attachment_url_to_postid( $image );

		$args = array(
			'alt' => $eye_catch_alt,
		);

		$eye_catch = wp_get_attachment_image( $attachment_id, '', '', $args );
		if ( ! empty( $class ) ) {
			$class = ' ' . $class;
		}

		$output .= '<div class="eye-catch' . $class . '">';
		$output .= $eye_catch;
		$output .= '</div>';

		return $output;
	}
}

// 検索結果ページのアイキャッチレイアウト
if ( ! function_exists( 'nishiki_pro_search_eye_catch_output' ) ) {
	/**
	 * 検索結果ページのアイキャッチ画像レイアウト（アウトプット）
	 *
	 * @return boolean
	 */
	function nishiki_pro_search_eye_catch_output() {
		if ( ! is_search() ) {
			return false;
		}

		// カスタマイザーの設定（レイアウト）
		$eye_catch_layout = get_theme_mod( 'setting_search_title_eye_catch_layout', 'background' );

		// カスタマイザーの設定が非表示の場合
		if ( get_theme_mod( 'setting_search_title_eye_catch_display', false ) === false ) {
			$eye_catch_layout = 'none';
		}

		// metaboxの設定があれば優先
		$class     = '';
		$hook_name = '';

		switch ( $eye_catch_layout ){

			case 'top':

				$hook_name = 'nishiki_pro_before_search_header';
				$class = 'title-top';

				break;

			case 'bottom':

				$hook_name = 'nishiki_pro_after_search_header';
				$class = 'title-bottom';

				break;

			case 'content':

				$hook_name = 'nishiki_pro_before_archive_inner_archives';
				$class = 'inner-content';

				break;

			case 'content-wide':

				$hook_name = 'nishiki_pro_before_search_container';
				$class = 'container content-wide';

				break;
		}

		if( ! empty( $hook_name ) ){
			add_action(
				$hook_name,
				function() use ( $class ) {
					do_action( 'nishiki_pro_before_search_eye_catch' );
					echo wp_kses_post( nishiki_pro_search_eye_catch_layout( $class ) );
					do_action( 'nishiki_pro_after_search_eye_catch' );
				},
				100
			);
		}

	}

	add_action( 'template_redirect', 'nishiki_pro_search_eye_catch_output', 100 );
}

/*****************
 * Eye Catch Layout(Error404)
 */

if ( ! function_exists( 'nishiki_pro_error404_eye_catch_layout' ) ) {
	/**
	 * 404ページのアイキャッチ画像レイアウト
	 *
	 * @param string $class クラス名
	 * @return $output
	 */
	function nishiki_pro_error404_eye_catch_layout( $class = '' ) {

		$output = '';

		$image         = get_theme_mod( 'setting_error404_title_eye_catch' );
		$eye_catch_alt = get_theme_mod( 'setting_error404_title_eye_catch_alt' );
		$attachment_id = attachment_url_to_postid( $image );

		$args = array(
			'alt' => $eye_catch_alt,
		);

		$eye_catch = wp_get_attachment_image( $attachment_id, '', '', $args );
		if ( ! empty( $class ) ) {
			$class = ' ' . $class;
		}

		$output .= '<div class="eye-catch' . $class . '">';
		$output .= $eye_catch;
		$output .= '</div>';

		return $output;
	}
}

// 検索結果ページのアイキャッチレイアウト
if ( ! function_exists( 'nishiki_pro_error404_eye_catch_output' ) ) {
	/**
	 * 404ページのアイキャッチ画像レイアウト（アウトプット）
	 *
	 * @return boolean
	 */
	function nishiki_pro_error404_eye_catch_output() {
		if ( ! is_404() ) {
			return false;
		}

		// カスタマイザーの設定（レイアウト）
		$eye_catch_layout = get_theme_mod( 'setting_error404_title_eye_catch_layout', 'background' );

		// カスタマイザーの設定が非表示の場合
		if ( get_theme_mod( 'setting_error404_title_eye_catch_display', false ) === false ) {
			$eye_catch_layout = 'none';
		}

		// metaboxの設定があれば優先
		$class     = '';
		$hook_name = '';

		switch ( $eye_catch_layout ){

			case 'top':

				$hook_name = 'nishiki_pro_before_404_header';
				$class = 'title-top';

				break;

			case 'bottom':

				$hook_name = 'nishiki_pro_after_404_header';
				$class = 'title-bottom';

				break;

			case 'content':

				$hook_name = 'nishiki_pro_before_archive_inner_archives';
				$class = 'inner-content';

				break;

			case 'content-wide':

				$hook_name = 'nishiki_pro_before_404_container';
				$class = 'container content-wide';

				break;
		}

		if( ! empty( $hook_name ) ){
			add_action(
				$hook_name,
				function() use ( $class ) {
					do_action( 'nishiki_pro_before_404_eye_catch' );
					echo wp_kses_post( nishiki_pro_error404_eye_catch_layout( $class ) );
					do_action( 'nishiki_pro_after_404_eye_catch' );
				},
				100
			);
		}

	}

	add_action( 'template_redirect', 'nishiki_pro_error404_eye_catch_output', 100 );
}

// Add Custom CSS Minify.
if ( ! function_exists( 'nishiki_pro_custom_css_minify' ) ) {
	/**
	 * カスタマイザーの CSS を minify
	 *
	 * @param string $css CSS の文字列
	 * @return $css
	 */
	function nishiki_pro_custom_css_minify( $css ) {
		if ( '' !== $css ) {
			// Delete comment.
			$css = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css );

			// Remove tabs, line breaks.
			$css = str_replace( array( "\r\n", "\r", "\n", "\t" ), '', $css );

			// Remove spaces.
			$css = str_replace( array( '  ', '    ', '    ' ), '', $css );

			// Remove other spaces.
			$css = str_replace( ': ', ':', $css );
		}
		return $css;
	}

	add_filter( 'wp_get_custom_css', 'nishiki_pro_custom_css_minify' );
}

// ページのヘッダーの属性（ style + class ）
if ( ! function_exists( 'nishiki_pro_custom_page_header_attributes' ) ) {
	/**
	 * ページのヘッダーの属性（ style + class ）
	 *
	 * @return $attr
	 */
	function nishiki_pro_custom_page_header_attributes() {
		$attr             = '';
		$eye_catch_layout = '';
		$eye_catch_class  = '';

		// 投稿ページ
		if ( is_single() ) {
			$post_display = false;

			// カスタマイザーの設定（レイアウト）
			$eye_catch_layout = get_theme_mod( 'setting_post_eye_catch_layout', 'background' );

			// カスタマイザーの設定が非表示の場合
			if ( get_theme_mod( 'setting_post_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}

			// metaboxの設定があれば優先
			$value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_eye_catch_layout_' . get_post_type(), true );

			if ( $value ) {
				$eye_catch_layout = $value;
			}

			if ( has_post_thumbnail() ) {
				// カスタマイザーで表示する場合 or 個別にmetaboxで設定している場合は表示する
				if ( get_theme_mod( 'setting_post_eye_catch', false ) === true || 'background' === $eye_catch_layout ) {
					$post_display = true;
				}

				if ( true === $post_display ) {
					if ( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) {
						$attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) . ');"';
					}
				}
			}
		}

		// 固定ページ
		if ( is_page() ) {
			$page_display = false;

			// カスタマイザーの設定（レイアウト）
			$eye_catch_layout = get_theme_mod( 'setting_page_eye_catch_layout', 'background' );

			// カスタマイザーの設定が非表示の場合
			if ( get_theme_mod( 'setting_page_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}

			// metaboxの設定があれば優先
			$value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_eye_catch_layout_' . get_post_type(), true );

			if ( $value ) {
				$eye_catch_layout = $value;
			}

			if ( has_post_thumbnail() ) {
				if ( get_theme_mod( 'setting_page_eye_catch' ) ) {
					if ( get_the_post_thumbnail_url( get_the_ID(), 'full' ) && 'background' === $eye_catch_layout ) {
						$attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) . ');"';
					}
				}
			}
		}

		// アーカイブページ
		if ( is_archive() ) {
			if ( ! empty( get_queried_object()->term_id ) ) {
				$term_id = get_queried_object()->term_id;

				// カスタマイザーの設定（レイアウト）
				$eye_catch_layout = get_theme_mod( 'setting_archive_eye_catch_layout', 'background' );

				// カスタマイザーの設定が非表示の場合
				if ( get_theme_mod( 'setting_archive_eye_catch', false ) === false ) {
					$eye_catch_layout = 'none';
				}

				// metaboxの設定があれば優先
				$value = get_term_meta( $term_id, 'eye_catch_layout', true );

				if ( $value ) {
					$eye_catch_layout = $value;
				}

				$attachiment_id = get_term_meta( $term_id, 'eye_catch', true ) ? get_term_meta( $term_id, 'eye_catch', true ) : '';

				if ( ! empty( $attachiment_id ) && 'background' === $eye_catch_layout ) {
					$attr .= ' style="background-image:url(' . esc_url( wp_get_attachment_url( $attachiment_id ) ) . ');"';
				}
			}
		}

		// ブログページ
		if ( ! is_front_page() && is_home() ) {
			$blog_page_id = get_option( 'page_for_posts' );

			// カスタマイザーの設定（レイアウト）
			$eye_catch_layout = get_theme_mod( 'setting_page_eye_catch_layout', 'background' );

			// カスタマイザーの設定が非表示の場合
			if ( get_theme_mod( 'setting_page_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}

			// metaboxの設定があれば優先
			$value = get_post_meta( $blog_page_id, '_nishiki_pro_meta_box_eye_catch_layout_page', true );

			if ( $value ) {
				$eye_catch_layout = $value;
			}

			if ( has_post_thumbnail( $blog_page_id ) ) {
				if ( get_the_post_thumbnail_url( $blog_page_id, 'full' ) && 'background' === $eye_catch_layout ) {
					$attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( $blog_page_id, 'full' ) ) . ');"';
				}
			}
		}

		// 404 ページ
		if ( is_404() ) {
			// カスタマイザーの設定（レイアウト）
			$eye_catch_layout = get_theme_mod( 'setting_error404_title_eye_catch_layout', 'background' );

			// カスタマイザーの設定が非表示の場合
			if ( get_theme_mod( 'setting_error404_title_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}

			if ( get_theme_mod( 'setting_error404_title_eye_catch' ) && get_theme_mod( 'setting_error404_title_eye_catch_display' ) ) {
				if ( 'background' === $eye_catch_layout ) {
					$attr .= ' style="background-image:url(' . esc_url( get_theme_mod( 'setting_error404_title_eye_catch' ) ) . ');"';
				}
			}
		}

		// 検索ページ
		if ( is_search() ) {

			// カスタマイザーの設定（レイアウト）
			$eye_catch_layout = get_theme_mod( 'setting_search_title_eye_catch_layout', 'background' );

			// カスタマイザーの設定が非表示の場合
			if ( get_theme_mod( 'setting_search_title_eye_catch', false ) === false ) {
				$eye_catch_layout = 'none';
			}

			if ( get_theme_mod( 'setting_search_title_eye_catch' ) && get_theme_mod( 'setting_search_title_eye_catch_display' ) ) {
				if ( 'background' === $eye_catch_layout ) {
					$attr .= ' style="background-image:url(' . esc_url( get_theme_mod( 'setting_search_title_eye_catch' ) ) . ');"';
				}
			}
		}

		// $eye_catch_layout が指定されていれば出力する
		if ( ! empty( $eye_catch_layout ) ) {
			$eye_catch_class = ' eye-catch-' . esc_attr( $eye_catch_layout );
		}

		// ページタイプの定義
		if ( is_single() ) {
			$page_type = get_post_type();
		} else {
			$page_type = 'center';
		}

		// 属性追加
		$attr .= ' class="page-header ' . esc_attr( $page_type ) . $eye_catch_class . '"';

		return $attr;

	}

	add_filter( 'nishiki_pro_page_header_attributes', 'nishiki_pro_custom_page_header_attributes' );
}

// Single Page Author Display
if ( ! function_exists( 'nishiki_pro_singular_author' ) ) {
	/**
	 * 著者名
	 *
	 * @return void
	 */
	function nishiki_pro_singular_author() {
		if ( ! apply_filters( 'nishiki_pro_is_singular_author', true ) ) {
			return;
		}

		if ( is_single() && get_theme_mod( 'setting_post_author_display', true ) ) {
			echo '<section class="author-info">';

			if ( get_theme_mod( 'setting_post_author_text', __( 'Author', 'nishiki-pro' ) ) ) {
				echo '<span>' . esc_html( get_theme_mod( 'setting_post_author_text', __( 'Author', 'nishiki-pro' ) ) ) . '</span>';
			}

			echo '<div class="author-image">';
			echo get_avatar( get_the_author_meta( 'ID' ), 90, array( 'extra_attr' => 'data' ) );
			echo '</div>';
			echo '<p class="display-name">';

			$author_display_name = get_the_author_meta( 'display_name' );
			if ( get_theme_mod( 'setting_post_author_name_archive_link', true ) ) {
				echo '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( $author_display_name ) . '</a>';
			} else {
				echo esc_html( $author_display_name );
			}
			echo '</p>';

			do_action( 'nishiki_pro_before_single_author_description' );
			echo '<p class="description left">' . wp_kses_post( get_the_author_meta( 'description' ) ) . '</p>';
			do_action( 'nishiki_pro_after_single_author_description' );
			echo '</section>';
		}
	}
}

// Single Prev Next Link
if ( ! function_exists( 'nishiki_pro_singular_post_navigation' ) ) {
	/**
	 * 投稿ナビゲーション
	 *
	 * @return void
	 */
	function nishiki_pro_singular_post_navigation() {
		if ( ! apply_filters( 'nishiki_pro_is_singular_post_navigation', true ) ) {
			return;
		}

		if ( is_single() ) {
			if ( get_theme_mod( 'setting_post_display_prev_next_link', true ) ) {

				// 同じカテゴリーの場合とそうでない場合で条件分岐
				$is_same_term = apply_filters( 'nishiki_pro_singular_post_navigation_is_same_term', get_theme_mod( 'setting_post_display_prev_next_link_same_term', false ) );

				// アイキャッチ（サムネイル）の有無
				$is_thumbnail = apply_filters( 'nishiki_pro_singular_post_navigation_is_thumbnail', get_theme_mod( 'setting_post_display_prev_next_link_eye_catch', false ) );

				$prev_post      = get_adjacent_post( $is_same_term, '', true ); // 前のリンク
				$next_post      = get_adjacent_post( $is_same_term, '', false ); // 次のリンク
				$prev_post_html = '';
				$next_post_html = '';

				if ( true === $is_thumbnail ) {

					$image_class = array();

					// アスペクト比
					if ( get_theme_mod( 'setting_post_display_prev_next_link_eye_catch_aspect_ratio', '16-9' ) ) {
						$image_class[] = 'aspect-ratio-' . esc_attr( get_theme_mod( 'setting_post_display_prev_next_link_eye_catch_aspect_ratio', '16-9' ) );
					}

					$image_class_html = ' class="' . implode( ' ', $image_class ) . '"';

					// デフォルト画像
					if ( get_theme_mod( 'setting_archive_default_image', '' ) ) {
						$image      = get_theme_mod( 'setting_archive_default_image', '' );
						$image_id   = attachment_url_to_postid( $image );
						$image_data = wp_get_attachment_image_src( $image_id, 'thumbnail' );

						if ( ! empty( $image_data ) && true === $image_data[3] ) {
							$image_thumbnail = $image_data[0];
							$default_image   = '<figure' . $image_class_html . '><img src="' . esc_url( $image_thumbnail ) . '" alt=""></figure>';
						} else {
							$default_image = '<figure' . $image_class_html . '><img src="' . esc_url( $image ) . '" alt="WordPress テーマ Nishiki Pro"></figure>';
						}
					} else {
						$default_image = '<div data-no-image="1" ' . $image_class_html . '><i class="icomoon icon-image"></i></div>';
					}

					if ( $prev_post ) {
						if ( has_post_thumbnail( $prev_post->ID ) ) {
							$perv_post_thumbnail = '<figure' . $image_class_html . '>' . get_the_post_thumbnail( $prev_post->ID ) . '</figure>';
						} else {
							$perv_post_thumbnail = $default_image;
						}

						$prev_post_html = '<div class="post-image">' . $perv_post_thumbnail . '</div>';
					}

					if ( $next_post ) {
						if ( has_post_thumbnail( $next_post->ID ) ) {
							$next_post_thumbnail = '<figure' . $image_class_html . '>' . get_the_post_thumbnail( $next_post->ID ) . '</figure>';
						} else {
							$next_post_thumbnail = $default_image;
						}

						$next_post_html = '<div class="post-image">' . $next_post_thumbnail . '</div>';
					}
				}

				?>
				<nav class="navigation post-navigation" role="navigation" aria-label="投稿">
					<h2 class="screen-reader-text">投稿ナビゲーション</h2>
					<div class="nav-links">
					<?php
					if ( $prev_post ) {
						echo '<div class="nav nav-previous"><a href="' . esc_url( get_permalink( $prev_post->ID ) ) . '" rel="prev"><i class="icomoon icon-arrow-left"></i>' . $prev_post_html . '<span class="title">' . wp_kses_post( get_the_title( $prev_post->ID ) ) . '</span></a></div>'; // phpcs:ignore
					}
					if ( $next_post ) {
						echo '<div class="nav nav-next"><a href="' . esc_url( get_permalink( $next_post->ID ) ) . '" rel="next">' . $next_post_html . '<span class="title">' . wp_kses_post( get_the_title( $next_post->ID ) ) . '</span><i class="icomoon icon-arrow-right"></i></a></div>'; // phpcs:ignore
					}
					?>
					</div>
				</nav>
				<?php

				// the_post_navigation( array(
				// 'prev_text' => '<i class="icomoon icon-arrow-left"></i><span>' . "%title" . '</span>',
				// 'next_text' => '<span>' . "%title" . '</span>' . '<i class="icomoon icon-arrow-right"></i>'
				// ) );

			}
		}

	}
}

// Single Comment Template
if ( ! function_exists( 'nishiki_pro_singular_comment_template' ) ) {
	/**
	 * コメントテンプレート
	 *
	 * @return void
	 */
	function nishiki_pro_singular_comment_template() {
		if ( ! apply_filters( 'nishiki_pro_is_singular_comment_template', true ) ) {
			return;
		}

		// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || get_comments_number() ) {
			comments_template();
		}
	}
}

// XML Sitemap
if ( ! function_exists( 'nishiki_pro_sitemaps_provider' ) ) {
	/**
	 * サイトマップのプロバイダー
	 *
	 * @param WP_Sitemaps_Provider $provider プロバイダー
	 * @param string               $name 文字列
	 * @return $provider
	 */
	function nishiki_pro_sitemaps_provider( $provider, $name ) {
		if ( 'users' === $name ) {
			return false;
		}

		return $provider;
	}

	add_filter( 'wp_sitemaps_add_provider', 'nishiki_pro_sitemaps_provider', 10, 2 );
}

// Login Page
if ( ! function_exists( 'nishiki_pro_login_page' ) ) {
	/**
	 * ログインページ
	 *
	 * @return void
	 */
	function nishiki_pro_login_page() {
		$logo_style             = '';
		$text_color_style       = '';
		$background_color_style = '';

		$logo_css             = '';
		$text_color_css       = '';
		$background_color_css = '';

		// Logo
		$image_attachment_id = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_image' );
		if ( $image_attachment_id ) {
			$image_data = wp_get_attachment_image_src( $image_attachment_id, 'thumbnail' );
			if ( $image_data[0] ) {
				$image_url    = $image_data[0];
				$image_width  = $image_data[1];
				$image_height = $image_data[2];
			}

			$image_max_width  = '100%';
			$image_max_height = '100%';

			if ( $image_width > 320 ) {
				$image_max_width  = '320px';
				$image_max_height = floor( 320 * $image_height / $image_width ) . 'px;';
			}

			$logo_style .= 'background-image: url(' . esc_url( $image_url ) . ');';
			$logo_style .= 'width:' . absint( $image_width ) . 'px;';
			$logo_style .= 'height:' . absint( $image_height ) . 'px;';
			$logo_style .= 'max-width:' . $image_max_width . ';';
			$logo_style .= 'max-height:' . $image_max_height . ';';
			$logo_style .= 'background-size: 100%;';
			$logo_style .= 'background-repeat: no-repeat;';
		}

		if ( $logo_style ) {
			$logo_css = '#login h1 a, .login h1 a {' . $logo_style . '}';
		}

		// Background Color
		$background_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_background_color' );
		if ( $background_color ) {
			$background_color_style .= 'background-color:' . esc_html( $background_color ) . ';';
		}

		if ( $background_color_style ) {
			$background_color_css = 'body.login {' . $background_color_style . '}';
		}

		// Text Color
		$text_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_text_color' );
		if ( $text_color ) {
			$text_color_style .= 'color:' . esc_html( $text_color ) . ';';
		}

		if ( $text_color_style ) {
			$text_color_css = 'body.login #backtoblog a, body.login #backtoblog a:hover, body.login #nav, body.login #nav a, body.login #nav a:hover, .privacy-policy-link, .privacy-policy-link:hover {' . $text_color_style . '}';
		}

		if ( $logo_css || $background_color_css || $text_color_css ) {
			echo '<style type="text/css">';
			echo wp_kses_post( $logo_css . $text_color_css . $background_color_css );
			echo '</style>';
		}

	}

	add_action( 'login_enqueue_scripts', 'nishiki_pro_login_page' );
}

// Login Page Logo Url
if ( ! function_exists( 'nishiki_pro_login_page_logo_url' ) ) {
	/**
	 * ログインページのロゴ画像のリンク URL
	 *
	 * @return string
	 */
	function nishiki_pro_login_page_logo_url() {
		return home_url();
	}

	add_filter( 'login_headerurl', 'nishiki_pro_login_page_logo_url' );
}

// Login Page Logo Url Title
if ( ! function_exists( 'nishiki_pro_login_page_logo_url_title' ) ) {
	/**
	 * ログインページのタイトルのリンク URL
	 *
	 * @return $title
	 */
	function nishiki_pro_login_page_logo_url_title() {
		$title = esc_html( get_bloginfo( 'name' ) );

		return $title;
	}

	add_filter( 'login_headertext', 'nishiki_pro_login_page_logo_url_title' );
}

// Archive Infeed Ads.
if ( ! function_exists( 'nishiki_pro_infeed_ads' ) ) {
	/**
	 * Undocumented function
	 *
	 * @param int   $count 表示数
	 * @param array $infeed_ads_options オプション
	 * @return boolean
	 */
	function nishiki_pro_infeed_ads( $count, $infeed_ads_options ) {
		$queried_object = get_queried_object();
		$flag           = false;

		if ( is_home() ) {
			if ( isset( $infeed_ads_options['display']['top'] ) ) {
				$flag = true;
			}
		}

		if ( is_paged() ) {
			if ( isset( $infeed_ads_options['display']['paged'] ) ) {
				$flag = true;
			}
		}

		if ( is_search() ) {
			if ( isset( $infeed_ads_options['display']['search'] ) ) {
				$flag = true;
			}
		}

		if ( is_archive() ) {

			if ( is_post_type_archive() ) {
				$post_archive_name = $queried_object->name;
				if ( isset( $infeed_ads_options['display'][ $post_archive_name ] ) ) {
					$flag = true;
				}
			}

			if ( is_category() || is_tag() || is_tax() ) {
				$term_object = get_term( $queried_object );
				$taxonomy    = $term_object->taxonomy;

				if ( isset( $infeed_ads_options['display'][ $taxonomy ] ) ) {
					$flag = true;
				}
			}

			if ( is_year() ) {
				if ( isset( $infeed_ads_options['display']['year'] ) ) {
					$flag = true;
				}
			}

			if ( is_month() ) {
				if ( isset( $infeed_ads_options['display']['month'] ) ) {
					$flag = true;
				}
			}

			if ( is_day() ) {
				if ( isset( $infeed_ads_options['display']['day'] ) ) {
					$flag = true;
				}
			}

			if ( is_author() ) {
				if ( isset( $infeed_ads_options['display']['author'] ) ) {
					$flag = true;
				}
			}
		}

		if ( apply_filters( 'nishiki_pro_infeed_ads_display', $flag ) === false ) {
			return false;
		}

		$infeed_ads_numbers = apply_filters( 'nishiki_pro_infeed_ads_numbers', $infeed_ads_options['number'] );

		if ( ! empty( $infeed_ads_numbers ) ) {
			$numbers = explode( ',', $infeed_ads_numbers );
		}

		$infeed_ads_code = apply_filters( 'nishiki_pro_infeed_ads_code', $infeed_ads_options['code'], $count );

		if ( ! empty( $numbers ) && is_array( $numbers ) && ! empty( $infeed_ads_code ) ) {
			$infeed_code = apply_filters( 'the_content', $infeed_ads_code );

			if ( in_array( strval( $count ), $numbers, true ) ) {	
				echo '<article class="infeed infeed-' . absint( $count ) . '">' . nishiki_pro_sanitize_textarea_script( $infeed_code ) . '</article>'; // phpcs:ignore
			}
		}
	}

	add_action( 'nishiki_pro_before_archive_posts', 'nishiki_pro_infeed_ads', 10, 2 );
}

if ( ! function_exists( 'nishiki_pro_hex_to_rgb' ) ) {
	/**
	 * カラーコードを HEX から RGB へ変換
	 *
	 * @param string  $hex カラーコード
	 * @param integer $alpha 透明度
	 * @return $rgb
	 */
	function nishiki_pro_hex_to_rgb( $hex, $alpha = 0 ) {

		if ( ! $hex ) {
			return false;
		}

		$hex      = str_replace( '#', '', $hex );
		$length   = strlen( $hex );
		$rgb['r'] = hexdec( 6 === $length ? substr( $hex, 0, 2 ) : ( 3 === $length ? str_repeat( substr( $hex, 0, 1 ), 2 ) : 0 ) );
		$rgb['g'] = hexdec( 6 === $length ? substr( $hex, 2, 2 ) : ( 3 === $length ? str_repeat( substr( $hex, 1, 1 ), 2 ) : 0 ) );
		$rgb['b'] = hexdec( 6 === $length ? substr( $hex, 4, 2 ) : ( 3 === $length ? str_repeat( substr( $hex, 2, 1 ), 2 ) : 0 ) );
		$rgb['a'] = $alpha / 100;

		return $rgb;
	}
}

/**
 *
 * Add Editor Style(Inline)
 */

if ( ! function_exists( 'nishiki_pro_editor_styles_inlines' ) ) {
	/**
	 * エディタースタイル（インライン）
	 *
	 * @return void
	 */
	function nishiki_pro_editor_styles_inlines() {
		add_theme_support( 'editor-styles' );
		$editor_stylesheet_path = './assets/css/editor-style.css';

		// Enqueue editor styles.
		add_editor_style( $editor_stylesheet_path );
	}

	add_action( 'after_setup_theme', 'nishiki_pro_editor_styles_inlines' );
}


/**
 *
 * Scroll Page Top Button
 */

if ( ! function_exists( 'nishiki_pro_footer_scroll_page_top_button' ) ) {
	/**
	 * ページトップボタン
	 *
	 * @return void
	 */
	function nishiki_pro_footer_scroll_page_top_button() {

		if ( ! apply_filters( 'nishiki_pro_scroll_page_top_button', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_enable', true ) ) ) {
			return;
		}

		$output = '';
		$url    = apply_filters( 'nishiki_pro_scroll_page_top_url', '#page' );
		$class  = array();

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_desktop', true ) ) {
			$class[] = 'is-desktop';
		}

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_tablet', true ) ) {
			$class[] = 'is-tablet';
		}

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_smartphone', true ) ) {
			$class[] = 'is-smartphone';
		}

		$kses_defaults = wp_kses_allowed_html( 'post' );

		$svg_args = array(
			'svg'   => array(
				'class'           => true,
				'aria-hidden'     => true,
				'aria-labelledby' => true,
				'role'            => true,
				'xmlns'           => true,
				'width'           => true,
				'height'          => true,
				'viewbox'         => true,
			),
			'g'     => array(
				'fill'      => true,
				'transform' => true,
			),
			'title' => array( 'title' => true ),
			'path'  => array(
				'd'    => true,
				'fill' => true,
			),
		);

		$allowed_tags = array_merge( $kses_defaults, $svg_args );

		$bottom_right_content = '<div id="scroll-page-top" class="' . implode( ' ', $class ) . '"><a href="' . $url . '"><svg width="100%" height="100%" viewBox="0 0 48 48" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
			<g transform="matrix(-1,1.22465e-16,-1.22465e-16,-1,48,48)">
				<path d="M44,18.182L24,34.182L4,18.182L7.273,13.818L24,26.909L40.364,13.818L44,18.182Z"/>
			</g></svg>
		</a></div>';

		$bottom_right_content = apply_filters( 'nishiki_pro_bottom_right_content', $bottom_right_content, $url );

		$output .= '<div class="footer-bottom-right-content fixed right-6 bottom-6">';
		$output .= apply_filters( 'nishiki_pro_before_bottom_right_content', $before_bottom_right_content = '' );
		$output .= $bottom_right_content;
		$output .= apply_filters( 'nishiki_pro_after_bottom_right_content', $after_bottom_right_content = '' );
		$output .= '</div>';

		echo wp_kses( $output, $allowed_tags );
	}

	add_action( 'nishiki_pro_after_site_footer_content_inner', 'nishiki_pro_footer_scroll_page_top_button', 10 );
}

/**
 *
 * Redirect
 */

if ( ! function_exists( 'nishiki_pro_redirect' ) ) {
	/**
	 * リダイレクト設定
	 *
	 * @return boolean
	 */
	function nishiki_pro_redirect() {
		$option = get_option( 'nishiki_pro_general_redirect' );

		if ( empty( $option ) ) {
			return false;
		}

		// Redirect URL
		if ( ! empty( $option['url'] ) ) {
			$redirect_url = $option['url'];
		} else {
			$redirect_url = home_url();
		}

		if ( ! empty( $option['page'][404] ) ) {
			if ( is_404() ) {
				wp_safe_redirect( apply_filters( 'nishiki_pro_redirect_404', $redirect_url ) );
				exit();
			}
		}

		if ( ! empty( $option['page']['author'] ) ) {
			if ( is_author() ) {
				wp_safe_redirect( apply_filters( 'nishiki_pro_redirect_author', $redirect_url ) );
				exit();
			}
		}

		if ( ! empty( $option['page']['search'] ) ) {
			if ( is_search() ) {
				wp_safe_redirect( apply_filters( 'nishiki_pro_redirect_search', $redirect_url ) );
				exit();
			}
		}

		if ( ! empty( $option['page']['attachment'] ) ) {
			if ( is_attachment() ) {
				wp_safe_redirect( apply_filters( 'nishiki_pro_redirect_attachment', $redirect_url ) );
				exit();
			}
		}
	}

	add_action( 'template_redirect', 'nishiki_pro_redirect' );
}

/**
 *
 * Allow wp_kses_post Html
 */

if ( ! function_exists( 'nishiki_pro_wp_kses_allowed_html' ) ) {
	/**
	 * HTML の許可設定
	 *
	 * @return array
	 */
	function nishiki_pro_wp_kses_allowed_html() {
		$kses_post = wp_kses_allowed_html( 'post' );

		$allowed_args = array(
			'img'     => array(
				'sizes'  => true,
				'src'    => true,
				'srcset' => true,
				'width'  => true,
				'height' => true,
				'class'  => true,
				'alt'    => true
			),
			'svg'     => array(
				'style'           => array( 'fill' => true ),
				'class'           => true,
				'aria-hidden'     => true,
				'aria-labelledby' => true,
				'role'            => true,
				'xmlns'           => true,
				'width'           => true,
				'height'          => true,
				'viewbox'         => true,
			),
			'defs'    => true,
			'style'   => true,
			'g'       => array(
				'style'     => array( 'fill' => true ),
				'fill'      => true,
				'transform' => true,
			),
			'title'   => array( 'title' => true ),
			'path'    => array(
				'class' => true,
				'style' => array( 'fill' => true ),
				'd'     => true,
			),
			'circle'  => array(
				'class'     => true,
				'cx'        => true,
				'cy'        => true,
				'r'         => true,
				'style'     => array( 'fill' => true ),
				'transform' => true,
			),
			'polygon' => array(
				'class'     => true,
				'points'    => true,
				'style'     => array( 'fill' => true ),
				'transform' => true,
			),
			'rect'    => array(
				'class'     => true,
				'points'    => true,
				'style'     => array( 'fill' => true ),
				'transform' => true,
			),
			'line'    => array(
				'class'  => true,
				'x1'     => true,
				'x2'     => true,
				'y1'     => true,
				'y2'     => true,
				'stroke' => true,
			),
		);

		$args = apply_filters( 'nishiki_pro_wp_kses_allow_args', $allowed_args );

		return array_merge( $kses_post, $args );
	}
}

/**
 *
 * Allow Style CSS
 */

if ( ! function_exists( 'nishiki_pro_safe_style_css' ) ) {
	/**
	 * CSS スタイルの許可設定
	 *
	 * @param array $styles CSS スタイル
	 * @return array
	 */
	function nishiki_pro_safe_style_css( $styles ) {
		$styles[] = 'fill';
		$styles[] = 'display';
		$styles[] = 'visibility';

		return $styles;
	}

	add_filter( 'safe_style_css', 'nishiki_pro_safe_style_css', 10, 1 );
}

/**
 * Replace Filter Search Block Form
 */

if ( ! function_exists( 'nishiki_pro_replace_filter_search_block_form' ) ) {
	/**
	 * 絞り込み検索のフォームを作成したブロックに差し替える
	 *
	 * @param string $replace_id 差し替え用 ID
	 * @return array
	 */
	function nishiki_pro_replace_filter_search_block_form( $replace_id ) {

		if ( empty( $replace_id ) ) {
			return false;
		}

		//$block_replace_id = '2471::88e63b4b-5aef-4571-8035-a7934d0c355b';

		$block_replace_data = explode( '::', $replace_id );
		$post_content = get_post_field( 'post_content', $block_replace_data[0] );

		if( empty( $post_content ) ){
			echo '絞り込み検索のフォームが表示できませんでした。正しい「差し替え用 ID」を入れてください。';
			return false;
		}

		$blocks = parse_blocks( $post_content );

		foreach( $blocks as $block ) {
			if( 'nishiki-blocks-pro/filter-search' === $block['blockName'] ) {
				if( $block_replace_data[1] === $block['attrs']['blockId'] ){
					echo '<section class="nishiki-pro-filter-search">';
					echo render_block( $block );
					echo '</section>';
					break;
				}
			}
		}
	}
}

/**
 * アーカイブページの検索フォーム
 */
if ( ! function_exists( 'nishiki_pro_archive_search_form' ) ) {
	function nishiki_pro_archive_search_form(){
		get_search_form();
	}

	add_action( 'nishiki_pro_archive_search_form', 'nishiki_pro_archive_search_form', 10 );
}

/**
 * theme.json の設定上書き
 */

if ( ! function_exists( 'nishiki_pro_theme_json_settings' ) ) {
	function nishiki_pro_theme_json_settings( $editor_settings, $editor_context ) {
//		var_dump($editor_settings);
//		$editor_settings['supportsLayout'] = false;

		$site_content_width = absint( get_theme_mod( 'setting_site_contents_width', '1000' ) );
		$site_wide_width    = absint( get_theme_mod( 'setting_site_wide_width', '1200' ) );

		$editor_settings['__experimentalFeatures']['layout']['contentSize'] = $site_content_width . 'px';
		$editor_settings['__experimentalFeatures']['layout']['wideSize']    = $site_wide_width . 'px';

		if( $editor_context->post ){
			$site_custom_content_width = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_content_width_' . get_post_type(), true );
	
			if ( '0' !== $site_custom_content_width && ! empty( $site_custom_content_width ) ) {
				$editor_settings['__experimentalFeatures']['layout']['contentSize'] = $site_custom_content_width . 'px';
			}
		}

		return $editor_settings;
	}

	add_filter( 'block_editor_settings_all', 'nishiki_pro_theme_json_settings', 10, 2 );
}

// PR ラベル設定
if ( ! function_exists( 'nishiki_pro_pr_label_html' ) ) {
	function nishiki_pro_pr_label_html(){
		if( ! is_singular() ){
			return false;
		}

		$value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_pr_label_' . get_post_type(), true );
		$custom_label_text = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_pr_custom_label_text_' . get_post_type(), true );

		if( ! $value ){
			return false;
		}

		if( $custom_label_text ){
			$pr_label_text = $custom_label_text;
		} else {
			$pr_label_text = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_text', 'PR' );
		}
		
		$pr_label_type = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_type', 'fill' );
		$pr_label_type_css = ' pr-label-type-' . $pr_label_type;

		echo wp_kses_post( '<span class="pr-label' . $pr_label_type_css . '">' . $pr_label_text . '</span>' );
	}

	add_action( 'nishiki_pro_before_singular_terms', 'nishiki_pro_pr_label_html', 999 );
}

// PR コンテンツ前テキスト設定
if ( ! function_exists( 'nishiki_pro_pr_before_content_html' ) ) {
	function nishiki_pro_pr_before_content_html(){
		if( ! is_singular() ){
			return false;
		}

		$value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_pr_before_content_' . get_post_type(), true );
		$custom_before_content_text = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_pr_custom_before_content_text_' . get_post_type(), true );

		if( ! $value ){
			return false;
		}

		if( $custom_before_content_text ){
			$pr_before_content_text = $custom_before_content_text;
		} else {
			$pr_before_content_text = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_text', '本ページはプロモーションが含まれています。' );
		}

		$pr_before_content_type = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_type', 'outline' );
		$pr_before_content_type_css = ' pr-before-content-type-' . $pr_before_content_type;

		echo wp_kses_post( '<p class="pr-before-content-text' . $pr_before_content_type_css . '">' . $pr_before_content_text . '</p>' );
	}

	add_action( 'nishiki_pro_before_singular_inner_content', 'nishiki_pro_pr_before_content_html', 999 );
}

// Add mime types
if ( ! function_exists( 'nishiki_pro_add_mime_types' ) ) {
	function nishiki_pro_add_mime_types( $mimes ) {
		$mimes['avif'] = 'image/avif';
		$mimes['webp'] = 'image/webp';
		return $mimes;
	}

	add_filter( 'upload_mimes', 'nishiki_pro_add_mime_types' );
}

// Check filetype
if ( ! function_exists( 'nishiki_pro_check_filetype_and_ext' ) ) {
	function nishiki_pro_check_filetype_and_ext( $types, $file, $filename, $mimes ) {
		if ( false !== strpos( $filename, '.avif' ) ) {
			$types['ext'] = 'avif';
			$types['type'] = 'image/avif';
		}
		
		if ( false !== strpos( $filename, '.webp' ) ) {
			$types['ext'] = 'webp';
			$types['type'] = 'image/webp';
		}
	
		return $types;
	}

	add_filter( 'wp_check_filetype_and_ext', 'nishiki_pro_check_filetype_and_ext', 10, 4 );
}

if ( ! function_exists( 'nishiki_pro_register_starter_content' ) ) {
	function nishiki_pro_register_starter_content() {
		$starter_content = [
			'widgets' => array(
            'sidebar-1' => array( 'search' ),
			),
			'posts' => array( 'home', 'about' ),
			/*
			'options' => array(
				'show_on_front' => 'page',
				'page_on_front' => '{{home}}',
			),
			*/
		];

		return apply_filters( 'nishiki_pro_starter_content', $starter_content );
	}
}