<?php
/**
 * アーカイブ個別 パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

?>
<article <?php post_class(); ?>>
<?php
if ( has_post_thumbnail( get_the_ID() ) || get_theme_mod( 'setting_archive_default_image', '' ) ) {
	$noimage = '';
} else {
	$noimage = ' noimage';
}

if ( get_theme_mod( 'setting_archive_post_eye_catch_aspect_ratio', '16-9' ) ) {
	$image_aspect_ratio = ' aspect-ratio-' . get_theme_mod( 'setting_archive_post_eye_catch_aspect_ratio', '16-9' );
} else {
	$image_aspect_ratio = '';
}

if ( apply_filters( 'nishiki_pro_archive_display_eye_catch', get_theme_mod( 'setting_archive_display_eye_catch', true ) ) ) {
	?>
	<div class="post-image<?php echo esc_attr( $noimage ) . esc_attr( $image_aspect_ratio ); ?>">
		<a class="post-link" href="<?php the_permalink(); ?>">
			<?php do_action( 'nishiki_pro_before_article_image' ); ?>
			<?php if ( '' === $noimage ) { ?>
			<figure>
				<?php
				if ( has_post_thumbnail( get_the_ID() ) ) {
					the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) );
				} else {
					if ( get_theme_mod( 'setting_archive_default_image', '' ) ) {
						$image      = get_theme_mod( 'setting_archive_default_image', '' );
						$image_id   = attachment_url_to_postid( $image );
						$image_data = wp_get_attachment_image_src( $image_id, 'thumbnail' );
						if ( ! empty( $image_data ) && true === $image_data[3] ) {
							$image_thumbnail = $image_data[0];
							echo '<img src="' . esc_url( $image_thumbnail ) . '" alt="">';
						} else {
							echo '<img src="' . esc_url( $image ) . '" alt="WordPress テーマ Nishiki Pro">';
						}
					}
				}
				?>
			</figure>
			<?php } else { ?>
				<i class="icomoon icon-image"></i>
			<?php } ?>
			<?php do_action( 'nishiki_pro_after_article_image' ); ?>
		</a>
	</div>
	<?php } ?>
	<div class="post-detail">
		<a class="post-link" href="<?php the_permalink(); ?>">
		<?php do_action( 'nishiki_pro_before_article_header' ); ?>
		<header><?php the_title( '<h2 class="post-title">', '</h2>' ); ?></header>
		<?php do_action( 'nishiki_pro_after_article_header' ); ?>
		<?php
			$display_excerpt               = false;
			$related_posts_display_excerpt = apply_filters(
				'nishiki_pro_related_posts_display_excerpt',
				get_theme_mod( 'setting_post_related_posts_display_excerpt', true )
			);

			$archive_display_excerpt = apply_filters(
				'nishiki_pro_archive_display_excerpt',
				get_theme_mod( 'setting_archive_display_excerpt', true )
			);

			if ( is_singular() ) {
				if ( $related_posts_display_excerpt ) {
					$display_excerpt = true;
				}
			}

			if ( is_home() || is_archive() || is_search() ) {
				if ( $archive_display_excerpt ) {
					$display_excerpt = true;
				}
			}

			if ( true === $display_excerpt ) {
				if ( get_the_excerpt() ) {
					// $excerpt = '<div class="excerpt">' . apply_filters( 'the_content', get_the_excerpt() ) . '</div>';
					$excerpt = '<div class="excerpt">' . get_the_excerpt() . '</div>';
					echo wp_kses_post( apply_filters( 'nishiki_pro_excerpt_html', $excerpt, get_the_ID() ) );
				}
			}
			?>
		</a>
		<?php
		$related_posts_display_date = apply_filters(
			'nishiki_pro_related_posts_display_date',
			get_theme_mod( 'setting_post_related_posts_display_date', true )
		);

		$related_posts_display_archive = apply_filters(
			'nishiki_pro_related_posts_display_archive',
			get_theme_mod( 'setting_post_related_posts_display_archive', true )
		);

		$related_posts_display_comment = apply_filters(
			'nishiki_pro_related_posts_display_comment',
			get_theme_mod( 'setting_post_related_posts_display_comment', true )
		);

		$related_posts_display_author = apply_filters(
			'nishiki_pro_related_posts_display_author',
			get_theme_mod( 'setting_post_related_posts_display_author', true )
		);

		$archive_display_date = apply_filters(
			'nishiki_pro_archive_display_date',
			get_theme_mod( 'setting_archive_display_date', true )
		);

		$archive_display_archive = apply_filters(
			'nishiki_pro_archive_display_archive',
			get_theme_mod( 'setting_archive_display_archive', true )
		);

		$archive_display_comment = apply_filters(
			'nishiki_pro_archive_display_comment',
			get_theme_mod( 'setting_archive_display_comment', true )
		);

		$archive_display_author = apply_filters(
			'nishiki_pro_archive_display_author',
			get_theme_mod( 'setting_archive_display_author', true )
		);

		$display_footer = false;

		if ( is_home() ) {
			if ( $archive_display_date || $archive_display_comment || $archive_display_author ) {
				$display_footer = true;
			}
		}

		if ( is_archive() ) {
			if ( $archive_display_date || $archive_display_comment || $archive_display_author ) {
				$display_footer = true;
			}
		}

		if ( is_single() ) {
			if ( $related_posts_display_date || $related_posts_display_archive || $related_posts_display_comment || $related_posts_display_author ) {
				$display_footer = true;
			}
		}

		if ( true === $display_footer ) {
			?>
			<footer>
			<?php
			if (
				( is_home() && $archive_display_date ) ||
				( is_archive() && $archive_display_date ) ||
				( is_single() && $related_posts_display_date )
			) {
				echo '<span class="date">' . esc_html( get_the_time( get_option( 'date_format' ) ) ) . '</span>';
			}
			if (
				( ( is_home() && $archive_display_archive ) || is_archive() && $archive_display_archive && ! is_category() ) ||
				( is_single() && $related_posts_display_archive )
			) {
				$archive_terms = apply_filters( 'nishiki_pro_archive_terms', get_the_terms( get_the_ID(), 'category' ), get_the_ID() );
				$separator     = '/';
				$output        = '';
				if ( $archive_terms ) {
					foreach ( $archive_terms as $archive_term ) {
						$output .= '<a href="' . esc_url( get_term_link( $archive_term->term_id ) ) . '">' . esc_html( $archive_term->name ) . '</a>' . $separator;
					}
					$output = trim( $output, $separator );
					echo '<span class="cat"><i class="icomoon icon-folder-open"></i>' . wp_kses_post( $output ) . '</span>';
				}
			}
			if (
				( is_home() && $archive_display_comment ) ||
				( is_archive() && $archive_display_comment ) ||
				( is_single() && $related_posts_display_comment )
			) {
				$comment_count = wp_count_comments( get_the_ID() );
				$comment_num   = $comment_count->approved;

				if ( 0 !== $comment_num ) {
					echo '<span class="comment"><i class="icomoon icon-bubble"></i>' . absint( $comment_num ) . '</span>';
				}
			}
			if (
				( is_home() && $archive_display_author ) ||
				( is_archive() && $archive_display_author ) ||
				( is_single() && $related_posts_display_author )
			) {
				echo '<span class="author">' . esc_html( get_the_author() ) . '</span>';
			}
			?>
		</footer>
	</div>
<?php } ?>
</article>
