<?php
/**
 * ヘッダーグローバルナビ パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

$icon_search = apply_filters( 'nishiki_pro_header_icon_search', '<i class="icomoon icon-search"></i>' );
$icon_menu   = apply_filters( 'nishiki_pro_header_icon_menu', '<i class="icomoon icon-menu"></i>' );
?>
<?php do_action( 'nishiki_pro_before_site_nav' ); ?>

<?php if ( has_nav_menu( 'global' ) && get_theme_mod( 'setting_header_menu_collapse', true ) ) { ?>
<nav class="global-nav" role="navigation">
	<?php do_action( 'nishiki_pro_before_site_nav_inner' ); ?>
		<?php
		$global_nav_open_type = apply_filters( 'nishiki_pro_header_global_nav_open_type', get_theme_mod( 'setting_header_global_nav_open_type', 'hover' ) );
		$drawer_menu_width    = apply_filters( 'nishiki_pro_header_drawer_menu_width', get_theme_mod( 'setting_header_drawer_menu_width', 781 ) );
		$menu_collapse_class  = 'menu-collapse overlay panel';
		if ( get_theme_mod( 'setting_header_menu_overlay_open_type', 'panel-slide' ) ) {
			$menu_collapse_class .= ' ' . get_theme_mod( 'setting_header_menu_overlay_open_type', 'panel-slide' );
		}
		if ( get_theme_mod( 'setting_header_menu_overlay_backdrop_blur' ) ) {
			$menu_collapse_class .= ' ' . get_theme_mod( 'setting_header_menu_overlay_backdrop_blur' );
		}
		?>
		<div class="<?php echo esc_html( $menu_collapse_class ); ?>" id="menu-collapse" data-drawer-width="<?php echo absint( $drawer_menu_width ); ?>" data-nav-open-type="<?php echo esc_attr( $global_nav_open_type ); ?>">
			<div class="overlay-inner relative w-full">
				<?php
				$nav_args = array(
					'theme_location'  => 'global',
					'container_class' => '',
					'container'       => '',
					'menu_id'         => '',
					'items_wrap'      => '<ul class="menu-items">%3$s</ul>',
					'walker'          => new NISHIKI_PRO_WALKER_GLOBAL_NAV(),
				);
				do_action( 'nishiki_pro_before_global_nav_menu' );
				wp_nav_menu( $nav_args );
				do_action( 'nishiki_pro_after_global_nav_menu' );
				?>
				<button id="close-panel-button-menu" class="close" aria-label="<?php esc_html_e( 'close', 'nishiki-pro' ); ?>"><i class="icomoon icon-close"></i></button>
			</div>
		</div>
	<?php do_action( 'nishiki_pro_after_site_nav_inner' ); ?>
</nav>
<?php } ?>

<?php do_action( 'nishiki_pro_before_site_search_button' ); ?>
<?php if ( get_theme_mod( 'setting_header_search_button', true ) ) { ?>
	<?php do_action( 'nishiki_pro_before_site_nav_inner_search_button' ); ?>
	<button id="search-button" class="icon" aria-controls="search-overlay" aria-label="search">
		<?php echo wp_kses( $icon_search, nishiki_pro_wp_kses_allowed_html() ); ?>
	</button>
	<?php do_action( 'nishiki_pro_after_site_nav_inner_search_button' ); ?>
<?php } ?>
<?php do_action( 'nishiki_pro_after_site_search_button' ); ?>

<?php do_action( 'nishiki_pro_before_site_menu_button' ); ?>
<?php if ( has_nav_menu( 'global' ) ) { ?>
	<?php if ( get_theme_mod( 'setting_header_menu_collapse', true ) ) { ?>
		<?php do_action( 'nishiki_pro_before_site_nav_inner_menu_collapse_button' ); ?>
		<button id="menu-collapse-button" class="icon" aria-controls="menu-collapse" aria-label="menu">
			<?php echo wp_kses( $icon_menu, nishiki_pro_wp_kses_allowed_html() ); ?>
		</button>
		<?php do_action( 'nishiki_pro_after_site_nav_inner_menu_collapse_button' ); ?>
	<?php } else { ?>
		<?php do_action( 'nishiki_pro_before_site_nav_inner_menu_button' ); ?>
		<button id="menu-button" class="icon" aria-controls="menu-overlay" aria-label="menu">
			<?php echo wp_kses( $icon_menu, nishiki_pro_wp_kses_allowed_html() ); ?>
		</button>
		<?php do_action( 'nishiki_pro_after_site_nav_inner_menu_button' ); ?>
	<?php } ?>
<?php } ?>
<?php do_action( 'nishiki_pro_after_site_menu_button' ); ?>

<?php do_action( 'nishiki_pro_after_site_nav' ); ?>
