<?php
/**
 * 投稿/固定ページ パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

do_action( 'nishiki_pro_before_singular_header', $post );

// Meta チェック
$disable_title = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_title_disable_' . get_post_type(), true );

// テンプレートチェック
if ( ! empty( $args['template'] ) ) {
	$template = $args['template'];
} else {
	$template = '';
}

if ( 'full-width' === $template ) {
	$container_class = '';
} else {
	$container_class = ' column';
}

if( $disable_title ){
	$container_class .= ' disabled-page-title';
}

// タイトルを非表示にしてるかどうかチェック
if ( empty( $disable_title ) ) { ?>
<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
	<div class="page-header-inner container">
		<?php do_action( 'nishiki_pro_before_singular_title' ); ?>
		<?php the_title( '<h1>', '</h1>' ); ?>
		<?php do_action( 'nishiki_pro_after_singular_title' ); ?>
		<?php 
		if ( is_single() && ! is_attachment() ) {

			$published_date = false;
			$modified_date  = false;
			if ( get_theme_mod( 'setting_post_display_published_date', true ) ) {
				$published_date = true;
			}

			if ( get_theme_mod( 'setting_post_display_modified_date', true ) && ( get_the_time( 'Y-m-d' ) < get_the_modified_time( 'Y-m-d' ) ) ) {
				$modified_date = true;
			}

			if ( true === $published_date || true === $modified_date ) {
				echo '<div class="date">';
				if ( true === $published_date ) {
					echo '<time datetime="' . esc_attr( get_the_time( 'Y-m-d' ) ) . '">' . esc_html( __( 'published', 'nishiki-pro' ) ) . ':' . esc_html( get_the_time( get_option( 'date_format' ) ) ) . '</time>';
				}
				if ( true === $modified_date ) {
					echo '<time datetime="' . esc_attr( get_the_modified_time( 'c' ) ) . '">' . esc_html( __( 'updated', 'nishiki-pro' ) ) . ':' . esc_html( get_the_modified_date( get_option( 'date_format' ) ) ) . '</time>';
				}
				echo '</div>';
			}

			do_action( 'nishiki_pro_before_singular_terms' );

			if ( get_theme_mod( 'setting_post_display_category', true ) ) {
				$singular_terms = apply_filters( 'nishiki_pro_singular_terms', get_the_terms( get_the_ID(), 'category' ), get_the_ID() );
				$separator      = '/';
				$output         = '';
				if ( $singular_terms ) {
					foreach ( $singular_terms as $singular_term ) {
						$output .= '<a href="' . esc_url( get_term_link( $singular_term->term_id ) ) . '">' . $singular_term->name . '</a>' . $separator;
					}
					$output = trim( $output, $separator );
					echo '<span class="cat"><i class="icomoon icon-folder-open"></i>' . wp_kses_post( $output ) . '</span>';
				}
			}

			if ( get_theme_mod( 'setting_post_display_tag', true ) && get_the_tags() ) {
				echo '<span class="tag">';
				the_tags( '<i class="icomoon icon-price-tag"></i>', '/' );
				echo '</span>';
			}

			if ( get_theme_mod( 'setting_post_display_comment', true ) ) {
				$comment_count = wp_count_comments( get_the_ID() );
				$comment_num   = $comment_count->approved;
				if ( 0 !== $comment_num ) {
					echo '<span class="comment"><a href="#comments"><i class="icomoon icon-bubble"></i>' . absint( $comment_num ) . '</a></span>';
				}
			}

			do_action( 'nishiki_pro_after_singular_terms' );

		}
		if( is_page() ){
			do_action( 'nishiki_pro_before_singular_terms' );
			do_action( 'nishiki_pro_after_singular_terms' );
		}
		?>
	</div>
</header>
<?php } ?>
<?php do_action( 'nishiki_pro_after_singular_header' ); ?>
<?php do_action( 'nishiki_pro_before_singular_container' ); ?>
<div class="container<?php echo wp_kses_post( $container_class ); ?>">
	<?php do_action( 'nishiki_pro_before_singular_inner_container' ); ?>
	<article class="entry">
		<?php do_action( 'nishiki_pro_before_singular_content' ); ?>
		<div class="entry-content">
			<?php do_action( 'nishiki_pro_before_singular_inner_content' ); ?>
			<?php the_content(); ?>
			<?php do_action( 'nishiki_pro_after_singular_inner_content' ); ?>
			<?php wp_link_pages( 'before=<div class="pagination">&after=</div>&link_before=<span>&link_after=</span>' ); ?>
		</div>
		<?php do_action( 'nishiki_pro_after_singular_content' ); ?>
		<?php if ( is_singular() ) { ?>
		<footer>
			<?php
			nishiki_pro_singular_author();
			do_action( 'nishiki_pro_after_related_posts' );
			nishiki_pro_singular_comment_template();
			nishiki_pro_singular_post_navigation();
			edit_post_link( __( 'Edit This Page', 'nishiki-pro' ), '<p id="edit-link">', '</p>' );
			?>
		</footer>
		<?php } ?>
	</article>
	<?php
	if ( 'full-width' !== $template ) {
		do_action( 'nishiki_pro_sidebar' );
	}
	?>
	<?php do_action( 'nishiki_pro_after_singular_inner_container' ); ?>
</div>
<?php do_action( 'nishiki_pro_after_singular_container' ); ?>
