<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_ADMIN_ABOUT' ) ) {
	class NISHIKI_PRO_WC_ADMIN_ABOUT {

		private $page_name = 'nishiki_pro_wc_about';

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 20 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_submenu_page(
				'nishiki-pro-wc.php',
				'概要',
				'概要',
				'manage_options',
				'nishiki-pro-wc.php',
				array( $this, 'add_page' )
			);
		}

		/**
		 * ページの内容
		 */
		public function add_page() {
			$this->options = get_option( $this->page_name );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
				<div class="wrap">
				</div>
			<?php
		}

	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_WC_ADMIN_ABOUT();
	}
}
