<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_ADMIN_PAGE_SETTINGS' ) ) {
	class NISHIKI_PRO_WC_ADMIN_PAGE_SETTINGS {

		private $page_name = 'nishiki_pro_wc_page_settings';

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 20 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_submenu_page(
				'nishiki-pro-wc.php',
				'ページ最適化',
				'ページ最適化',
				'manage_options',
				'nishiki-pro-wc-page-optimize.php',
				array( $this, 'add_page' )
			);
		}

		/**
		 * ページの内容
		 */
		public function add_page() {
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
				<div class="wrap">
					<form method="post" id="nishiki-pro-wc-page-optimize" action="">
						<?php
						$nonce = wp_create_nonce( $this->page_name );
						echo '<input type="hidden" name="' . esc_attr( $this->page_name ) . '" value="' . esc_attr( $nonce ) . '" />';
						?>
						<h3>WooCommerce プラグインで自動生成されたページを Nishiki Pro 向けに最適化します。</h3>
						<?php
						// 最適化処理
						if( ! empty( $_POST['nishiki_pro_wc_page_settings_init'] ) && $_POST['nishiki_pro_wc_page_settings_init'] === '1' ){
							if ( ! current_user_can( 'manage_options' ) ) {
								wp_die( 'このページを表示する権限がありません。' );
							}

							if ( ! wp_verify_nonce( $_POST[$this->page_name], $this->page_name ) ) {
								wp_die( 'セキュリティチェックに失敗しました。' );
							}

							$optimize_pages = array(
								array(
									'id' => 'woocommerce_cart_page_id',
									'code' => 'woocommerce_cart',
									'name' => '買い物カゴページ',
								),
								array(
									'id' => 'woocommerce_myaccount_page_id',
									'code' => 'woocommerce_my_account',
									'name' => 'マイアカウントページ',
								),
								array(
									'id' => 'woocommerce_checkout_page_id',
									'code' => 'woocommerce_checkout',
									'name' => '商品を購入ページ',
								),
							);

							foreach( $optimize_pages as $optimize_page ){

								$id = get_option( $optimize_page['id'] );

								if( $id ){
									$result = wp_update_post(
										array(
											'ID' => $id,
											'post_content' => '<!-- wp:shortcode -->[' . esc_html( $optimize_page['code'] ) . ']<!-- /wp:shortcode -->'
										)
									);

									if ( $result ) {
										echo '<p>[' . esc_html( $optimize_page['name'] ) . ']を最適化しました。</p>';
									} else {
										echo '<p>[' . esc_html( $optimize_page['name'] ) . ']の最適化に失敗しました。</p>';
									}
								}
							}
						} else {
						?>
						<h4>対象ページ</h4>
						<ul>
							<li><a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_cart_page_id' ) ) ); ?>">買い物カゴページ</a></li>
							<li><a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>">マイアカウントページ</a></li>
							<li><a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_checkout_page_id' ) ) ); ?>">商品を購入ページ</a></li>
						</ul>
							<?php
								echo '<h3>最適化しますか？</h3>';
								echo '<h4>※注意：一度「実行」ボタンを押すと取り消すことができません。作業は慎重に行ってください。</h4>';
								submit_button( '実行（ページ最適化）' );
								echo '<h4>万が一作業に失敗するようでしたら <a target="_blank" href="https://support.animagate.com/community/">ユーザーコミュニティ</a> までご報告ください。</h4>';
								echo '<input type="hidden" name="' .  esc_attr( $this->page_name ) . '_init" value="1"' . '>';
						}
							?>
					</form>
				</div>
				<script>
					document.getElementById( "nishiki-pro-wc-page-optimize" ).addEventListener("submit", function(event) {
						const confirmed = confirm("最適化しますか？※注意：一度「実行」ボタンを押すと取り消すことができません。作業は慎重に行ってください。");
						if ( ! confirmed ) {
							event.preventDefault(); // 送信をキャンセル
						}
					});
				</script>
			<?php
		}

	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_WC_ADMIN_PAGE_SETTINGS();
	}
}
