<?php
if( ! function_exists( 'nishiki_pro_wc_init_customizer_product_archive' ) ) {
	add_action( "customize_register", "nishiki_pro_wc_init_customizer_product_archive" );
	function nishiki_pro_wc_init_customizer_product_archive( $wp_customize ) {

		// Section.
		$wp_customize->add_section('section_nishiki_pro_wc_product_archive',array(
			'title'     => __( 'Product Catalog', 'nishiki-pro-wc' ),
			'priority'  => 10,
			'panel'     => 'section_nishiki_pro_wc',
		));

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_product_archive_sidebar', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_product_archive_sidebar',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">サイドバー</p><p>※注意：アーカイブページでサイドバーを右 または サイドバー左に設定している場合のみ反映されます。</p>',
					'section'       =>  'section_nishiki_pro_wc_product_archive',
					'settings'      =>  'setting_nishiki_pro_wc_header_product_archive_sidebar',
				)
			)
		);

		// Sidebar Width.
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_product_archive_sidebar_width' , array(
			'default'     => 300,
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		) );

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Range(
				$wp_customize,
				'ctrl_nishiki_pro_wc_product_archive_sidebar_width',
				array(
					'label'     => __( 'Width(px)', 'nishiki-pro' ),
					'min'       => 0,
					'max'       => 1000,
					'step'      => 10,
					'section'   => 'section_nishiki_pro_wc_product_archive',
					'settings'  => 'setting_nishiki_pro_wc_product_archive_sidebar_width',
				)
			)
		);

		// Sidebar Margin.
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_product_archive_sidebar_margin' , array(
			'default'     => 50,
			'transport'   => '',
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		) );

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Range(
				$wp_customize,
				'ctrl_nishiki_pro_wc_product_archive_sidebar_margin',
				array(
					'label'     => __( 'Margin(px)', 'nishiki-pro' ),
					'min'       => 0,
					'max'       => 50,
					'step'      => 1,
					'section'   => 'section_nishiki_pro_wc_product_archive',
					'settings'  => 'setting_nishiki_pro_wc_product_archive_sidebar_margin',
				)
			)
		);

		// Title Background Color
		$wp_customize->add_setting('setting_archive_title_background_color',array(
			'default' => '#000000',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_archive_title_background_color',
				array(
					'label'       => __( 'Title Background Color', 'nishiki' ),
					'section'     => 'section_archive',
					'settings'    => 'setting_archive_title_background_color',
				)
			)
		);

		// Title Background Opacity
		$wp_customize->add_setting( 'setting_archive_title_background_opacity' , array(
			'default'     => 100,
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		) );

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Range(
				$wp_customize,
				'ctrl_archive_title_background_opacity',
				array(
					'label'	=>  __( 'Title Background Opacity(%)', 'nishiki-pro' ),
					'min' => 0,
					'max' => 100,
					'step' => 1,
					'section' => 'section_archive',
					'settings'   => 'setting_archive_title_background_opacity',
				)
			)
		);

		// Title Text Color
		$wp_customize->add_setting('setting_archive_title_text_color',array(
			'default' => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_archive_title_text_color',
				array(
					'label'       => __( 'Title Text Color', 'nishiki-pro' ),
					'section'     => 'section_archive',
					'transport'   => 'postMessage',
					'settings'    => 'setting_archive_title_text_color',
				)
			)
		);

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_product_archive_price_display', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_product_archive_price_display',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">価格</p>',
					'section'       =>  'section_nishiki_pro_wc_product_archive',
					'settings'      =>  'setting_nishiki_pro_wc_header_product_archive_price_display',
				)
			)
		);

		// Display Price
		$wp_customize->add_setting(
			'setting_nishiki_pro_wc_product_archive_price_display',
			array(
				'default' => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control('ctrl_nishiki_pro_wc_product_archive_price_display',array(
			'label'       =>  __( 'Display', 'nishiki-pro' ),
			'type'        =>  'checkbox',
			'section'     =>  'section_nishiki_pro_wc_product_archive',
			'settings'    =>  'setting_nishiki_pro_wc_product_archive_price_display',
		));
	}
}
