<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_ADMIN_INIT' ) ) {
	class NISHIKI_PRO_WC_ADMIN_INIT {

		/**
		 * constructor.
		 *
		 */
		public function __construct() {
			add_action( 'admin_init', array( $this, 'activate_plugin_check' ), 10 );
			add_action( 'admin_init', array( $this, 'activate_theme_check' ), 10 );
			add_action( 'admin_init', array( $this, 'activate_code_check' ), 10 );
		}

		public function activate_plugin_check(){

			// WooCommerce Active Check
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

			if( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ){
				// Notice
			add_action( 'admin_notices', array( $this, 'active_plugin_admin_notices') );
			}

    	}

		public function activate_theme_check(){

			// Nishiki Pro Active Check
			$theme = wp_get_theme();

			$flag = false;

			if( $theme->Template === 'nishiki-pro' ){
				$flag = true;
			}

			if ( $flag === false ) {
				// Notice
				add_action( 'admin_notices', array( $this, 'active_theme_admin_notices') );
			}

		}

		public function activate_code_check(){

			// Update Check
			$reg_key_data = get_option( 'nishiki_pro_wc' );
			$reg_key = isset( $reg_key_data['reg_key'] ) ? $reg_key_data['reg_key'] : '';
			
			if( empty( $reg_key ) ){
				// Notice
				add_action( 'admin_notices', array( $this, 'active_code_admin_notices') );
			}

    	}

		public function active_plugin_admin_notices() {
			$message = sprintf( 'Nishiki Pro for WooCommerce を利用するには WooCommerce プラグインを有効化してください。' );
			printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
		}

		public function active_theme_admin_notices() {
			$message = sprintf( 'Nishiki Pro for WooCommerce を利用するには <a target="_blank" rel="noreferrer noopener" href="https://support.animagate.com/product/wp-nishiki-pro/">Nishiki Pro</a> テーマ（または Nishiki Pro 子テーマ）を有効化してください。' );
			printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
		}

		public function active_code_admin_notices() {
			$message = sprintf( '<h3>【重要なお知らせ】製品登録のお願い（製品版では、このメッセージは消えます）</h3><p>現在 Nishiki Pro for WooCommerce プラグインの「お試し版」を使用しています。「お試し版」の継続利用はお勧めしません。ライセンスを購入し、発行した「登録キー」を入力し「製品版」にアップグレードしてください。</p><p>「製品版」では、プラグインのアップデートサービスを提供します。</p>
			<p>ライセンスは買い切り型です。月額/年額などの更新費用はかかりません。ただし、1 つのウェブサイトにつき 1 つのライセンスが必要です。</p><p><a class="button button-primary" target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/product/wp-nishiki-pro-wc/">ライセンスを購入する</a></p>' );
			printf( '<div class="notice notice-warning"><p>%s</p></div>', $message );
		}
	}

	$output = new NISHIKI_PRO_WC_ADMIN_INIT();
}
