<?php

/**
 * Translate
 */

if ( ! function_exists('nishiki_pro_wc_load_textdomain') ) {
	function nishiki_pro_wc_load_textdomain(){
		load_plugin_textdomain( 'nishiki-pro-wc', false, 'nishiki-pro-wc/languages' );
	}

	add_action( 'init', 'nishiki_pro_wc_load_textdomain' );
}

/**
 * Translate(WooCommerce)
 */
if ( ! function_exists( 'nishiki_pro_wc_change_translated_text' ) ) {

	function nishiki_pro_wc_change_translated_text( $translated_text, $untranslated_text, $domain ) {
   
	if( $domain == 'woocommerce' ){
		switch ( $untranslated_text ) {

				case 'Register':
					$translated_text = 'アカウント登録';
				break;
		
				case 'A link to set a new password will be sent to your email address.':
					$translated_text = 'アカウント登録後、メールアドレス宛にログイン用パスワードの設定リンクが送信されます。';
				break;

				case 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)':
					$translated_text = '現在 %1$s さんでログインしています。';
				break;

				case 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">billing address</a>, and <a href="%3$s">edit your password and account details</a>.':
					$translated_text = 'マイアカウントでは「<a href="%1$s">注文履歴の確認</a>」「<a href="%2$s">お届け先住所の管理</a>」「<a href="%3$s">アカウント管理</a>」などが行えます。';
				break;

				case 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.':
					$translated_text = 'マイアカウントでは「<a href="%1$s">注文履歴の確認</a>」「<a href="%2$s">お届け先住所の管理</a>」「<a href="%3$s">アカウント管理</a>」などが行えます。';
				break;

				case 'Order again':
					$translated_text = '再注文する';
				break;

				case 'Orders':
					$translated_text = '注文履歴';
				break;


				case 'No order has been made yet.':
					$translated_text = '注文履歴はありません。';
				break;

				
				

			}
		}

		return $translated_text;
	}
   
	add_filter( 'gettext', 'nishiki_pro_wc_change_translated_text', 10, 3 );
 }

/**
 * Style and Script
 */

// Enqueue CSS & JS
if ( ! function_exists( 'nishiki_pro_wc_read_scripts' ) ) {
	function nishiki_pro_wc_read_scripts(){
		wp_register_style( 'nishiki-pro-wc', plugins_url( 'nishiki-pro-wc/assets/css/front-end.min.css' ) );

		if ( class_exists( 'woocommerce' ) ) {
			wp_enqueue_style( 'nishiki-pro-wc' );
		}

		// Add Inline Style.
		if( function_exists( 'nishiki_pro_wc_customizer_css' ) ){
			wp_add_inline_style( 'nishiki-pro-wc', nishiki_pro_wc_customizer_css() );
		}

	  //wp_enqueue_script( 'nishiki-pro-wc', plugins_url( 'nishiki-pro-wc/assets/js/nishiki-pro-wc.js' ), array(), '', true );
	}

	add_action( 'wp_enqueue_scripts', 'nishiki_pro_wc_read_scripts', 200 );
}

// Enqueue CSS & JS(Admin)
if ( ! function_exists('nishiki_pro_wc_admin_read_scripts') ) {
	function nishiki_pro_wc_admin_read_scripts() {
		// Add Customizer Style
		wp_register_style( 'nishiki-pro-wc-admin-style', plugins_url( 'nishiki-pro-wc/assets/css/admin.min.css' ), array(), null, false );
		wp_enqueue_style( 'nishiki-pro-wc-admin-style' );
	}

	//add_action( 'admin_enqueue_scripts', 'nishiki_pro_wc_admin_read_scripts' );
}

/*****************
 * Enqueue block editor style
 *****************/

if( ! function_exists( 'nishiki_pro_wc_back_end_style' ) ) {

	function nishiki_pro_wc_back_end_style() {
		wp_enqueue_style( 'nishiki-pro-wc-back-end-style', plugins_url( 'nishiki-pro-wc/assets/css/back-end.min.css' ), false, '1.0', 'all' );
	}

	add_action( 'enqueue_block_editor_assets', 'nishiki_pro_wc_back_end_style' );
}

// Remove WooCommerce Style.
// Remove each style one by one
if( ! function_exists( 'jk_dequeue_styles' ) ) {
	function jk_dequeue_styles( $enqueue_styles ) {
		unset( $enqueue_styles['woocommerce-general'] );	// Remove the gloss
		unset( $enqueue_styles['woocommerce-layout'] );		// Remove the layout
		unset( $enqueue_styles['woocommerce-smallscreen'] );	// Remove the smallscreen optimisation

		return $enqueue_styles;
	}

	//add_filter( 'woocommerce_enqueue_styles', 'jk_dequeue_styles' );
}

add_filter( 'woocommerce_enqueue_styles', '__return_false' );

/**
 * Add Theme Support
 */

if( ! function_exists( 'nishiki_pro_wc_theme_support' ) ) {
	add_action( 'after_setup_theme', 'nishiki_pro_wc_theme_support' );
	function nishiki_pro_wc_theme_support() {
		add_theme_support( 'woocommerce', array(
				'thumbnail_image_width' => 640,
				'single_image_width'    => 640,
				'gallery_thumbnail_image_width' => 90,
				'product_grid'
				=> array(
					'default_rows'    => 3,
					'min_rows'        => 2,
					'max_rows'        => 8,
					'default_columns' => 3,
					'min_columns'     => 2,
					'max_columns'     => 3,
				),
			)
		);

		// Gallery Setup.
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
}


/**
 * Product Page Setting
 */

// Archive Page.
if( ! function_exists( 'nishiki_pro_wc_archive_product' ) ) {

	function nishiki_pro_wc_archive_product() {
	  // Remove Default Product Loop.
	  remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
	  remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
	  remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
	  remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

	  // Add Product Loop.
	  add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 5 );
	  add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
	  add_action( 'woocommerce_before_shop_loop_item_title', 'nishiki_pro_wc_show_detail_button', 10 );
	  add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 15 );
	  add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 50 );
	}

	add_action( 'woocommerce_before_shop_loop', 'nishiki_pro_wc_archive_product', 20 );
}

// Single Page.
if( ! function_exists( 'nishiki_pro_wc_single_product' ) ) {

	function nishiki_pro_wc_single_product() {
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
		remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating' );


		add_action( 'woocommerce_before_single_product_summary', 'woocommerce_template_single_excerpt', 5 );
		add_action( 'woocommerce_after_main_content', 'woocommerce_output_related_products', 20 );

		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 8 );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_sale_flash', 9 );
		add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );

		// Rating
		remove_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10 );
		add_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_comment_text', 20 );

		// Review
		remove_action( 'woocommerce_review_meta', 'woocommerce_review_display_meta', 10 );
		add_action( 'woocommerce_review_meta', 'woocommerce_review_display_rating', 20 );

		// Comment
		remove_action( 'woocommerce_review_comment_text', 'woocommerce_review_display_comment_text', 10 );
		add_action( 'woocommerce_review_comment_text', 'woocommerce_review_display_meta', 20 );

	}

	add_action( 'woocommerce_before_single_product', 'nishiki_pro_wc_single_product', 20 );

	// Related Posts.
	add_action( 'woocommerce_before_single_product', 'nishiki_pro_wc_archive_product', 20 );
}

// Review Comment List.
if( ! function_exists( 'nishiki_pro_wc_single_review' ) ) {
	function nishiki_pro_wc_single_review(){
	  remove_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10 );
	  add_action( 'woocommerce_review_meta', 'woocommerce_review_display_rating', 5 );
	}

	//add_action( 'woocommerce_review_before', 'nishiki_pro_wc_single_review', 10 );
}


// Add Detail Button.
if( ! function_exists( 'nishiki_pro_wc_show_detail_button' ) ) {
	function nishiki_pro_wc_show_detail_button() {
		echo '<p class="detail"><span>詳細を見る</span></p>';
	}
}

// Related Products Number.
if( ! function_exists( 'jk_related_products_args' ) ) {
	add_filter( 'woocommerce_output_related_products_args', 'jk_related_products_args' );
	function jk_related_products_args( $args ) {
		$related_posts_num = get_theme_mod( 'setting_nishiki_pro_wc_product_related_posts_number', 3 );
		$args['posts_per_page'] = $related_posts_num; // 4 related products
		$args['columns'] = 2; // arranged in 2 columns
		return $args;
	}
}

/**
 * Header Setting
 */
// Header Cart Icon.
if( ! function_exists( 'nishiki_pro_wc_add_cart_button' ) ) {
	add_action( 'nishiki_pro_before_site_nav_inner_search_button','nishiki_pro_wc_add_cart_button' );
	function nishiki_pro_wc_add_cart_button() {
		if ( function_exists( 'WC' ) && get_theme_mod( 'setting_nishiki_pro_wc_header_display_cart_icon', true ) ) {
			if ( get_theme_mod( 'setting_nishiki_pro_wc_header_display_cart_badge', true ) === true ) {
				$badge = '<span class="badge">' . absint( WC()->cart->get_cart_contents_count() ) . '</span>';
			} else {
				$badge = '';
			}
			?>
					<a class="icon" id="cart-customlocation" href="<?php echo esc_url( wc_get_cart_url() ); ?>"><i class="icomoon icon-cart"></i><?php echo wp_kses_post( $badge ); ?>
					</a>
			<?php
		}
	}
}

/**
 * Cart Page
 */

if( ! function_exists( 'nishiki_pro_wc_add_cart_update_button' ) ) {
	function nishiki_pro_wc_add_cart_update_button(){
		$html = '<div class="wc-update-cart">';
		$html .= '<button type="submit" class="button" name="update_cart" value="' . __( 'Update cart', 'woocommerce' ) . '"><i class="icomoon icon-loop2"></i>' . __( 'Update cart', 'woocommerce' ) . '</button>';
		$html .= do_action( 'woocommerce_cart_actions' );
		$html .= wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' );
		$html .= '</div>';

		echo $html;
	}

	add_action( 'woocommerce_proceed_to_checkout', 'nishiki_pro_wc_add_cart_update_button', 5 );
}

/**
 * add-to-cart.php
 */

if( ! function_exists( 'nishiki_pro_wc_add_to_cart_link' ) ) {
	function nishiki_pro_wc_add_to_cart_link( $text, $product, $args ){
		return sprintf( '<div class="add-to-cart-link-wrapper"><a href="%s" data-quantity="%s" class="%s" %s>%s</a></div>',
			esc_url( $product->add_to_cart_url() ),
			esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
			esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
			isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
			esc_html( $product->add_to_cart_text() )
		);
	}

	add_filter( 'woocommerce_loop_add_to_cart_link', 'nishiki_pro_wc_add_to_cart_link', 10, 3 );
}

/**
 * Coupon
 */

// Delete Coupon Address page.
//remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );

// Coupon JS.
if( ! function_exists( 'nishiki_pro_wc_show_coupon_js' ) ) {
	//add_action( 'woocommerce_before_checkout_form', 'nishiki_pro_wc_show_coupon_js' );
	function nishiki_pro_wc_show_coupon_js() {
		if ( function_exists( 'wc_enqueue_js' ) ) {
			wc_enqueue_js( '		
		$( "body" ).bind( "updated_checkout", function() {
			$( "a.showcoupon" ).click( function() {
				$( ".checkout_coupon" ).slideToggle();
				$( "html, body" ).animate( { scrollTop: 0 }, "slow" );
  				return false;
			} );
		} );		
	');
		}
	}
}

// Amount number JS.
if( ! function_exists( 'nishiki_pro_wc_input_number_js' ) ) {
	add_action( 'after_setup_theme', 'nishiki_pro_wc_input_number_js' );
	function nishiki_pro_wc_input_number_js() {
		if ( function_exists( 'wc_enqueue_js' ) ) {
			wc_enqueue_js( '
		$( "body" ).bind( "updated_cart_totals", function() {
			$( ".minus" ).click( function() {
				var $input = $(this).parents(".quantity").find(".input-text");
				var val = parseInt($input.val(), 10);
				if( val > 0 ){
					$input.val(val - 1);
	
					event.preventDefault();
					$(".wc-update-cart").find(".button").prop("disabled", false);
				}
			});
	
			$( ".plus" ).click( function() {
				var $input = $(this).parents(".quantity").find(".input-text");
				var val = parseInt($input.val(), 10);
				$input.val(val + 1);
				
				event.preventDefault();
				$(".wc-update-cart").find(".button").prop("disabled", false);
			})
		});
	
		$( ".minus" ).click( function() {
  		var $input = $(this).parents(".quantity").find(".input-text");
  		var val = parseInt($input.val(), 10);
  		if( val > 0 ){
				$input.val(val - 1);
	
				event.preventDefault();
				$(".wc-update-cart").find(".button").prop("disabled", false);
  		}
		});

		$( ".plus" ).click( function() {
			var $input = $(this).parents(".quantity").find(".input-text");
			var val = parseInt($input.val(), 10);
			$input.val(val + 1);
			
  		event.preventDefault();
   		$(".wc-update-cart").find(".button").prop("disabled", false);
		})
	');
		}
	}
}

// change reviews title
if( ! function_exists( 'nishiki_pro_wc_reviews_title' ) ) {
	function nishiki_pro_wc_reviews_title( $reviews_title, $count, $product ){
		$title = printf( esc_html( _n( '%1$s review', '%1$s reviews', $count, 'nishiki_pro_wc' ) ), esc_html( $count ) );
	}

	add_filter( 'woocommerce_reviews_title', 'nishiki_pro_wc_reviews_title', 10, 3 );
}

//woocommerce_reviews_title

// Payment Checkout Page
if( ! function_exists( 'nishiki_pro_wc_payment_before_title' ) ) {
	add_action( 'woocommerce_checkout_order_review', 'nishiki_pro_wc_payment_before_title', 15 );
	function nishiki_pro_wc_payment_before_title(){
		// カートの合計金額を取得
		$cart_total = WC()->cart->get_total('edit');

		// 合計金額が0円の場合の処理
		if ( absint( $cart_total ) !== 0 ) {
			echo '<h3>決済方法を選んでください</h3>';
		}
	}
}

if( ! function_exists( 'nishiki_pro_wc_before_terms_and_conditions' ) ) {
	  add_action( 'woocommerce_checkout_terms_and_conditions', 'nishiki_pro_wc_before_terms_and_conditions', 15 );
	  function nishiki_pro_wc_before_terms_and_conditions(){
	    $page_id = wc_privacy_policy_page_id();

	    if( $page_id ){
	      echo '<h3>個人情報の取り扱いについて</h3>';
			}
	  }
}

// Remember Message
if( ! function_exists( 'nishiki_pro_wc_checkout_login_message' ) ) {
	//add_action( 'woocommerce_checkout_login_message', 'nishiki_pro_wc_checkout_login_message', 15 );
	function nishiki_pro_wc_checkout_login_message(){
		return '会員登録済みですか？';
	}
}

/*****************
 * Content Sidebar Class
 *****************/

// Add Content Class
if ( ! function_exists( 'nishiki_pro_wc_content_sidebar_class' ) ) {
	function nishiki_pro_wc_content_sidebar_class( $class ){

	  if( is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() ){
			$class = '';
		}

	  if( is_product() ){
			// テンプレートの適用を取得
	    $current_product_sidebar_column = get_theme_mod( 'setting_nishiki_pro_wc_product_sidebar_column' );
	    if( $current_product_sidebar_column ){
	      $class= ' sidebar-' . $current_product_sidebar_column;
			}
    }

	  return $class;
	}
	add_filter( 'nishiki_pro_content_class', 'nishiki_pro_wc_content_sidebar_class', 20 );
}

/*****************
 * Sidebar Column
 *****************/

if ( ! function_exists( 'nishiki_pro_wc_product_sidebar_column' ) ) {
	function nishiki_pro_wc_product_sidebar_column( $column ){

	  // 個別製品ページではカスタマイザーの設定を適用
	  if( is_product() ){
	    $column = get_theme_mod( 'setting_nishiki_pro_wc_product_sidebar_column' );
	  }

	  return $column;
	}
	add_filter( 'nishiki_pro_post_sidebar_column', 'nishiki_pro_wc_product_sidebar_column', 20 );
}


/*****************
 * Sidebar Disable
 *****************/

// Sidebar Disable
if ( ! function_exists( 'nishiki_pro_wc_sidebar_disable' ) ) {
	function nishiki_pro_wc_sidebar_disable( $sidebars ){

	  if( is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() ){
	    unset( $sidebars['sidebar_sticky'] );
	    unset( $sidebars['sidebar_main'] );
	  }

	  return $sidebars;
	}
}
add_filter( 'sidebars_widgets', 'nishiki_pro_wc_sidebar_disable', 20, 1 );


// ページのヘッダーの属性（ style + class ）
if ( ! function_exists( 'nishiki_pro_wc_custom_page_header_attributes' ) ) {
	function nishiki_pro_wc_custom_page_header_attributes(){

	  if( is_shop() || is_product_taxonomy() || is_product() || is_cart() || is_checkout() || is_account_page() ){

			$attr = '';
			$eye_catch_layout = 'background';
			$woo_class = '';

			//ショップのアーカイブページ
			if( is_shop() || is_product_taxonomy() ){
				if ( ! empty( get_queried_object()->term_id ) ) {
					$term_id = get_queried_object()->term_id;

					$eye_catch_layout = get_theme_mod( 'setting_archive_eye_catch_layout', 'background' );

					if ( $value = get_term_meta( $term_id, 'eye_catch_layout', true ) ) {
						$eye_catch_layout = $value;
					}

					$attachiment_id = get_term_meta( $term_id, 'eye_catch', true ) ? get_term_meta( $term_id, 'eye_catch', true ) : '';

					if ( ! empty( $attachiment_id ) && get_theme_mod( 'setting_archive_eye_catch', false ) == true && $eye_catch_layout == 'background' ) {
						$attr .= ' style="background-image:url(' . esc_url( wp_get_attachment_url( $attachiment_id ) ) . ');"';
					}
				}
			}

			// ショップのトップページ
			if( is_shop() ){
				$shop_id = wc_get_page_id( 'shop' );
				if( $value = get_post_meta( $shop_id, '_nishiki_pro_meta_box_eye_catch_layout_page', true ) ){
					$eye_catch_layout = $value;
				}

				$woo_class = 'woocommerce-archive-header ';

				if( has_post_thumbnail( $shop_id ) ){
					if( get_the_post_thumbnail_url( $shop_id, 'full' ) && $eye_catch_layout == 'background' ) {
						$attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( $shop_id, 'full' ) ) . ');"';
					}
				}

			}

			// 商品詳細ページ、カートページ、チェックアウトページ、アカウントページ
			if( is_product() || is_cart() || is_checkout() || is_account_page() ){
				if( $value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_eye_catch_layout_' . get_post_type(), true ) ){
					$eye_catch_layout = $value;
				}

				//var_dump($eye_catch_layout);

				if( has_post_thumbnail() ){
					if ( get_theme_mod( 'setting_nishiki_pro_wc_product_eye_catch', false ) === true ) {
						if ( get_the_post_thumbnail_url( get_the_ID(), 'full' ) && $eye_catch_layout == 'background' ) {
						$attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) . ');"';
						}
					}
				}
			}

			// 属性追加
			$attr .= ' class="page-header ' . $woo_class . esc_attr( get_post_type() ) . ' eye-catch-' . esc_attr( $eye_catch_layout) . '"';

			return $attr;
	  }

	  $attr = '';
	  $eye_catch_layout = 'background';
	  $amp_class = '';

	  // 投稿ページ
	  if( is_single() ){
		  $eye_catch_layout = get_theme_mod( 'setting_post_eye_catch_layout', 'background' );

		  if( $value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_eye_catch_layout_' . get_post_type(), true ) ){
			  $eye_catch_layout = $value;
		  }

		  if( has_post_thumbnail() ){
			  if( get_theme_mod( 'setting_post_eye_catch', false ) == true) {
				  if( get_the_post_thumbnail_url( get_the_ID(), 'full' ) && $eye_catch_layout == 'background' ) {
					  $attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) . ');"';
				  }
			  }
		  }
	  }

	  // 固定ページ
	  if( is_page() ){
		  $eye_catch_layout = get_theme_mod( 'setting_page_eye_catch_layout', 'background' );

		  if( $value = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_eye_catch_layout_' . get_post_type(), true ) ){
			  $eye_catch_layout = $value;
		  }

		  if( has_post_thumbnail() ){
			  if( get_theme_mod( 'setting_page_eye_catch', false ) == true ) {
				  if( get_the_post_thumbnail_url( get_the_ID(), 'full' ) && $eye_catch_layout == 'background' ) {
					  $attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) . ');"';
				  }
			  }
		  }
	  }

	  // アーカイブページ
	  if( is_archive() ){
		  if( ! empty( get_queried_object()->term_id ) ){
			  $term_id = get_queried_object()->term_id;

			  $eye_catch_layout = get_theme_mod( 'setting_archive_eye_catch_layout', 'background' );

			  if( $value = get_term_meta( $term_id, 'eye_catch_layout', true ) ){
				  $eye_catch_layout = $value;
			  }

			  $attachiment_id = get_term_meta( $term_id, 'eye_catch', true ) ? get_term_meta( $term_id, 'eye_catch', true ) : '';

			  if( ! empty( $attachiment_id ) && get_theme_mod( 'setting_archive_eye_catch', false ) == true && $eye_catch_layout == 'background' ){
				  $attr .= ' style="background-image:url(' . esc_url( wp_get_attachment_url( $attachiment_id ) ) . ');"';
			  }
		  }
	  }

	  // ブログページ
	  if ( ! is_front_page() && is_home() ) {
		  $blog_page_id = get_option( 'page_for_posts' );
		  $eye_catch_layout = get_theme_mod( 'setting_page_eye_catch_layout', 'background' );

		  if( $value = get_post_meta( $blog_page_id, '_nishiki_pro_meta_box_eye_catch_layout_page', true ) ){
			  $eye_catch_layout = $value;
		  }

		  if( has_post_thumbnail( $blog_page_id ) ){
			  if( get_the_post_thumbnail_url( $blog_page_id, 'full' ) && $eye_catch_layout == 'background' ){
				  $attr .= ' style="background-image:url(' . esc_url( get_the_post_thumbnail_url( $blog_page_id, 'full' ) ) . ');"';
			  }
		  }
	  }

	  // ページタイプの定義
	  if( is_single() ){
		  $page_type = get_post_type();
	  } else {
		  $page_type = 'archive';
	  }

	  // 属性追加
	  $attr .= ' class="page-header ' . $amp_class . esc_attr( $page_type ) . ' eye-catch-' . esc_attr( $eye_catch_layout ) . '"';

	  return $attr;
  }

	add_filter( 'nishiki_pro_page_header_attributes', 'nishiki_pro_wc_custom_page_header_attributes', 50 );
}

// 翻訳文言を書き換え
if ( ! function_exists( 'nishiki_pro_wc_translate_text' ) ) {

	function nishiki_pro_wc_translate_text( $translated_text, $untranslated_text, $domain ) {

		if( $domain == 'woocommerce' ){
			switch ( $untranslated_text ) {
				case 'Create an account?':
					$translated_text = '購入時にアカウントを作成する';
					break;
				case 'Ship to a different address?':
					$translated_text = '別の住所へ配送する';
					break;
				case 'Sale!':
					$translated_text = 'SALE';
					break;
				case 'Returning customer?':
					$translated_text = 'アカウントをお持ちの方はログインしてください。';
					break;
				case 'Enter a different address':
					$translated_text = '別の配送先を入力する';
					break;
				case 'No shipping options were found for %s.':
					$translated_text = '%s は配送先に指定できません。';
					break;
				case 'Shipping to %s.':
					$translated_text = '配送先：%s';
					break;
				case 'Change address':
					$translated_text = '配送先を変更する';
					break;
				case 'Enter your address to view shipping options.':
					$translated_text = '配送先の住所を入力して送料を計算してください。';
					break;
				case 'There are no shipping options available. Please ensure that your address has been entered correctly, or contact us if you need any help.':
					$translated_text = '利用できる配送方法がありません。住所を正しく入力してください。';
					break;
				case 'Your review';
					$translated_text = 'レビューを書く';
					break;
			}
		}

		return $translated_text;
	}

	add_filter( 'gettext', 'nishiki_pro_wc_translate_text', 20, 3 );
}

// ページネーション書き換え
if ( ! function_exists( 'nishiki_pro_wc_pagination' ) ) {
	function nishiki_pro_wc_pagination( $args ){

		$args = array(
			'prev_text' => '<i class="icomoon icon-arrow-left"></i>',
			'next_text' => '<i class="icomoon icon-arrow-right"></i>',
			'type'      => 'list',
		);

		return $args;
	}

	add_filter( 'woocommerce_pagination_args', 'nishiki_pro_wc_pagination', 20, 1 );
}

/*****************
 * Eye Catche Layout(Archive)
 *****************/

if( ! function_exists( 'nishiki_pro_wc_shop_eye_catch_layout' ) ) {
	function nishiki_pro_wc_shop_eye_catch_layout( $shop_id, $class = '' ){

	  if( ! has_post_thumbnail( $shop_id ) ){
		  return false;
	  }

	  $output = '';
	  $eye_catch = get_the_post_thumbnail( $shop_id, 'full' );
	  if ( ! empty( $class ) ) {
		  $class = ' ' . $class;
	  }

	  $output .= '<div class="eye-catch' . $class . '">';
	  $output .= $eye_catch;
	  $output .= '</div>';

	  return $output;
	}
}

//ショップのトップページのアイキャッチレイアウト
if( ! function_exists( 'nishiki_pro_wc_shop_eye_catch_output' ) ) {
	function nishiki_pro_wc_shop_eye_catch_output(){
		if( ! is_shop() ) { return false; }

	  global $post;

		$shop_id = wc_get_page_id( 'shop' );

	  if( ! has_post_thumbnail( $shop_id ) ) {  return false; }

	  $eye_catch_layout = '';

	  if( $value = get_post_meta( $shop_id, '_nishiki_pro_meta_box_eye_catch_layout_page', true ) ){
		  $eye_catch_layout = $value;
	  }

		if ( $eye_catch_layout == 'top' ) {
			add_action( 'nishiki_pro_before_archive_header', function() use ( $shop_id ) { echo nishiki_pro_wc_shop_eye_catch_layout( $shop_id ); }, 100 );
		}

		if ( $eye_catch_layout == 'bottom' ) {
			add_action( 'nishiki_pro_after_archive_header', function() use ( $shop_id ) { echo nishiki_pro_wc_shop_eye_catch_layout( $shop_id ); }, 100 );
		}

		if ( $eye_catch_layout == 'content' ) {
			add_action( 'nishiki_pro_before_archive_inner_archives', function() use ( $shop_id ) { echo nishiki_pro_wc_shop_eye_catch_layout( $shop_id ); }, 100 );
		}

		if ( $eye_catch_layout == 'content-wide' ) {
			add_action( 'nishiki_pro_before_archive_container', function() use ( $shop_id ) { echo nishiki_pro_wc_shop_eye_catch_layout( $shop_id, 'container' ); }, 100 );
		}

	}

	add_action( 'template_redirect', 'nishiki_pro_wc_shop_eye_catch_output', 100 );
}

//特定のページだけテンプレート適用を除外
if( ! function_exists( 'nishiki_pro_wc_exclude_page_templates' ) ) {
	function nishiki_pro_wc_exclude_page_templates( $post_templates, $this_template, $post, $post_type ) {
		if(
			get_option( 'woocommerce_myaccount_page_id' ) == $post->ID ||
	  	get_option( 'woocommerce_edit_address_page_id' ) == $post->ID ||
			wc_get_page_id('cart') == $post->ID ||
			wc_get_page_id('checkout') == $post->ID ||
	  	get_option( 'woocommerce_pay_page_id' ) == $post->ID ||
			wc_get_page_id('returns') == $post->ID
		){
			$post_templates = array();
		}

		return $post_templates;
	}

	add_filter( 'theme_page_templates', 'nishiki_pro_wc_exclude_page_templates', 10, 4 );
}

// タブのh2を削除
add_filter( 'woocommerce_product_description_heading', '__return_false' );
add_filter( 'woocommerce_product_additional_information_heading', '__return_false' );

// レビューのタイトルを変更
if( ! function_exists( 'nishiki_pro_wc_change_reviews_title' ) ) {
	function nishiki_pro_wc_change_reviews_title( $reviews_title, $count, $product ) {

		$reviews_title = $count . '件のレビュー';
		return $reviews_title ;
	}

	add_filter( 'woocommerce_reviews_title', 'nishiki_pro_wc_change_reviews_title', 10 ,3 );
}

// マイアカウントページ
if( ! function_exists( 'nishiki_pro_wc_custom_body_classes' ) ) {
	function nishiki_pro_wc_custom_body_classes( $classes ) {
		if ( is_account_page() && is_user_logged_in() ) {
			$classes[] = 'my-account-login';
		}
	
		return $classes;
	}

	add_filter( 'body_class', 'nishiki_pro_wc_custom_body_classes' );	
}

// 商品アーカイブページで価格を非表示にする
if( ! function_exists( 'nishiki_pro_wc_hide_price_on_archive_pages' ) ) {
	function nishiki_pro_wc_hide_price_on_archive_pages( $price, $product ) {
		if( get_theme_mod( 'setting_nishiki_pro_wc_product_archive_price_display', true ) ){
			return $price;
		}

		if ( is_shop() || is_product_category() || is_product_tag() ) {
			return '';
		}

		return $price;
	}

	add_filter( 'woocommerce_get_price_html', 'nishiki_pro_wc_hide_price_on_archive_pages', 10, 2 );
}

// 関連商品の価格を非表示にする
if( ! function_exists( 'nishiki_pro_wc_hide_price_on_related_products' ) ) {
	function nishiki_pro_wc_hide_price_on_related_products( $price, $product ) {
		if( get_theme_mod( 'setting_nishiki_pro_wc_product_related_posts_price_display', true ) ){
			return $price;
		}

		if ( is_product() && did_action( 'woocommerce_after_single_product_summary' ) ) {
			return '';
		}

		return $price;
	}

	add_filter('woocommerce_get_price_html', 'nishiki_pro_wc_hide_price_on_related_products', 10, 2);
}
