<?php
/**
 * Template Name: No Sidebar
 * Template Post Type: post, page, product
 *
 * @package Nishiki
 */

get_template_part( 'parts/header/meta' );
get_template_part( 'parts/header/content-sidebar-none' ); ?>
	<main id="main" role="main" <?php post_class(); ?>>
	  <?php do_action( 'nishiki_pro_before_singular_header', $post ); ?>
	  <?php
	  // タイトルを非表示にしてるかどうかチェック
	  if ( empty( get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_title_disable_' . get_post_type(), true ) ) ) {
		  ?>
				<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
					<div class="page-header-inner container">
			  <?php do_action( 'nishiki_pro_before_singular_title' ); ?>
			  <?php the_title( '<h1>', '</h1>' ); ?>
			  <?php do_action( 'nishiki_pro_after_singular_title' ); ?>
					</div>
				</header>
	  <?php } ?>
	  <?php do_action( 'nishiki_pro_after_singular_header' ); ?>
	  <?php
	  /**
	   * woocommerce_before_main_content hook.
	   *
	   * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	   * @hooked woocommerce_breadcrumb - 20
	   */
	  //do_action( 'woocommerce_before_main_content' );
	  ?>

	  <?php do_action( 'nishiki_pro_before_singular_container' ); ?>
		<div class="container column">
		<?php do_action( 'nishiki_pro_before_singular_inner_container' ); ?>
			<article class="entry woocommerce-single-product">
		  <?php do_action( 'nishiki_pro_before_singular_content' ); ?>
				<div class="entry-content">
			<?php do_action( 'nishiki_pro_before_singular_inner_content' ); ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php wc_get_template_part( 'content', 'single-product' ); ?>
			<?php endwhile; // end of the loop. ?>
			<?php do_action( 'nishiki_pro_after_singular_inner_content' ); ?>
				</div>
		  <?php do_action( 'nishiki_pro_after_singular_content' ); ?>
			</article>
		<?php do_action( 'nishiki_pro_after_singular_inner_container' ); ?>
		</div>
	  <?php do_action( 'nishiki_pro_after_singular_container' ); ?>
	</main>
<?php get_footer();
