<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_PRODUCT_REMOTE_CHECK' ) ) {
	class NISHIKI_PRO_WC_PRODUCT_REMOTE_CHECK {
		private $network_url = 'https://support.animagate.com/wp/';
		private $base_file = 'nishiki_pro_wc_reg_callback.php';

		// Remote Check.
		public function remote_check( $args ) {
			$args = array(
				'product'   => $args['product'],
				'extension' => $args['extension'],
				'site_url'  => rawurlencode( $args['site_url'] ),
				'key'       => $args['key'],
			);

			$target_url = $this->network_url . $this->base_file . '?' . http_build_query( $args );
			$request = wp_safe_remote_get(
				$target_url, array(
					'sslverify' => false,
				)
			);

			// echo $target_url;
			if ( isset( $request ) && ! empty( $request ) && ! is_wp_error( $request ) && $request['response']['code'] === 200 ) {
				return true;
			} else {
				return false;
			}

		}
	}
}
