<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_ADMIN' ) ) {
	class NISHIKI_PRO_WC_ADMIN {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 20 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_menu_page(
				'Nishiki Pro for WooCommerce',
				'Nishiki Pro for WooCommerce',
				'manage_options',
				'nishiki-pro-wc.php',
				array( $this, 'add_page' ),
				'dashicons-admin-plugins'
			);

		}

		/**
		 * ページ作成
		 */
		public function add_page() {
			?>
			<div class="wrap">
				<h1>Nishiki Pro for WooCommerce</h1>
				<hr>
				<p>このプラグインは、ワードプレスに EC サイトの仕組みを導入する WooCommerce プラグインと併用してください。</p>
				<p>注意：ワードプレス 公式ディレクトリ掲載の無料テーマ Nishiki には対応していません。<a class="button button-primary" href="https://support.animagate.com/product/wp-nishiki-pro/" target="_blank">Nishiki Pro テーマ</a> の導入をご検討ください。</p>
			</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_WC_ADMIN();
	}
}
