<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_ADMIN_REGISTRATION' ) ) {
	class NISHIKI_PRO_WC_ADMIN_REGISTRATION extends NISHIKI_PRO_WC_PRODUCT_REMOTE_CHECK {

	  private $page_name = 'nishiki_pro_wc';

	  /**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 20 );

			// フォーム追加.
			add_action( 'admin_init', array( $this, 'form_settings' ), 20 );

			// CSS 追加
			add_action( 'admin_head', array( $this, 'add_css' ), 20 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_submenu_page(
				'nishiki-pro-wc.php',
				'製品登録',
				'製品登録',
				'manage_options',
				'nishiki-pro-wc-registration.php',
				array( $this, 'add_page' )
			);
		}

	  //フォームの設定
	  public function form_settings() {

		  register_setting(
			  $this->page_name,
				$this->page_name,
			  array( $this, 'sanitize' )
		  );

	    add_settings_section(
	      $this->page_name,
		    __( '', 'nishiki-pro-wc' ),
		    array( $this, 'create_nonce_cb' ),
	      $this->page_name
	    );


	    add_settings_field(
		    'reg_key',
		    __( '登録キーを入力', 'nishiki-pro-wc' ),
		    array( $this, 'create_text_cb' ),
	      $this->page_name,
	      $this->page_name,
		    array(
			    'title' => '',
			    'label' => 'reg_key',
			    'page_name' => $this->page_name,
			    'description' => '',
		    )
	    );

	  }

	  /**
	   * 入力値のサニタイズ
	   *
	   * @param array $input Contains all settings fields as array keys
	   *
	   */
	  public function sanitize( $input ) {
		  $new_input = array();

	    if( isset( $input['reg_key'] ) ){
		    // データベースから既存のオプション値を取得
		    $remote_response = new NISHIKI_PRO_WC_PRODUCT_REMOTE_CHECK();
		    $product = 'nishiki';

		    $args = array(
			    'product'   => $product,
			    'extension' => 'pro_wc',
			    'site_url'  => get_option( 'home' ),
			    'key'       => $input['reg_key'],
		    );

		    $response = $remote_response->remote_check( $args );

	     // wp_die(var_dump($args));

	      if ( $response ) {
		    	$new_input['reg_key'] = sanitize_text_field( $input['reg_key'] );
	    	}

	      return $new_input;
      }
	  }

	  /**
	   * Nonce 作成
	   */
	  public function create_nonce_cb() {
		  $nonce = wp_create_nonce( 'nishiki_pro_wc_registration' );
		  echo '<input type="hidden" name="nishiki_pro_wc_registration" value="' . esc_attr( $nonce ) . '" />';
	  }

	  /**
	   * フォーム作成（テキスト）
	   */
	  public function create_text_cb( $args ) {
		  $this->options = get_option( $args['page_name'] );

		  $this->text( $args['title'], $args['label'], $args['page_name'], '' );

		  if ( ! empty( $args['description'] ) ) {
			  echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
		  }
	  }

	  /**
	   * テキストフォーム
	   */
	  public function text( $title, $label, $page_name, $placeholder = '' ) {
		  $options = get_option( $page_name );
		  $label_name = $page_name . '_' . $label;

		  if ( isset( $options[ $label ] ) ) {
			  $data = $options[ $label ];
			  $class = ' active';
		  } else {
			  $data = '';
			  $class = '';
		  }

		  if ( ! empty( $title ) ) {
			  echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
		  }
		  echo '<p class="dashicons-before dashicons-admin-network' . $class . '"><input placeholder="' . esc_attr( $placeholder ) . '" type="text" id="' . esc_attr( $label_name ) . '" name="' .  esc_attr( $page_name ) . '[' . esc_attr( $label ). ']" value="' . esc_attr( $data ) . '" /></p>';
	  }


	/**
	 * ページの内容
	 */
	public function add_page() {
		$this->options = get_option( $this->page_name );
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'このページを表示する権限がありません。' );
		}

		// Update Check
		$reg_key_data = get_option( 'nishiki_pro_wc' );
		$reg_key = isset( $reg_key_data['reg_key'] ) ? $reg_key_data['reg_key'] : '';

		?>
			<div class="wrap">
				<h1>製品登録</h1>
				<?php if( empty( $reg_key ) ){ ?>
				<?php } else { ?>
					<div class="notice notice-success">
						<p>
							本製品は製品登録されています。製品の継続的なサポートやアップデートのサービスを受けることができます。
						</p>
					</div>
				<?php } ?>
				<form method="post" action="options.php">
					<p id="siteurl"><a target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/">サポトピア</a> のプロフィールページで「サイトアドレス (URL)」<input tyle="text" value="<?php echo esc_url( get_site_url() ); ?>" onclick="copySiteUrl( this )" style="border:none; background:#fff; margin:0 0.2rem; padding:0.2rem 0.5rem;" readonly>を入力し、発行された登録キーを入力してください。</p>
					<?php
					settings_fields( $this->page_name );
					do_settings_sections( $this->page_name );
					submit_button();
					?>
				</form>
				<div style="border:1px solid #aaa; margin-bottom:1em; padding:1rem;border-radius: 4px;position: relative;margin-top: 2.5rem;">
					<h3 style="margin: 0;display: inline-block;position: absolute;top: -0.7rem;background: #f0f0f1;padding: 0 0.5rem;">※ 登録キーが認証されない場合は？</h3>
					<p>登録キーの発行ミスがないかどうか確認してください。「http」と「https」では別の URL として判別します。</p>
					<p>登録キーの入力ミス（貼り付けミス）がないかどうか確認してください。</p>
					<p>ローカル環境のウェブサイトは製品登録できません。必ずインターネット上に公開しているウェブサイトでお願いします。</p>
				</div>
				<h3>マニュアルを見る</h3>
				<p><a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-pro-wc-regist/">製品登録方法</a></p>
				<script>
					function copySiteUrl(e) {
						const checkContent = document.getElementById( 'site-url-copied' );
						if( !! checkContent ){
							checkContent.remove();
						}

						e.select();
						navigator.clipboard.writeText( e.value );

						const newContent = document.createElement( 'p' );

						newContent.classList.add( 'copied' );
						newContent.setAttribute( 'id', 'site-url-copied' );
						newContent.style.display = 'inline';
						newContent.style.backgroundColor = '#fefefe';
						newContent.style.padding = '0.2rem 0.5rem';

						const newText = document.createTextNode( 'URL をコピーしました' );

						newContent.appendChild( newText );

						const currentDiv = document.getElementById( 'siteurl' );
						currentDiv.appendChild( newContent );

						setTimeout( function() {
							newContent.remove();
						}, 2000 );							
					}
				</script>
			</div>
		<?php
	}

	  // CSS 追加
	  public function add_css() {
		  $output = <<< EOT
					.dashicons-before:before{
						color: #ccc;
						margin-right: 0.5rem;
						vertical-align: text-top;
					}
					.dashicons-before.active:before{
						color: #67cc00;
					}
					.dashicons-before.active input{
						background: #99e0aa;
					}
EOT;

		  echo '<style>' . esc_html( $output ) . '</style>';
	  }

	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_WC_ADMIN_REGISTRATION();
	}
}
