<?php
/*
Plugin Name: Nishiki Pro for WooCommerce
Plugin URI: https://support.animagate.com/product/wp-nishiki-pro-wc/
Description: WooCommerce でオンラインショップを作る方のために開発された Nishiki Pro テーマ専用プラグインです。
Version: 1.1.0
Requires at least: 6.1
Requires PHP: 7.2
Tested up to: 6.7
Author: Tetsuya Imamura[AnimaGate, Inc.]
Text Domain: nishiki-pro-wc
Author URI: http://support.animagate.com/
License: GPL2

Copyright 2022 Tetsuya Imamura[AnimaGate, Inc.]

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if( ! function_exists('nishiki_pro_wc_plugin_check') ){
	function nishiki_pro_wc_plugin_check() {
		// Init
		require_once ('library/init.php');

		/**
		 * Check if WooCommerce is activated
		 */
		if ( ! function_exists( 'is_woocommerce_activated' ) ) {
			function is_woocommerce_activated() {
				if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
			}
		}

		if( is_woocommerce_activated() ){

			// Customizer
			require_once ('library/customizer/init.php');

			// Template Redirect
			require_once ('library/template-redirect.php');

			// WooCommerce
			require_once ('library/woocommerce.php');

			// Admin
			require_once ('class/admin/class-admin.php');

			// About
			require_once ('class/admin/menu/about/class-about.php');

			// Auth
			require_once ('class/admin/auth/class-auth.php');

			// Registration
			require_once ('class/admin/menu/registration/class-registration.php');

			// Page Settings
			require_once ('class/admin/menu/page-optimize/class-page-optimize.php');

			// Update Check
			$reg_key_data = get_option( 'nishiki_pro_wc' );
			$reg_key = isset( $reg_key_data['reg_key'] ) ? $reg_key_data['reg_key'] : '';

			if( isset( $reg_key ) && ! empty( $reg_key ) ){
				require 'class/update/plugin-update-checker.php';
				$nishiki_pro_wc_update = Puc_v4_Factory::buildUpdateChecker(
					'https://support.animagate.com/wp/packages/plugins/nishiki-pro-wc/nishiki-pro-wc.json',
					__FILE__,
					'Nishiki Pro for WooCommerce'
				);
			}
		}

	}

	add_action( 'plugins_loaded', 'nishiki_pro_wc_plugin_check' );
}

