<?php
if( ! function_exists( 'nishiki_pro_wc_init_customizer_product' ) ) {
	add_action( "customize_register", "nishiki_pro_wc_init_customizer_product" );
	function nishiki_pro_wc_init_customizer_product( $wp_customize ) {

		// Section
		$wp_customize->add_section('section_nishiki_pro_wc_product',array(
			'title'     =>  __( 'Product Detail', 'nishiki-pro-wc' ),
			'priority'  =>  10,
			'panel'     =>  'section_nishiki_pro_wc',
		));

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_product_sidebar', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_product_sidebar',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">サイドバー</p><p>デフォルトでは「投稿ページ」のサイドバーの設定が適用されます。お好みで変更してください。</p>',
					'section'       =>  'section_nishiki_pro_wc_product',
					'settings'      =>  'setting_nishiki_pro_wc_header_product_sidebar',
				)
			)
		);

		// サイドバーのデフォルト設定：未設定の場合は Nishiki Pro に合わせる
		$product_sidebar_column = 'none';
		$product_sidebar_width = '300';
		$product_sidebar_margin = '50';

		$current_post_sidebar_column_setting = get_theme_mod( 'setting_post_column' );
		$current_post_sidebar_width_setting = get_theme_mod( 'setting_post_width' );
		$current_post_sidebar_margin_setting = get_theme_mod( 'setting_post_margin' );

		if( $current_post_sidebar_column_setting ){
			$product_sidebar_column = $current_post_sidebar_column_setting;
		}

		if( $current_post_sidebar_width_setting ){
			$product_sidebar_width = $current_post_sidebar_width_setting;
		}

		if( $current_post_sidebar_margin_setting ){
			$product_sidebar_margin = $current_post_sidebar_margin_setting;
		}

		// Column
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_product_sidebar_column',array(
			'default'           =>  $product_sidebar_column,
			'sanitize_callback' =>  'nishiki_pro_sanitize_choices',
		));

		$wp_customize->add_control( 'ctrl_nishiki_pro_wc_product_sidebar_column',array(
			'label'             =>  __( 'Placement', 'nishiki-pro' ),
			'section'           =>  'section_nishiki_pro_wc_product',
			'settings'          =>  'setting_nishiki_pro_wc_product_sidebar_column',
			'type'              =>  'select',
			'choices'           =>  array(
				'left'      =>  __( 'Left', 'nishiki-pro' ),
				'right'     =>  __( 'Right', 'nishiki-pro' ),
				'bottom'    =>  __( 'Bottom', 'nishiki-pro' ),
				'none'      =>  __( 'None', 'nishiki-pro' ),
			),
		));

		// Sidebar Width.
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_product_sidebar_width' , array(
			'default'     => $product_sidebar_width,
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		) );

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Range(
				$wp_customize,
				'ctrl_nishiki_pro_wc_product_sidebar_width',
				array(
					'label'     => __( 'Width(px)', 'nishiki-pro' ),
					'min'       => 0,
					'max'       => 1000,
					'step'      => 10,
					'section'   => 'section_nishiki_pro_wc_product',
					'settings'  => 'setting_nishiki_pro_wc_product_sidebar_width',
				)
			)
		);

		// Sidebar Margin.
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_product_sidebar_margin' , array(
			'default'     => $product_sidebar_margin,
			'transport'   => '',
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		) );

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Range(
				$wp_customize,
				'ctrl_nishiki_pro_wc_product_sidebar_margin',
				array(
					'label'     => __( 'Margin(px)', 'nishiki-pro' ),
					'min'       => 0,
					'max'       => 50,
					'step'      => 1,
					'section'   => 'section_nishiki_pro_wc_product',
					'settings'  => 'setting_nishiki_pro_wc_product_sidebar_margin',
				)
			)
		);

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_product_eye_catch', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_product_eye_catch',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">アイキャッチ</p>',
					'section'       =>  'section_nishiki_pro_wc_product',
					'settings'      =>  'setting_nishiki_pro_wc_header_product_eye_catch',
				)
			)
		);

		// Display Eye Catch
		$wp_customize->add_setting('setting_nishiki_pro_wc_product_eye_catch',array(
			'default' => false,
			'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
		));

		$wp_customize->add_control('ctrl_nishiki_pro_wc_product_eye_catch',array(
			'label'       =>  __( 'Display', 'nishiki-pro' ),
			'type'        =>  'checkbox',
			'section'     =>  'section_nishiki_pro_wc_product',
			'settings'    =>  'setting_nishiki_pro_wc_product_eye_catch',
		));

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_product_related_posts_display', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_product_related_posts_display',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">関連製品</p>',
					'section'       =>  'section_nishiki_pro_wc_product',
					'settings'      =>  'setting_nishiki_pro_wc_header_product_related_posts_display',
				)
			)
		);

		// Related products Display
		$wp_customize->add_setting('setting_nishiki_pro_wc_product_related_posts_display',array(
			'default' => false,
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control('ctrl_nishiki_pro_wc_product_related_posts_display',array(
			'label'       =>  __( 'Display', 'nishiki-pro' ),
			'type'        =>  'checkbox',
			'section'     =>  'section_nishiki_pro_wc_product',
			'settings'    =>  'setting_nishiki_pro_wc_product_related_posts_display',
		));

		// Related products Display Price
		$wp_customize->add_setting(
			'setting_nishiki_pro_wc_product_related_posts_price_display',
			array(
				'default' => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control( 'ctrl_nishiki_pro_wc_product_related_posts_price_display', array(
			'label'       =>  __( '価格を表示する', 'nishiki-pro' ),
			'type'        =>  'checkbox',
			'section'     =>  'section_nishiki_pro_wc_product',
			'settings'    =>  'setting_nishiki_pro_wc_product_related_posts_price_display',
		));

		// Related products Text
		$wp_customize->add_setting('setting_nishiki_pro_wc_product_related_posts_text',array(
			'default' => __( 'Related Products', 'nishiki-pro-wc' ),
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control('ctrl_nishiki_pro_wc_product_related_posts_text',array(
			'label'       =>  __( 'Text Label', 'nishiki-pro' ),
			'type'        =>  'text',
			'section'     =>  'section_nishiki_pro_wc_product',
			'settings'    =>  'setting_nishiki_pro_wc_product_related_posts_text',
		));

		// Related products Columns
		$wp_customize->add_setting('setting_nishiki_pro_wc_product_related_posts_columns',array(
			'default'           =>  3,
			'sanitize_callback' =>  'nishiki_pro_sanitize_choices_columns',
		));

		$wp_customize->add_control('ctrl_nishiki_pro_wc_product_related_posts_columns',array(
			'label'             =>  __( 'Numbers', 'nishiki-pro' ),
			'section'           =>  'section_nishiki_pro_wc_product',
			'settings'          =>  'setting_nishiki_pro_wc_product_related_products_columns',
			'type'              =>  'select',
			'choices'           =>  array(
				'1' =>  __( '1 Column', 'nishiki-pro' ),
				'2' =>  __( '2 Columns', 'nishiki-pro' ),
				'3' =>  __( '3 Columns', 'nishiki-pro' ),
			),
		));

		// Related products Number
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_product_related_posts_number', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_number',
			'default' => 3,
		));

		$wp_customize->add_control( 'ctrl_nishiki_pro_wc_product_related_posts_number', array(
			'label'             => __( 'Related Products Number', 'nishiki-pro-wc' ),
			'section'           => 'section_nishiki_pro_wc_product',
			'settings'          => 'setting_nishiki_pro_wc_product_related_posts_number',
			'type'              => 'number',
		));
	}
}
