<?php
if ( ! class_exists( 'NISHIKI_PRO_WC_TEMPLATE_REDIRECT' ) ) {
	class NISHIKI_PRO_WC_TEMPLATE_REDIRECT {
		private $plugin_dir_name = 'nishiki-pro-wc';

		/**
		 * constructor.
		 *
		 */
		public function __construct() {
			add_filter( 'template_include', array( $this, 'change_template' ), 20 );
			add_filter( 'woocommerce_locate_template',  array( $this, 'change_woo_template' ), 20, 3 );
			add_filter( 'comments_template', array( $this, 'change_single_review_template' ), 20, 3 );
		}

		function change_template( $template ){
			if ( ! class_exists( 'woocommerce' ) ) {
				return false;
			}

			$template_dir = 'woocommerce';
			$plugin_path = WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . $template_dir . '/';

			if( is_shop() ){
				$template = $plugin_path . 'archive-product.php';
			}

			if( is_product() ){
				$template = $plugin_path . 'single-product.php';

				if( is_page_template( 'templates/sidebar-right.php' ) ){
					$template =WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . 'templates/sidebar-right.php';
				}

				if( is_page_template( 'templates/sidebar-left.php' ) ){
					$template =WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . 'templates/sidebar-left.php';
				}

				if( is_page_template( 'templates/sidebar-none.php' ) ){
					$template =WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . 'templates/sidebar-none.php';
				}
			}

			if( is_cart() ){
				//$template = WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . 'page-cart.php';
			}

			if( is_checkout() ){
				//$template = WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . 'page-checkout.php';
			}

			return $template;
		}

		function change_woo_template( $template, $template_name, $template_path ) {
			global $woocommerce;
			$_template = $template;
			if ( ! $template_path ){
				$template_path = $woocommerce->template_url;
			}

			$template_dir = 'woocommerce';
			$plugin_path = WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . $template_dir . '/';

			// Look within passed path within the theme - this is priority
			$template = locate_template(
				array(
					$template_path . $template_name,
					$template_name
				)
			);

			if( ! $template && file_exists( $plugin_path . $template_name ) ){
				$template = $plugin_path . $template_name;
			}

			if ( ! $template ) {
				$template = $_template;
			}

			return $template;
		}


		function change_single_review_template( $template ) {
			if( ! is_product() ){
				return false;
			}
			$template_dir = 'woocommerce';
			$plugin_path = WP_PLUGIN_DIR . '/' . $this->plugin_dir_name . '/' . $template_dir . '/';

			return $plugin_path . 'single-product-reviews.php';
		}

	}

	$output = new NISHIKI_PRO_WC_TEMPLATE_REDIRECT();
}
