<?php
if( ! function_exists( 'nishiki_pro_wc_init_customizer_header' ) ) {
	add_action( "customize_register", "nishiki_pro_wc_init_customizer_header" );
	function nishiki_pro_wc_init_customizer_header( $wp_customize ) {

		// Section
		$wp_customize->add_section('section_nishiki_pro_wc_header',array(
			'title'     =>  __( 'Header', 'nishiki-pro-wc' ),
			'priority'  =>  10,
			'panel'     =>  'section_nishiki_pro_wc',
		));

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_cart', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_cart',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">カートアイコン</p>',
					'section'       =>  'section_nishiki_pro_wc_header',
					'settings'      =>  'setting_nishiki_pro_wc_header_cart',
				)
			)
		);

		// Display Cart Icon
		$wp_customize->add_setting('setting_nishiki_pro_wc_header_display_cart_icon',array(
			'default' => true,
			'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
		));

		$wp_customize->add_control('ctrl_nishiki_pro_wc_header_display_cart_icon',array(
			'label'         =>  __( 'Display', 'nishiki-pro' ),
			'type'          =>  'checkbox',
			'section'       =>  'section_nishiki_pro_wc_header',
			'settings'      =>  'setting_nishiki_pro_wc_header_display_cart_icon',
		));

		// Heading
		$wp_customize->add_setting( 'setting_nishiki_pro_wc_header_cart_badge', array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_Pro_WC_Customize_Content(
				$wp_customize, 'ctrl_nishiki_pro_wc_header_cart_badge',
				array(
					'label'         =>  '<p class="nishiki-pro-wc-customizer-heading">カートバッジ</p>',
					'section'       =>  'section_nishiki_pro_wc_header',
					'settings'      =>  'setting_nishiki_pro_wc_header_cart_badge',
				)
			)
		);

		// Display Cart Badge
		$wp_customize->add_setting('setting_nishiki_pro_wc_header_display_cart_badge',array(
			'default' => true,
			'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
		));

		$wp_customize->add_control('ctrl_nishiki_pro_wc_header_display_cart_badge',array(
			'label'         =>  __( 'Display', 'nishiki-pro' ),
			'type'          =>  'checkbox',
			'section'       =>  'section_nishiki_pro_wc_header',
			'settings'      =>  'setting_nishiki_pro_wc_header_display_cart_badge',
		));

		// Cart Badge Text Color
		$wp_customize->add_setting('setting_nishiki_pro_wc_header_cart_badge_text_color',array(
			'default'           =>  '#ffffff',
			'sanitize_callback' =>  'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_nishiki_pro_wc_general_cart_badge_text_color',
				array(
					'label'       =>  __( 'Text Color', 'nishiki-pro-wc' ),
					'section'     =>  'section_nishiki_pro_wc_header',
					'settings'    =>  'setting_nishiki_pro_wc_header_cart_badge_text_color',
				)
			)
		);

		// Cart Badge Text Background Color
		$wp_customize->add_setting('setting_nishiki_pro_wc_header_cart_badge_text_background_color',array(
			'default'           =>  '#f32467',
			'sanitize_callback' =>  'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_nishiki_pro_wc_general_cart_badge_text_background_color',
				array(
					'label'       =>  __( 'Background Color', 'nishiki-pro-wc' ),
					'section'     =>  'section_nishiki_pro_wc_header',
					'settings'    =>  'setting_nishiki_pro_wc_header_cart_badge_text_background_color',
				)
			)
		);
	}
}
