<?php
// Add Costomizer CSS
if ( ! function_exists( 'nishiki_pro_wc_customizer_css' ) ) {
	function nishiki_pro_wc_customizer_css(){
		$output = '';
        
        // text color
        $header_text_color = ( ! get_header_textcolor() ) ? '#000000' : '#' . esc_html( get_theme_mod( 'header_textcolor', '333333' ) );
        
		// background color
		$header_background_color = esc_html( get_theme_mod( 'setting_header_background_color', '#ffffff' ) );
        
        
        // Header Overlay
        $header_overlay = apply_filters( 'nishiki_pro_wc_header_overlay', get_theme_mod( 'setting_header_overlay', false ) );
        
        if( ( function_exists( 'nishiki_pro_is_static_front_page' ) && nishiki_pro_is_static_front_page() )  || is_singular() ){
            $header_overlay_post = get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_header_overlay_' . get_post_type(), true );
            
            if( $header_overlay_post !== '' ){
                $header_overlay = $header_overlay_post;
            }
        }
        
        if( $header_overlay ){
            // text color
            $header_text_color = esc_html( apply_filters( 'nishiki_pro_header_overlay_text_color', get_theme_mod( 'setting_header_overlay_text_color', '#333333' ) ) );
            
            // Opacity
            $header_background_opacity = absint( apply_filters( 'nishiki_pro_header_overlay_background_color_opacity', get_theme_mod( 'setting_header_overlay_background_color_opacity', 30 ) ) );
        } else {
            // text color
            $header_text_color = ( ! get_header_textcolor() ) ? '#000000' : esc_html( apply_filters( 'nishiki_pro_header_text_color', '#' . get_theme_mod( 'header_textcolor', '333333' ) ) );
            
            // Opacity
            $header_background_opacity = 100;
        }
		
		$output .= "
		#masthead #cart-customlocation{color: currentColor;}
		"
		;

		/**
		 * General
		 */

		// Order Button Color
		$order_button_text_color = get_theme_mod( 'setting_nishiki_pro_wc_general_order_button_text_color', '#ffffff' );
		$order_button_text_hover_color = get_theme_mod( 'setting_nishiki_pro_wc_general_order_button_text_hover_color', '#ffffff' );
		$order_button_color = get_theme_mod( 'setting_nishiki_pro_wc_general_order_button_color', '#5697da' );
		$order_button_hover_color = get_theme_mod( 'setting_nishiki_pro_wc_general_order_button_hover_color', '#4a78b1' );

		$output .= ":root{
			--nishiki-pro-wc-order-button-text-color:{$order_button_text_color};
			--nishiki-pro-wc-order-button-text-hover-color:{$order_button_text_hover_color};
			--nishiki-pro-wc-order-button-color:{$order_button_color};
			--nishiki-pro-wc-order-button-hover-color:{$order_button_hover_color};
		}";

		// Add To Cart Button Text Color
		$add_to_cart_button_text_color = get_theme_mod( 'setting_nishiki_pro_wc_general_add_to_cart_button_text_color', '#ffffff' );
		$output .= "
	.woocommerce-page .add-to-cart-link-wrapper .button,
	.woocommerce-page .single_add_to_cart_button,
	div[class^=\"wp-block-woocommerce-\"] .add-to-cart-link-wrapper .button,
	div[class^=\"wp-block-woocommerce-\"] .single_add_to_cart_button{color:{$add_to_cart_button_text_color};}
	";

		// Add To Cart Button Text Hover Color
		$add_to_cart_button_text_hover_color = get_theme_mod( 'setting_nishiki_pro_wc_general_add_to_cart_button_text_hover_color', '#ffffff' );
		$output .= "
	.woocommerce-page .add-to-cart-link-wrapper .button:hover,
	.woocommerce-page .single_add_to_cart_button:hover,
	div[class^=\"wp-block-woocommerce-\"] .add-to-cart-link-wrapper .button:hover,
	div[class^=\"wp-block-woocommerce-\"] .single_add_to_cart_button:hover{color:{$add_to_cart_button_text_hover_color};}
	";

		// Add To Cart Button Color
		$add_to_cart_button_color = get_theme_mod( 'setting_nishiki_pro_wc_general_add_to_cart_button_color', '#9064b5' );
		$output .= "
	.woocommerce-page .add-to-cart-link-wrapper .button,
	.woocommerce-page .single_add_to_cart_button,
	div[class^=\"wp-block-woocommerce-\"] .add-to-cart-link-wrapper .button,
	div[class^=\"wp-block-woocommerce-\"] .single_add_to_cart_button{background-color:{$add_to_cart_button_color};}
	";

		// Add To Cart Button Hover Color
		$add_to_cart_button_color_hover = get_theme_mod( 'setting_nishiki_pro_wc_general_add_to_cart_button_color_hover', '#724b96' );
		$output .= "
	.woocommerce-page .add-to-cart-link-wrapper .button:hover,
	.woocommerce-page .single_add_to_cart_button:hover,
	div[class^=\"wp-block-woocommerce-\"] .add-to-cart-link-wrapper .button:hover,
	div[class^=\"wp-block-woocommerce-\"] .single_add_to_cart_button:hover{background-color:{$add_to_cart_button_color_hover};}
	";

		// Detail Button Text Color
		$detail_button_text_color = get_theme_mod( 'setting_nishiki_pro_wc_general_detail_button_text_color', '#ffffff' );
		$output .= "
	.woocommerce-page .detail span,
	div[class^=\"wp-block-woocommerce-\"] .detail span{color:{$detail_button_text_color};}
	";

		// Detail Button Color
		$detail_button_color = get_theme_mod( 'setting_nishiki_pro_wc_general_detail_button_color', '#eca912' );
		$output .= "
	.woocommerce-page .detail span,
	div[class^=\"wp-block-woocommerce-\"] .detail span{background-color:{$detail_button_color};}
	";

		// ON SALE Text Color
		$on_sale_text_color = get_theme_mod( 'setting_nishiki_pro_wc_general_on_sale_text_color', '#ffffff' );
		$output .= "
	.woocommerce-page .onsale,
	div[class^=\"wp-block-woocommerce-\"] .onsale{color:{$on_sale_text_color};}
	";

		// ON SALE Text Background Color
		$on_sale_text_background_color = get_theme_mod( 'setting_nishiki_pro_wc_general_on_sale_text_background_color', '#e80000' );
		$output .= "
	.woocommerce-page .onsale,
	div[class^=\"wp-block-woocommerce-\"] .onsale{background-color:{$on_sale_text_background_color};}
	";

		// Price Text Color
		$price_text_color = get_theme_mod( 'setting_nishiki_pro_wc_general_price_text_color', '#444444' );
		$output .= "
	.woocommerce-page .price,
	div[class^=\"wp-block-woocommerce-\"] .price{color:{$price_text_color};}
	";

		// Price Discount Text Color
		$price_discount_text_color = get_theme_mod( 'setting_nishiki_pro_wc_general_price_discount_text_color', '#ff4d8c' );
		$output .= "
	.woocommerce-page ins,
	.widget.woocommerce ins,
	div[class^=\"wp-block-woocommerce-\"] ins{color:{$price_discount_text_color};}
	";

		// Rating Star Color
		$rating_star_color = get_theme_mod( 'setting_nishiki_pro_wc_general_rating_star_color', '#96588a' );
		$output .= "
	.star-rating span:before,
	p.stars a:after,
	p.stars a:hover:after,
	p.stars:hover a:before,
	p.stars.selected a:not(.active)::before,
	p.stars.selected a.active::before
	{color:{$rating_star_color};}
	";

		/**
		 * Header
		 */

		// Cart Badge Text Color
		$cart_badge_text_color = get_theme_mod( 'setting_nishiki_pro_wc_header_cart_badge_text_color', '#ffffff' );
		$output .= "
	#cart-customlocation .badge{color:{$cart_badge_text_color};}
	";

		// Cart Badge Background Color
		$cart_badge_text_background_color = get_theme_mod( 'setting_nishiki_pro_wc_header_cart_badge_text_background_color', '#f32467' );
		$output .= "
	#cart-customlocation .badge{background-color:{$cart_badge_text_background_color};}
	";


		/**
		 * Product
		 */

		$display_page_sidebar = true;

		/**
		 * Cart,Checkout,my-account
		 * 1 Column
		 */
		if( is_cart() || is_checkout() || is_account_page() || is_wc_endpoint_url() ){
			$display_page_sidebar = false;

			$output .= "@media only screen and (min-width:769px) {";
			$output .= ".page #main .column { padding:0; }";
			$output .= "}";
		}

		if( $display_page_sidebar ){
			// カスタマイザーで未設定の場合は Nishiki Pro に合わせる
			$product_sidebar_column = 'none';
			$product_sidebar_width = '300';
			$product_sidebar_margin = '50';

			$current_post_sidebar_width = absint( get_theme_mod( 'setting_post_width' ) );
			$current_post_sidebar_column = esc_html( get_theme_mod( 'setting_post_column' ) );
			$current_post_sidebar_margin = absint( get_theme_mod( 'setting_post_margin' ) );

			$current_product_sidebar_width = absint( get_theme_mod( 'setting_nishiki_pro_wc_product_sidebar_width' ) );
			$current_product_sidebar_column = esc_html( get_theme_mod( 'setting_nishiki_pro_wc_product_sidebar_column' ) );
			$current_product_sidebar_margin = absint( get_theme_mod( 'setting_nishiki_pro_wc_product_sidebar_margin' ) );

			if( $current_product_sidebar_width ){
				$product_sidebar_width = $current_product_sidebar_width;
			} elseif( $current_post_sidebar_width ){
				$product_sidebar_width = $current_post_sidebar_width;
			}

			if( $current_product_sidebar_column ){
				$product_sidebar_column = $current_product_sidebar_column;
			} elseif( $current_post_sidebar_column ){
				$product_sidebar_column = $current_post_sidebar_column;
			}

			if( $current_product_sidebar_margin ){
				$product_sidebar_margin = $current_product_sidebar_margin;
			} elseif( $current_post_sidebar_margin ){
				$product_sidebar_margin = $current_post_sidebar_margin;
			}

			// サイドバーを表示している場合
			if ( ! is_page_template( 'templates/sidebar-none.php' ) ) {
				if( is_page_template( 'templates/sidebar-right.php' ) ){
					$output .= "@media only screen and (min-width:769px) {";
//					$output .= ".product-template-sidebar-right #main .column { padding-right: {$product_sidebar_margin}px;}";
					$output .= ".product-template-sidebar-right aside.sidebars { width:{$product_sidebar_width}px; margin-left:{$product_sidebar_margin}px;}";
					$output .= "}";
				} elseif( is_page_template( 'templates/sidebar-left.php' ) ) {
					$output .= "@media only screen and (min-width:769px) {";
//					$output .= ".product-template-sidebar-left #main .column { padding-left: {$product_sidebar_margin}px;}";
					$output .= ".product-template-sidebar-left aside.sidebars { width:{$product_sidebar_width}px; margin-right:{$product_sidebar_margin}px;}";
					$output .= "}";
				} elseif( is_page_template( 'templates/sidebar-bottom.php' ) || $product_sidebar_column == 'bottom' ) {
					$output .= ".product-template-sidebar-bottom aside {width:100%;}";
					$output .= ".single-product #main .column { padding:0; }";
					$output .= ".single-product aside.sidebars { margin:auto }";
				} elseif( $product_sidebar_column !== 'none' ){
					$output .= '@media only screen and (min-width:769px) {';
					$output .= ".single-product aside.sidebars { width:{$product_sidebar_width}px; }";

					if( 'left' === $product_sidebar_column ) {
						$output .= ".single-product .sidebar-left aside.sidebars { margin-right:{$product_sidebar_margin}px; }";
					} elseif( 'right' === $product_sidebar_column ) {
						$output .= ".single-product .sidebar-right aside.sidebars { margin-left:{$product_sidebar_margin}px; }";
					}

					$output .= '}';
				}
			}
		}

		/**
		 * Product Archive
		 */

		// Archive Contents Width
		if( is_shop() ){
			$product_archive_contents_width = absint( get_post_meta( wc_get_page_id( 'shop' ),'_nishiki_pro_meta_box_content_width_page',true ) );

			if( $product_archive_contents_width !== 0 ){
				$output .= "
				.archive.woocommerce-page #main .container.column{max-width:{$product_archive_contents_width}px;}
			";
			}
		}

		// Sidebar Width
		$product_archive_sidebar_width = absint( get_theme_mod( 'setting_nishiki_pro_wc_product_archive_sidebar_width','300' ) );
		$product_archive_column = esc_html( get_theme_mod( 'setting_archive_column', 'none' ) );
		$product_archive_sidebar_margin = $product_archive_sidebar_width + absint( get_theme_mod( 'setting_nishiki_pro_wc_product_archive_sidebar_margin', '20' ) );
		if( $product_archive_column !== 'none' ){
			$output .= ".archive.woocommerce-page #main .column{ padding-{$product_archive_column}: {$product_archive_sidebar_margin}px;}";
			$output .= "@media only screen and (max-width:768px) {.archive.woocommerce-page #main .container.column{padding:0;}}";
			$output .= ".archive.woocommerce-page aside.sidebar { width:{$product_archive_sidebar_width}px;margin-{$product_archive_column}:-{$product_archive_sidebar_margin}px;}";
		}

		// Output
		if( $output === '' ) return false;
		$str = array( "\t", "\r\n", "\r", "\n" );
		$output = str_replace( $str, '', $output );

		return $output;
	}
}
