<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header(); ?>
<main id="main" role="main" <?php post_class(); ?>>
	<?php do_action( 'nishiki_pro_before_singular_header', $post ); ?>
	<?php
	// タイトルを非表示にしてるかどうかチェック
	if ( empty( get_post_meta( get_the_ID(), '_nishiki_pro_meta_box_title_disable_' . get_post_type(), true ) ) ) {
	?>
	<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
		<div class="page-header-inner container">
		<?php do_action( 'nishiki_pro_before_singular_title' ); ?>
		<?php the_title( '<h1>', '</h1>' ); ?>
		<?php do_action( 'nishiki_pro_after_singular_title' ); ?>
		</div>
	</header>
	<?php } ?>
	<?php do_action( 'nishiki_pro_after_singular_header' ); ?>
	<?php
	/**
	 * woocommerce_before_main_content hook.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 */
	//do_action( 'woocommerce_before_main_content' );
	?>

	<?php do_action( 'nishiki_pro_before_singular_container' ); ?>
	<div class="container column">
	  <?php do_action( 'nishiki_pro_before_singular_inner_container' ); ?>
		<article class="entry woocommerce-single-product">
			<?php do_action( 'nishiki_pro_before_singular_content' ); ?>
			<div class="entry-content">
				<?php do_action( 'nishiki_pro_before_singular_inner_content' ); ?>
				<?php while ( have_posts() ) : the_post(); ?>
				  <?php wc_get_template_part( 'content', 'single-product' ); ?>
			  <?php endwhile; // end of the loop. ?>
				<?php do_action( 'nishiki_pro_after_singular_inner_content' ); ?>
			</div>
			<?php do_action( 'nishiki_pro_after_singular_content' ); ?>
		</article>
	  <?php do_action( 'nishiki_pro_after_singular_inner_container' ); ?>
		<?php
		$current_product_sidebar_column = get_theme_mod( 'setting_nishiki_pro_wc_product_sidebar_column' );
		$current_post_sidebar_column = get_theme_mod( 'setting_post_column' );

		if( $current_product_sidebar_column ){
			$product_sidebar_column = $current_product_sidebar_column;
		} elseif( $current_post_sidebar_column ){
			$product_sidebar_column = $current_post_sidebar_column;
		} else {
			$product_sidebar_column = 'none';
		}
		
	  if( $product_sidebar_column !== 'none' ){
		  get_sidebar();
	  }
	  ?>
	</div>
	<?php do_action( 'nishiki_pro_after_singular_container' ); ?>
</main>
		<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		if( is_product() ){
			do_action( 'woocommerce_after_main_content' );
		}

		/**
		 * woocommerce_sidebar hook.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		//do_action( 'woocommerce_sidebar' );
	?>
<?php get_footer();

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
