<?php
namespace nishiki\pro\spdb\blockPattern;

use nishiki\pro\spdb\init\Define;

class Register{
	/**
	 * Constructor
	 */
	public function __construct() {
		// パターン追加
		add_action( 'after_setup_theme', array( $this, 'add_block_patterns' ), 10 );
	}

	/**
	 * パターン追加
	 */
	public function add_block_patterns() {

		// APIでデータ取得
		$request = self::request();
		$terms_array = [];

		if( ! $request ){
			return false;
		}

		// カテゴリー追加
		foreach( $request['all-terms']->category as $terms ){
			$terms_array[$terms->term_id] = array(
				'id' => $terms->term_id,
				'name' => $terms->name,
				'slug' => $terms->slug
			);

			register_block_pattern_category(
				Define::value( 'plugin_text_domain' ) . '-' . $terms->slug,
				array( 'label' => __( 'Nishiki Pro - ' . $terms->name, Define::value( 'plugin_text_domain' ) ) )
			);
		}

		// パターン追加
		foreach( $request['posts'] as $data ){
			$id = $data->id;
			$title = $data->title->rendered;
			$raw_content = $data->animagate_wp_block_patterns->content->raw;
			$categories = $data->categories;
			$block_pattern_categories_array = [];

			// 投稿に所属しているカテゴリーの配列を作成する
			foreach( $categories as $category_id ){
				if( in_array( $category_id, array_column( $terms_array, 'id') ) ){
					$block_pattern_categories_array[] = Define::value( 'plugin_text_domain' ) . '-' . $terms_array[$category_id]['slug'];
				}
			}

			// パターンの登録
			register_block_pattern(
				'nishiki-pro-spdb-pattern/' . $id,
				array(
					'title'       => __( $title, Define::value( 'plugin_text_domain' ) ),
					'categories'  => $block_pattern_categories_array,
					'description' => _x( $title, 'Block pattern description', Define::value( 'plugin_text_domain' ) ),
					'content'     => $raw_content,
				)
			);
		}

	}

	public function request(){
		$expire_time = DAY_IN_SECONDS / 2; // DAY_IN_SECONDS:1日 | HOUR_IN_SECONDS:60分 | MINUTE_IN_SECONDS:60秒
		$key = Define::value( 'plugin_func_name' ) . '-block-pattern';

		//$post_url = 'https://patterns.localhost/wp-json/wp/v2/posts?per_page=100';
		//$term_url = 'https://patterns.localhost/wp-json/wp/v2/all-terms';

		$post_url = 'https://demo.animagate.com/patterns/wp-json/wp/v2/posts?per_page=100';
		$term_url = 'https://demo.animagate.com/patterns/wp-json/wp/v2/all-terms';

		//delete_transient( $key );
		$data = get_transient( $key );

		if( false === $data ) {
			$data = [];

			$post_remote = wp_remote_get(
				$post_url,
				array(
					'timeout' => 10,
					'sslverify' => false,
					'headers' => array(
						'Accept' => 'application/json'
					)
				)
			);

			$term_remote = wp_remote_get(
				$term_url,
				array(
					'timeout' => 10,
					'sslverify' => false,
					'headers' => array(
						'Accept' => 'application/json'
					)
				)
			);

			if(
				is_wp_error( $post_remote )
				|| 200 !== wp_remote_retrieve_response_code( $post_remote )
				|| empty( wp_remote_retrieve_body( $post_remote ) )
			) {
				return false;
			}

			if(
				is_wp_error( $term_remote )
				|| 200 !== wp_remote_retrieve_response_code( $term_remote )
				|| empty( wp_remote_retrieve_body( $term_remote ) )
			) {
				return false;
			}

			$data['posts'] = $post_remote;
			$data['all-terms'] = $term_remote;

			set_transient( $key, $data, $expire_time );
		}

		$data['posts'] = json_decode( wp_remote_retrieve_body( $data['posts'] ) );
		$data['all-terms'] = json_decode( wp_remote_retrieve_body( $data['all-terms'] ) );

		return $data;
	}
}

use nishiki\pro\spdb\blockPattern;
new Register();
