<?php
if ( ! class_exists( 'NISHIKI_PRO_SPDB_EASY_SETUP_ADMIN' ) ) {
	/**
	 * 管理画面（かんたん設定)
	 */
	class NISHIKI_PRO_SPDB_EASY_SETUP_ADMIN {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 100 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_submenu_page(
				'nishiki-pro-general.php',
				'デモデータ インポート[SPDB]',
				'デモデータ インポート[SPDB]',
				'manage_options',
				'nishiki-pro-speed-builder-easy-setup.php',
				array( $this, 'add_page' )
			);
		}

		/**
		 * オプションページの内容
		 */
		public function add_page() {
			$current_theme = wp_get_theme();

			if ( 'nishiki-pro' === $current_theme->template ) {
				echo '<div id="root"></div>';
			}
		}

	}

	new NISHIKI_PRO_SPDB_EASY_SETUP_ADMIN();
}
