<?php
require_once 'demo01.php';
require_once 'demo02.php';

if ( ! class_exists( 'NISHIKI_PRO_SPDB_REST_API' ) ) {
	/**
	 * Rest API 設定
	 */
	class NISHIKI_PRO_SPDB_REST_API {
		/**
		 * 初期設定
		 */
		public function __construct() {
			add_action( 'rest_api_init', array( $this, 'create_endpoint' ) );
		}

		/**
		 * エンドポイント作成
		 *
		 * @return void
		 */
		public function create_endpoint() {
			register_rest_route(
				'customizer/v1',
				'/settings',
				array(
					array(
						'methods'             => 'GET',
						'callback'            => array( $this, 'callback' ),
						'permission_callback' => array( $this, 'rest_permission' ),
						// 'permission_callback' => function() { return current_user_can( 'edit_others_posts' ); }
					),
					array(
						'methods'             => 'PUT',
						'callback'            => array( $this, 'update_callback' ),
						'permission_callback' => array( $this, 'rest_permission' ),
					),
				)
			);
		}

		/**
		 * コールバック（初期設定を読み込んでいる）
		 *
		 * @return object
		 */
		public function callback() {

			// TopPage
			$data['topPage'] = get_option( 'show_on_front' );

			// Option
			$toc_array = array(
				'id'      => 'toc',
				'name'    => '目次',
				'checked' => get_theme_mod( 'setting_nishiki_pro_toc_display', true ),
			);

			$scroll_page_top_array = array(
				'id'      => 'pageTop',
				'name'    => 'ページ上部に戻るボタン',
				'checked' => get_theme_mod( 'setting_nishiki_pro_footer_scroll_page_top_button_enable', false ),
			);

			// カラー01
			$color_01_01 = get_theme_mod( 'setting_header_background_color' );
			$color_01_02 = '#' . get_theme_mod( 'header_textcolor', '#ffffff' );
			
			// カラー02
			$color_02_01 = get_theme_mod( 'setting_site_accent_color_01' );
			$color_02_02 = get_theme_mod( 'setting_site_accent_color_02' );
			
			// カラー03
			$color_03_01 = get_theme_mod( 'setting_site_main_color_01' );
			$color_03_02 = get_theme_mod( 'setting_site_main_color_02' );
			
			// カラー04
			$color_04_01 = get_theme_mod( 'setting_site_main_color' );
			$color_04_02 = get_theme_mod( 'setting_site_sub_color' );

			// カラー05
			$color_05_01 = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_color' );
			$color_05_02 = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_color' );

			// Color List
			$color_list = array(
				array( 'color01' => $color_01_01, 'color02' => $color_01_02 ),
				array( 'color01' => $color_02_01, 'color02' => $color_02_02 ),
				array( 'color01' => $color_03_01, 'color02' => $color_03_02 ),
				array( 'color01' => $color_04_01, 'color02' => $color_04_02 ),
				array( 'color01' => $color_05_01, 'color02' => $color_05_02 )
			);

			$data['option'][] = $toc_array;
			$data['option'][] = $scroll_page_top_array;
			$data['colorList'] = $color_list;

			return new WP_REST_Response( $data, 200 );
		}

		/**
		 * コールバック（アップデート）
		 *
		 * @param array $req リクエスト
		 * @return object
		 */
		public function update_callback( $req ) {
			if ( ! isset( $req ) ) {
				return false;
			}

//			var_dump($req);

			return new WP_REST_Response( $req, 200 );
		}

		/**
		 * アクセスできる権限
		 *
		 * @return boolean
		 */
		public function rest_permission() {
			return current_user_can( 'manage_options' );
		}

		/**
		 * delete_all_data
		 */
		public function delete_all_data() {
			// 投稿と固定ページを削除
			$post_types = ['post', 'page'];
			foreach ($post_types as $type) {
				$posts = get_posts(['post_type' => $type, 'numberposts' => -1, 'post_status' => 'any']);
				foreach ($posts as $post) {
					wp_delete_post($post->ID, true);
				}
			}

			// メニューやウィジェット、オプションなどを削除（例）
			delete_option('sidebars_widgets');
			delete_option('widget_block');
			delete_option('nav_menu_options');
		}

		/**
		 * 既存コンテンツを全て初期化して選択したテンプレートを適用
		 */
		public function register_template( $topPage = '' ) {

			if ( ! current_user_can('administrator') ) return;

			if( $topPage == 'demo01' ){
				self::delete_all_data();
				$demo = new NISHIKI_PRO_SPDB_EASY_SETUP_DEMO01();
			}

			if( $topPage == 'demo02' ){
				self::delete_all_data();
				$demo = new NISHIKI_PRO_SPDB_EASY_SETUP_DEMO02();
			}

			if( $demo ){
				$demo->settings();
			}
		}
	}

	new NISHIKI_PRO_SPDB_REST_API();
}
