<?php
namespace nishiki\pro\spdb\init;

use nishiki\pro\spdb\init\Define;
use nishiki\pro\spdb\init\Scripts;

class Activate {
	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'activate_check' ) );
	}

	/**
	 * Active Theme Check
	 *
	 * @param string $theme_name テーマ名
	 * @return $flag
	 */
	function activate_check() {
		$plugin_path = Define::value( 'plugin_path' );

		if ( true === self::theme_check( Define::value( 'theme_name' ) ) ) {

			// Block Pattern
			require_once $plugin_path . 'inc/block-pattern/index.php';

			// Import Demo
			require_once $plugin_path . 'inc/import-demo/index.php';

			// Easy Setup
//			require_once $plugin_path . 'inc/easy-setup/index.php';

			// Preset
			//require_once $plugin_path . 'inc/preset/index.php';

			// Enqueue Scripts
			$scripts = new Scripts;

			add_action( 'admin_enqueue_scripts', array( $scripts, 'enqueue_script' ) );

		} else {
			// Notice
			add_action( 'admin_notices', array( $this, 'admin_notices' ) );
		}
	}

	/**
	 * Active Theme Check
	 *
	 * @param string $theme_name テーマ名
	 * @return $flag
	 */
	public function theme_check( $theme_name ) {
		$flag = false;

		$theme = wp_get_theme();

		if ( $theme->Template === $theme_name ) {
			$flag = true;
		}

		return $flag;
	}

	/**
	 * 通知
	 *
	 * @return void
	 */
	public function admin_notices() {
		$message = sprintf( 'Nishiki Pro Speed Builder を利用するには <a target="_blank" rel="noreferrer noopener" href="https://support.animagate.com/product/wp-nishiki-pro/">Nishiki Pro</a> テーマ（または Nishiki Pro 子テーマ）を有効化してください。' );
		printf( '<div class="notice notice-warning"><p>%s</p></div>', wp_kses_post( $message ) );
	}

}

use nishiki\pro\spdb\init;
new Activate();
