<?php
namespace nishiki\pro\spdb\init;

use nishiki\pro\spdb\init\Define;

class Update {

	private $file = 'plugin-info.json';
	public $updated;

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->updated = false;

		add_filter( 'plugins_api', [ $this, 'info' ], 20, 3 );
		add_filter( 'site_transient_update_plugins', [ $this, 'update' ] );
		add_action( 'upgrader_process_complete', [ $this, 'purge' ], 10, 2 );
	}

	/**
	 * データ取得
	 */
	private function request(){
		$expire_time = DAY_IN_SECONDS / 2; // DAY_IN_SECONDS:1日 | HOUR_IN_SECONDS:60分 | MINUTE_IN_SECONDS:60秒
		
		if( true !== Define::value( 'network_active' ) ){
			return false;
		}

		//delete_transient( Define::value( 'plugin_func_name' ) . '_update' );
		$remote = get_transient( Define::value( 'plugin_func_name' ) . '_update' );

		if( false === $remote ) {

			$remote = wp_remote_get(
				Define::value( 'download_info_url' ),
				array(
					'timeout' => 10,
					'sslverify' => false,
					'headers' => array(
						'Accept' => 'application/json'
					)
				)
			);

			// var_dump($remote);

			if(
				is_wp_error( $remote )
				|| 200 !== wp_remote_retrieve_response_code( $remote )
				|| empty( wp_remote_retrieve_body( $remote ) )
			) {
				return false;
			}

			set_transient( Define::value( 'plugin_func_name' ) . '_update', $remote, $expire_time );
		}

		$remote = json_decode( wp_remote_retrieve_body( $remote ) );

		return $remote;
	}

	/**
	 * プラグイン情報作成
	 */
	public function info( $res, $action, $args ) {

		if( 'plugin_information' !== $action ) {
			return $res;
		}

		if( Define::value( 'plugin_text_domain' ) !== $args->slug ) {
			return $res;
		}

		$remote = $this->request();

		if( ! $remote ) {
			return $res;
		}

		$res = new \stdClass();
		$res->name = $remote->name;
		$res->slug = $remote->slug;
		$res->author = $remote->author;
		$res->author_profile = $remote->author_profile;
		$res->version = $remote->version;
		$res->tested = $remote->tested;
		$res->requires = $remote->requires;
		$res->requires_php = $remote->requires_php;
		$res->download_link = Define::value( 'download_url' );
		$res->trunk = Define::value( 'download_url' );

		if( isset( $remote->last_updated ) ){
			$res->last_updated = $remote->last_updated;
		}

		$res->sections = [];

		if( isset( $remote->sections->description ) ){
			$res->sections['description'] = $remote->sections->description;
		}

		if( isset( $remote->sections->installation ) ){
			$res->sections['installation'] = $remote->sections->installation;
		}

		if( isset( $remote->sections->changelog ) ){
			$res->sections['changelog'] = $remote->sections->changelog;
		}

		if( isset( $remote->sections->screenshots ) ) {
			$res->sections[ 'screenshots' ] = $remote->sections->screenshots;
		}

		$res->banners = array(
			'low' => $remote->banners->low,
			'high' => $remote->banners->high
		);
		
		return $res;

	}

	/**
	 * 更新通知
	 */
	public function update( $transient ){
		if( ! is_admin() ){
			return false;
		}

		// プラグインの情報を取得
		$plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/' . Define::value( 'plugin_base_name' ) . '/index.php' );

		if ( empty( $transient->checked ) ) {
			return $transient;
		}

		$remote = $this->request();

		if(
			$remote
			&& version_compare( $plugin_data['Version'], $remote->version, '<' )
			&& version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
			&& version_compare( $remote->requires_php, PHP_VERSION, '<' )
		) {
			$res = new \stdClass();
			$res->slug = $remote->slug;
			$res->plugin = Define::value( 'plugin_base_name' ) . '/index.php';
			$res->new_version = $remote->version;
			$res->tested = $remote->tested;
			$res->package = Define::value( 'download_url' );
			$transient->response[ $res->plugin ] = $res;
		}
		
		return $transient;
		
	}

	/**
	 * 更新後キャッシュ削除
	 */
	public function purge( $upgrader, $options ){

		if (
			$this->updated
			&& 'update' === $options['action']
			&& 'plugin' === $options[ 'type' ]
		) {
			delete_transient( Define::value( 'plugin_func_name' ) . '_update' );
		}

	}

}

use fse\blocks\init;
new Update();
