<?php
namespace nishiki\pro\spdb\init;

use nishiki\pro\spdb\init\Define;

class Scripts {
	/**
	 * スクリプト読み込み
	 *
	 * @return void
	 */
	public static function enqueue_script() {
		$get_query = ! empty( $_GET['page'] ) ? htmlspecialchars( $_GET['page'] ) : '';

		if ( 'nishiki-pro-speed-builder-import-demo.php' === $get_query ) {
			$plugin_url = Define::value( 'plugin_url' );

			// Script
			wp_localize_script(
				'nishiki-pro-spdb-easy-setup',
				'easySetupObject',
				array(
					'apiUrl' => home_url( '/wp-json' ),
					'nonce'  => wp_create_nonce( 'wp_rest' ),
				)
			);

			wp_enqueue_script( 'nishiki-pro-spdb-import-demo', $plugin_url . 'build/index.js', array( 'jquery', 'wp-element' ), '1.0', true );
			wp_localize_script(
				'nishiki-pro-spdb-import-demo',
				'importDemoObject',
				array(
					'apiUrl' => home_url( '/wp-json' ),
					'plugin_url'  => Define::value( 'plugin_url' ),
					'nonce'  => wp_create_nonce( 'wp_rest' ),
				)
			);

			// Style
			wp_enqueue_style( 'nishiki-pro-spdb-import-demo', $plugin_url . 'build/index.css', array(), '1.0', 'all' );
		}
	}
}
