<?php
if ( ! class_exists( 'NISHIKI_PRO_SPDB_PRESET_ADMIN' ) ) {
	/**
	 * 管理画面（プリセット）
	 */
	class NISHIKI_PRO_SPDB_PRESET_ADMIN extends NISHIKI_PRO_SPDB_PRESET_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 100 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_submenu_page(
				'nishiki-pro.php',
				'プリセット[SPDB]',
				'プリセット[SPDB]',
				'manage_options',
				'nishiki-pro-speed-builder-preset.php',
				array( $this, 'add_page' )
			);
		}

		/**
		 * 設定画面出力
		 */
		public function create_setting() {
			settings_fields( $this->page_name );
			do_settings_sections( $this->page_name );
		}

		/**
		 * オプションページの内容
		 */
		public function add_page() {
			$this->options = get_option( $this->page_name );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
			<style>
				.nishiki-pro-admin-preset input[type="radio"]{
					display: none;
				}
				.nishiki-pro-admin-preset img{
					height:300px;
				}
				.nishiki-pro-admin-preset input[type="radio"] + label {
					position: relative;
					display: block;
					margin-bottom:1rem;
					padding:1rem;
					border-radius: 3px;
					max-width: 600px;
					align-items: center;
					background: #fff;
					border:3px solid #fff;
					transition: transform 0.5s;
				}
				.nishiki-pro-admin-preset .title{
					text-align: center;
					margin-bottom: 1.5rem;
					font-size: 1.2rem;
				}
				.nishiki-pro-admin-preset .description{
					margin-bottom: 1.5rem;
					font-size: 1.2rem;
				}
				.nishiki-pro-admin-preset .list-box{
					margin-bottom:1rem;
				}
				.nishiki-pro-admin-preset .list .list-title{
					font-weight: bold;
				}
				.nishiki-pro-admin-preset .list .list-small{
					font-size: 0.8rem;
					display: inline-block;
					background: #f1f1f1;
					border-radius: 4px;
					margin-right: 0.4rem;
					padding: 0.1rem 0.3rem;
				}
				.nishiki-pro-admin-preset .detail{
					display: flex;
				}
				.nishiki-pro-admin-preset input[type="radio"] + label img{
					box-sizing: border-box;
					vertical-align: inherit;
				}
				.nishiki-pro-admin-preset input[type="radio"] + label .list{
					margin-left:1rem;
				}
				.nishiki-pro-admin-preset input[type="radio"]:checked + label{
					border:3px solid #24b1ed;
					transform: translateX(5%);
				}
				.nishiki-pro-admin-preset input[type="radio"]:checked + label::before{
					font-family: dashicons;
					display: inline-block;
					content: "\f147";
					position:absolute;
					left:0;
					top:0;
					font-size:2rem;
					color:#fff;
					z-index: 1;
				}
				.nishiki-pro-admin-preset input[type="radio"]:checked + label::after{
					display: inline-block;
					content: "";
					position:absolute;
					left:0;
					top:0;
					width: 0;
					height: 0;
					border-style: solid;
					border-width: 4rem 4rem 0 0;
					border-color: #24b1ed transparent transparent transparent;
				}


				@media screen and (max-width: 782px){
					.nishiki-pro-admin-preset .detail{
						display: block;
						text-align: center;
					}
					.nishiki-pro-admin-preset img{
						margin-bottom:1rem;
					}
					.nishiki-pro-admin-preset input[type="radio"] + label .list{
						text-align:left;
					}
					.nishiki-pro-admin-preset input[type="radio"]:checked + label{
					border:3px solid #24b1ed;
					transform: translateX(0%);
				}
				}
			</style>
			<script type="text/javascript">
				function check(){

					var flag = false;

					for( i = 1; i < document.nishiki_pro_spdb_preset_form.nishiki_pro_spdb_preset.length; i++ ){
						if( document.nishiki_pro_spdb_preset_form.nishiki_pro_spdb_preset[i].checked ){
							flag = true;

							var presetName = document.nishiki_pro_spdb_preset_form.nishiki_pro_spdb_preset[i].dataset.presetName;
						}
					}

					//console.log(presetName);

					if( ! flag ){
						alert( 'プリセットを選択してください。' );
						return false;
					}

					if( window.confirm( 'プリセット「' + presetName + '」を適用しますか？\n\n※注意：プリセットを適用すると、テーマの設定が一部変更（上書き）されます。一度設定すると取り消しできません。' ) ){
						return true;
					}

					return false;

				}
			</script>
			<div class="wrap">
				<h1>プリセット</h1>
				<hr>
				<p>ウェブサイト運営に必要な機能をあらかじめまとめて設定できるページです。テーマを有効化した直後などにご使用ください。</p>
				<?php
				$get_action = filter_input( INPUT_GET, 'settings-updated', FILTER_SANITIZE_STRING );
				if ( isset( $get_action ) && 'true' === $get_action ) {
					?>
					<div id="settings_updated" class="updated notice is-dismissible"><p>プリセットを適用しました。</p></div>
				<?php } ?>
				<form method="post" action="options.php" name="<?php echo esc_html( $this->page_name ); ?>_form" class="nishiki-pro-admin-preset" onSubmit="return check()">
					<?php $this->create_setting(); ?>
				</form>
				<hr>
				<h3>マニュアルを見る</h3>
				<p><a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-preset/">操作マニュアル</a></p>
			</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_SPDB_PRESET_ADMIN();
	}
}
