<?php
if ( ! class_exists( 'NISHIKI_PRO_SPDB_PRESET_UTILITY' ) ) {
	/**
	 * ユーティリティ（プリセット）
	 */
	class NISHIKI_PRO_SPDB_PRESET_UTILITY {
		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		public $options;

		/**
		 * Holds name
		 *
		 * @var 0.0.1
		 */
		public $page_name = 'nishiki_pro_spdb_preset';

		/**
		 * プリセット
		 *
		 * @var array
		 */
		public $preset = array(
			'demo_02' => array(
				'site'           => array(
					'main_text_color'  => '#333333',
					'sub_text_color'   => '#6b634c',
					'main_color'       => '#cc1a1a',
					'sub_color'        => '#870000',
					'background_color' => '#ffffff',
				),
				'image_size'     => array(
					'thumbnail' => array( 640, 360 ),
					'medium'    => array( 0, 0 ),
					'large'     => array( 1280, 720 ),
				),
				'header'         => array(
					'nav'              => 1,
					'layout'           => 'default',
					'background_color' => '#ce5e3b',
					'text_color'       => 'ffffff',
					'search_button'    => true,
					'menu_collapse'    => true,
					'fixed'            => true,
				),
				'footer'         => array(
					'nav'               => 1,
					'background_color'  => '#ce3a1c',
					'text_color'        => '#ffffff',
					'link_color'        => '#e89e0b',
					'widget_text_color' => '#ffffff',
					'widget_link_color' => '#e89e0b',
				),
				'main_visual'    => array(
					'display'               => true,
					'header_image'          => 'https://demo.animagate.com/wp-nishiki-pro-02/wp-content/uploads/sites/9/2019/10/cropped-xavier-coiffic-gOc3VRa-eas-unsplash.jpg',
					'placeholder_display'   => true,
					'placeholder_grayscale' => 100,
					'background_color'      => '#ce3a1c',
					'background_opacity'    => 30,
					'description'           => 'ウェブサイトの説明（ディスクリプション）を入れる',
					'sub_text'              => 'サブテキストを入れる',
					'button_text'           => 'ボタンテキスト',
					'button_color'          => '#262626',
					'button_text_color'     => '#ffffff',
				),
				'post'           => array(
					'sidebar_column'         => 'left',
					'title_background_color' => '#af421a',
					'title_text_color'       => '#ffffff',
					'related_posts'          => true,
				),
				'page'           => array(
					'sidebar_column'         => 'left',
					'title_background_color' => '#c67803',
					'title_text_color'       => '#ffffff',
				),
				'archive'        => array(
					'sidebar_column'         => 'none',
					'title_background_color' => '#000000',
					'title_text_color'       => '#ffffff',
					'columns'                => 3,
					'default_image'          => NISHIKI_PRO_SPDB_NAME . '/assets/images/preset/02/thumbnail.jpg',
			// 'default_image' => 'https://demo.animagate.com/wp-nishiki-pro-02/wp-content/uploads/sites/9/2019/10/oleg-laptev-QRKJwE6yfJo-unsplash.jpg',
				),
				'button'         => array(
					'type'   => 'mild',
					'radius' => 30,
				),
				'heading'        => array(
					'h2' => array(
						'type'    => 'stitch-box',
						'color_1' => '#ffffff',
						'color_2' => '#9b2b0f',
						'color_3' => '',
						'radius'  => 0,
					),
					'h3' => array(
						'type'    => 'underline',
						'color_1' => '#6b6448',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
					'h4' => array(
						'type'    => 'baloon',
						'color_1' => '#ffffff',
						'color_2' => '#6b6448',
						'color_3' => '',
						'radius'  => 0,
					),
					'h5' => array(
						'type'    => 'none',
						'color_1' => '',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
					'h6' => array(
						'type'    => 'none',
						'color_1' => '',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
				),
				'tag'            => array(
					'text_color'             => '#ffffff',
					'background_color'       => '#d35630',
					'text_hover_color'       => '#222222',
					'background_hover_color' => '#e2e2e2',
				),
				'posts_per_page' => 6,
				'show_on_front'  => 'page',
				'width'          => 1000,
				'breadcrumbs'    => array(
					'enable'           => true,
					'background_color' => '',
					'text_color'       => '#333333',
					'link_color'       => '#cc1a1a',
					'link_hover_color' => '#870000',
				),
				'ogp'            => true,
				'toc'            => true,
				'campaign'       => array(
					'display' => false,
				),
				'share_button'   => true,
				'social'         => array(
					'background_color' => '#ba3318',
					'text_color'       => '#f2f2f2',
				),
			),
			'demo_01' => array(
				'image_size'     => array(
					'thumbnail' => array( 640, 360 ),
					'medium'    => array( 0, 0 ),
					'large'     => array( 1280, 720 ),
				),
				'header'         => array(
					'nav'              => 1,
					'layout'           => 'default',
					'background_color' => '#5fb8d8',
					'text_color'       => 'ffffff',
					'search_button'    => true,
					'menu_collapse'    => true,
					'fixed'            => true,
				),
				'footer'         => array(
					'nav'               => 1,
					'background_color'  => '#5fb8d8',
					'text_color'        => '#ffffff',
					'link_color'        => '#094b77',
					'widget_text_color' => '#ffffff',
					'widget_link_color' => '#ffffff',
				),
				'main_visual'    => array(
					'display'               => true,
					'header_image'          => NISHIKI_PRO_SPDB_NAME . '/assets/images/preset/01/main-visual.jpg',
					// 'header_image' => 'https://demo.animagate.com/wp-nishiki-pro-01/wp-content/uploads/sites/8/2019/09/cropped-toa-heftiba-a-w7wDtNWmo-unsplash.jpg',
					'placeholder_display' => true,
					'placeholder_grayscale' => 20,
					'background_color'      => '#000000',
					'background_opacity'    => 0,
					'description'           => 'ウェブサイトの説明（ディスクリプション）を入れる',
					'sub_text'              => 'サブテキストを入れる',
					'button_text'           => '背景画像を変更する',
					'button_color'          => '#fced62',
					'button_text_color'     => '#1e1e1e',
				),
				'post'           => array(
					'sidebar_column'         => 'right',
					'title_background_color' => '#5fb8d8',
					'title_text_color'       => '#ffffff',
					'related_posts'          => true,
				),
				'page'           => array(
					'sidebar_column'         => 'right',
					'title_background_color' => '#5fb8d8',
					'title_text_color'       => '#ffffff',
				),
				'archive'        => array(
					'sidebar_column'         => 'right',
					'title_background_color' => '#5fb8d8',
					'title_text_color'       => '#ffffff',
					'columns'                => 2,
					'default_image'          => NISHIKI_PRO_SPDB_NAME . '/assets/images/preset/01/thumbnail.jpg',
			// 'default_image' => 'https://demo.animagate.com/wp-nishiki-pro-01/wp-content/uploads/sites/8/2019/09/aaron-burden-cEukkv42O40-unsplash-640x360.jpg',
				),
				'button'         => array(
					'type' => 'simple',
				),
				'heading'        => array(
					'h2' => array(
						'type'    => 'box',
						'color_1' => '',
						'color_2' => '#fced62',
						'color_3' => '',
						'radius'  => 0,
					),
					'h3' => array(
						'type'    => 'none',
						'color_1' => '',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
					'h4' => array(
						'type'    => 'none',
						'color_1' => '',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
					'h5' => array(
						'type'    => 'none',
						'color_1' => '',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
					'h6' => array(
						'type'    => 'none',
						'color_1' => '',
						'color_2' => '',
						'color_3' => '',
						'radius'  => 0,
					),
				),
				'tag'            => array(
					'text_color'             => '#333333',
					'background_color'       => '#f5f5f5',
					'text_hover_color'       => '#222222',
					'background_hover_color' => '#f2f2f2',
				),
				'posts_per_page' => 6,
				'show_on_front'  => 'post',
				'width'          => 1200,
				'breadcrumbs'    => array(
					'enable' => true,
				),
				'ogp'            => true,
				'toc'            => true,
				'campaign'       => array(
					'display'                 => true,
					'type'                    => 'stripe',
					'background_color_01'     => '#f2f2f2',
					'background_color_02'     => '#eaeaea',
					'text'                    => 'お知らせに使おう',
					'text_color'              => '#555555',
					'text_hover_color'        => '#222222',
					'button_text'             => 'ボタンもつけられるよ',
					'button_text_color'       => '#ffffff',
					'button_text_hover_color' => '#eeeeee',
					'button_color'            => '#555555',
					'button_hover_color'      => '#222222',
					'button_link'             => '#',
					'button_animation'        => true,
				),
				'share_button'   => true,
				'social'         => array(
					'background_color' => '#eaeaea',
					'text_color'       => '#353535',
				),
			),
			'basic'   => array(
				'image_size'     => array(
					'thumbnail' => array( 640, 360 ),
					'medium'    => array( 0, 0 ),
					'large'     => array( 1280, 720 ),
				),
				'header'         => array(
					'nav'           => 1,
					'layout'        => 'default',
					'search_button' => true,
					'menu_collapse' => true,
					'fixed'         => true,
				),
				'footer'         => array(
					'nav' => 1,
				),
				'main_visual'    => array(
					'display'     => true,
					'description' => 'ウェブサイトの説明（ディスクリプション）を入れる',
					'sub_text'    => 'サブテキストを入れる',
					'button_text' => '背景画像を変更する',
				),
				'post'           => array(
					'sidebar_column' => 'none',
					'related_posts'  => true,
				),
				'page'           => array(
					'sidebar_column' => 'none',
				),
				'archive'        => array(
					'sidebar_column' => 'none',
					'columns'        => 3,
				),
				'button'         => array(
					'type' => 'simple',
				),
				'tag'            => array(
					'text_color'             => '#333333',
					'background_color'       => '#f5f5f5',
					'text_hover_color'       => '#222222',
					'background_hover_color' => '#f2f2f2',
				),
				'posts_per_page' => 12,
				'show_on_front'  => 'post',
				'width'          => 1000,
				'breadcrumbs'    => array(
					'enable' => true,
				),
				'ogp'            => true,
				'toc'            => true,
				'campaign'       => array(
					'display'                 => true,
					'type'                    => 'stripe',
					'background_color_01'     => '#f2f2f2',
					'background_color_02'     => '#eaeaea',
					'text'                    => 'お知らせに使おう',
					'text_color'              => '#555555',
					'text_hover_color'        => '#222222',
					'button_text'             => 'ボタンもつけられるよ',
					'button_text_color'       => '#ffffff',
					'button_text_hover_color' => '#eeeeee',
					'button_color'            => '#555555',
					'button_hover_color'      => '#222222',
					'button_link'             => '#',
					'button_animation'        => true,
				),
				'share_button'   => true,
			),
		);

		/**
		 * プロフィール
		 *
		 * @var array
		 */
		public $profile_array = array(
			'enable' => 1,
		);

		/**
		 * OGP
		 *
		 * @var array
		 */
		public $ogp_array = array(
			'active' => array(
				'ogp'      => 1,
				'twitter'  => 1,
				'facebook' => 1,
			),
		);

		/**
		 * Schema.org（JSON LD）
		 *
		 * @var array
		 */
		public $json_ld_array = array(
			'website'      => 1,
			'website_type' => 1,
			'post_type'    => array(
				'post' => 1,
				'page' => 1,
			),
		);

		/**
		 * Breadcrumbs
		 *
		 * @var array
		 */
		public $breadcrumbs_array = array(
			'enable'    => 1,
			'display'   => array(
				'header' => 1,
			),
			'post_type' => array(
				'post' => 1,
				'page' => 1,
			),
			'archive'   => array(
				'category' => 1,
				'post_tag' => 1,
				'author'   => 1,
				'paged'    => 1,
				'year'     => 1,
				'month'    => 1,
				'day'      => 1,
			),
			'other'     => array(
				'404'    => 1,
				'search' => 1,
			),
		);

		/**
		 * Global Nav
		 *
		 * @return void
		 */
		public function create_global_nav() {
			// Check if the menu exists
			$menu_name   = 'nishiki-pro-global-nav';
			$menu_exists = wp_get_nav_menu_object( $menu_name );

			if ( $menu_exists ) {
				wp_delete_nav_menu( $menu_name );
			}

			$menu_id = wp_create_nav_menu( $menu_name );

			// Set up default menu items
			wp_update_nav_menu_item(
				$menu_id,
				0,
				array(
					'menu-item-title'   => '<i class="icomoon icon-home"></i>Home',
					'menu-item-classes' => '',
					'menu-item-url'     => '/',
					'menu-item-status'  => 'publish',
				)
			);

			// Set the menu to primary menu location
			$locations           = get_theme_mod( 'nav_menu_locations' );
			$locations['global'] = $menu_id;
			set_theme_mod( 'nav_menu_locations', $locations );
		}

		/**
		 * Footer Nav
		 *
		 * @return void
		 */
		public function create_footer_nav() {
			// Check if the menu exists
			$menu_name   = 'nishiki-pro-footer-nav';
			$menu_exists = wp_get_nav_menu_object( $menu_name );

			if ( $menu_exists ) {
				wp_delete_nav_menu( $menu_name );
			}

			$menu_id = wp_create_nav_menu( $menu_name );

			// Set up default menu items
			wp_update_nav_menu_item(
				$menu_id,
				0,
				array(
					'menu-item-title'   => '<i class="icomoon icon-arrow-up"></i>ページトップ',
					'menu-item-classes' => '',
					'menu-item-url'     => '#page',
					'menu-item-status'  => 'publish',
				)
			);

			wp_update_nav_menu_item(
				$menu_id,
				0,
				array(
					'menu-item-title'      => '<i class="icomoon icon-search"></i>検索',
					'menu-item-classes'    => '',
					'menu-item-attr-title' => 'search',
					'menu-item-object-id'  => 'search',
					'menu-item-object'     => 'search',
					'menu-item-type'       => 'nishiki-pro-nav-menus',
					'menu-item-status'     => 'publish',
				)
			);

			wp_update_nav_menu_item(
				$menu_id,
				0,
				array(
					'menu-item-title'      => '<i class="icomoon icon-menu"></i>メニュー',
					'menu-item-classes'    => '',
					'menu-item-attr-title' => 'menu',
					'menu-item-object-id'  => 'menu',
					'menu-item-object'     => 'menu',
					'menu-item-type'       => 'nishiki-pro-nav-menus',
					'menu-item-status'     => 'publish',
				)
			);

			// Set the menu to primary menu location
			$locations           = get_theme_mod( 'nav_menu_locations' );
			$locations['footer'] = $menu_id;
			set_theme_mod( 'nav_menu_locations', $locations );
		}

		/**
		 * Upload Image
		 *
		 * @param string $path 文字列
		 * @return $image_url
		 */
		public function upload_image( $path ) {
			$image_url = plugins_url( $path );
			$file      = array();

			$file['name'] = basename( $image_url );

			$file['tmp_name'] = download_url( $image_url );

			// wp_die($image_url);

			if ( is_wp_error( $file['tmp_name'] ) ) {
				return false;
			}

			$attachment_id = media_handle_sideload( $file );

			$image_url = wp_get_attachment_url( $attachment_id );

			return $image_url;
		}

		/**
		 * Upload Image
		 *
		 * @param string $url 文字列
		 * @return $url
		 */
		public function upload_image2( $url ) {

			$file = array();

			$file['name'] = basename( $url );

			$file['tmp_name'] = download_url( $url );

			if ( is_wp_error( $file['tmp_name'] ) ) {
				return false;
			}

			$attachment_id = media_handle_sideload( $file );

			$url = wp_get_attachment_url( $attachment_id );

			return $url;
		}

		/**
		 * Site
		 *
		 * @param string $setting 文字列
		 * @param array  $value 配列
		 * @return void
		 */
		public function site_settings( $setting, $value ) {
			if ( 'site' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'main_text_color' === $key ) {
						set_theme_mod( 'setting_site_main_text_color', esc_html( $val ) );
					}
					if ( 'sub_text_color' === $key ) {
						set_theme_mod( 'setting_site_sub_text_color', esc_html( $val ) );
					}
					if ( 'main_color' === $key ) {
						set_theme_mod( 'setting_site_main_color', esc_html( $val ) );
					}
					if ( 'sub_color' === $key ) {
						set_theme_mod( 'setting_site_sub_color', esc_html( $val ) );
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_site_background_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * Thumbnails
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function thumbnails_settings( $setting, $value ) {
			if ( 'image_size' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'thumbnail' === $key ) {
						update_option( 'thumbnail_size_w', esc_html( $val[0] ) );
						update_option( 'thumbnail_size_h', esc_html( $val[1] ) );
					}
					if ( 'medium' === $key ) {
						update_option( 'medium_size_w', esc_html( $val[0] ) );
						update_option( 'medium_size_h', esc_html( $val[1] ) );
					}
					if ( 'large' === $key ) {
						update_option( 'large_size_w', esc_html( $val[0] ) );
						update_option( 'large_size_h', esc_html( $val[1] ) );
					}
				}
			}
		}

		/**
		 * Header
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function header_settings( $setting, $value ) {
			if ( 'header' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'nav' === $key ) {
						$this->create_global_nav();
					}
					if ( 'layout' === $key ) {
						set_theme_mod( 'setting_header_layout', esc_html( $val ) );
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_header_background_color', esc_html( $val ) );
					}
					if ( 'text_color' === $key ) {
						set_theme_mod( 'header_textcolor', esc_html( $val ) );
					}
					if ( 'search_button' === $key ) {
						set_theme_mod( 'setting_header_search_button', true );
					}
					if ( 'menu_collapse' === $key ) {
						set_theme_mod( 'setting_header_menu_collapse', true );
					}
					if ( 'fixed' === $key ) {
						set_theme_mod( 'setting_header_fixed', true );
					}
				}
			}
		}

		/**
		 * Footer
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function footer_settings( $setting, $value ) {
			if ( 'footer' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'nav' === $key ) {
						$this->create_footer_nav();
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_footer_background_color', esc_html( $val ) );
					}
					if ( 'text_color' === $key ) {
						set_theme_mod( 'setting_footer_text_color', esc_html( $val ) );
					}
					if ( 'link_color' === $key ) {
						set_theme_mod( 'setting_footer_link_color', esc_html( $val ) );
					}
					if ( 'widget_text_color' === $key ) {
						set_theme_mod( 'setting_footer_widget_text_color', esc_html( $val ) );
					}
					if ( 'widget_link_color' === $key ) {
						set_theme_mod( 'setting_footer_widget_link_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * Main Visual
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function main_visual_settings( $setting, $value ) {
			if ( 'main_visual' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'display' === $key ) {
						set_theme_mod( 'setting_top_main_visual_display', true );
					}
					if ( 'header_image' === $key ) {
						$main_visual_image_url = $this->upload_image( $val );
						set_theme_mod( 'header_image', $main_visual_image_url );
					}
					if ( 'placeholder_display' === $key ) {
						set_theme_mod( 'setting_top_main_visual_image_placeholder_display', true );
					}
					if ( 'placeholder_grayscale' === $key ) {
						set_theme_mod( 'setting_top_main_visual_image_placeholder_grayscale', absint( $val ) );
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_top_main_visual_background_color', esc_html( $val ) );
					}
					if ( 'background_opacity' === $key ) {
						set_theme_mod( 'setting_top_main_visual_background_opacity', absint( $val ) );
					}
					if ( 'description' === $key ) {
						set_theme_mod( 'blogdescription', esc_html( $val ) );
					}
					if ( 'sub_text' === $key ) {
						set_theme_mod( 'setting_top_main_visual_sub_text', esc_html( $val ) );
					}
					if ( 'button_text' === $key ) {
						set_theme_mod( 'setting_top_main_visual_main_button_text', esc_html( $val ) );
					}
					if ( 'button_color' === $key ) {
						set_theme_mod( 'setting_top_main_visual_main_button_color', esc_html( $val ) );
					}
					if ( 'button_text_color' === $key ) {
						set_theme_mod( 'setting_top_main_visual_main_button_text_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * Post
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function post_settings( $setting, $value ) {
			if ( 'post' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'sidebar_column' === $key ) {
						set_theme_mod( 'setting_post_column', esc_html( $val ) );
					}
					if ( 'title_background_color' === $key ) {
						set_theme_mod( 'setting_post_title_background_color', esc_html( $val ) );
					}
					if ( 'title_text_color' === $key ) {
						set_theme_mod( 'setting_post_title_text_color', esc_html( $val ) );
					}
					if ( 'related_posts' === $key ) {
						set_theme_mod( 'setting_post_related_posts_display', true );
						set_theme_mod( 'setting_post_related_posts_columns', 2 );
						set_theme_mod( 'setting_post_related_posts_number', 2 );
					}
				}
			}
		}

		/**
		 * Page
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function page_settings( $setting, $value ) {
			if ( 'page' === $setting && ! empty( $setting ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'sidebar_column' === $key ) {
						set_theme_mod( 'setting_page_column', esc_html( $val ) );
					}
					if ( 'title_background_color' === $key ) {
						set_theme_mod( 'setting_page_title_background_color', esc_html( $val ) );
					}
					if ( 'title_text_color' === $key ) {
						set_theme_mod( 'setting_page_title_text_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * Share Button
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function share_settings( $setting, $value ) {
			if ( 'share_button' === $setting && true === $value ) {
				$nishiki_pro_initial_setting_share_button_type = array(
					'LINE',
					'Twitter',
					'Facebook',
					'hatena',
				);

				foreach ( $nishiki_pro_initial_setting_share_button_type as $button ) {
					set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SHARE . '_button_' . $button, true );
				}
			}
		}

		/**
		 * Social Account
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function social_settings( $setting, $value ) {
			if ( 'social' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'text_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_text_color', esc_html( $val ) );
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_background_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * Archive
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function archive_settings( $setting, $value ) {
			if ( 'archive' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'sidebar_column' === $key ) {
						set_theme_mod( 'setting_archive_column', esc_html( $val ) );
					}
					if ( 'title_background_color' === $key ) {
						set_theme_mod( 'setting_archive_title_background_color', esc_html( $val ) );
					}
					if ( 'title_text_color' === $key ) {
						set_theme_mod( 'setting_archive_title_text_color', esc_html( $val ) );
					}
					if ( 'columns' === $key ) {
						set_theme_mod( 'setting_archive_article_columns', absint( $val ) );
					}
					if ( 'default_image' === $key ) {
						$archive_default_image_url = $this->upload_image( $val );
						set_theme_mod( 'setting_archive_default_image', $archive_default_image_url );
					}
				}
			}
		}

		/**
		 * Button
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function button_settings( $setting, $value ) {
			if ( 'button' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'type' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type', esc_html( $val ) );
					}
					if ( 'radius' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_radius', absint( $val ) );
					}
				}
			}
		}

		/**
		 * タグ
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function tag_settings( $setting, $value ) {
			if ( 'tag' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'text_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color', esc_html( $val ) );
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color', esc_html( $val ) );
					}
					if ( 'text_hover_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_hover_color', esc_html( $val ) );
					}
					if ( 'background_hover_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_hover_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * Width
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function width_settings( $setting, $value ) {
			if ( 'width' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				set_theme_mod( 'setting_site_contents_width', absint( $value ) );
				set_theme_mod( 'setting_header_contents_width', absint( $value ) );
				set_theme_mod( 'setting_footer_contents_width', absint( $value ) );
				set_theme_mod( 'setting_archive_contents_width', absint( $value ) );
			}
		}

		/**
		 * OGP
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function ogp_settings( $setting, $value ) {
			if ( 'ogp' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				update_option( 'nishiki_pro_meta_ogp', $this->ogp_array );
				if ( ! empty( $archive_default_image_url ) ) {
					set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image', $archive_default_image_url );
				}
				set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_card', 'summary_large_image' );
			}
		}

		/**
		 * Breadcrumbs
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function breadcrumbs_settings( $setting, $value ) {
			if ( 'breadcrumbs' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				foreach ( $value as $key => $val ) {
					if ( 'enable' === $key && true === $val ) {
						update_option( 'nishiki_pro_general_breadcrumbs', $this->breadcrumbs_array );
					}
					if ( 'background_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_background_color', esc_html( $breadcrumbs_array ) );
					}
					if ( 'text_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_text_color', esc_html( $val ) );
					}
					if ( 'link_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_color', esc_html( $val ) );
					}
					if ( 'link_hover_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . 'link_hover_color', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * TOC
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function toc_settings( $setting, $value ) {
			if ( 'toc' === $setting && true === $value ) {
				set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_display', true );
				set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display', true );
			}
		}

		/**
		 * Campaign
		 *
		 * @param string $setting 設定
		 * @param array  $value 配列
		 * @return void
		 */
		public function campaign_settings( $setting, $value ) {
			if ( 'campaign' === $setting && ! empty( $setting ) && ! empty( $value ) ) {
				$campaign_default_display_page = array(
					'top',
					'singular',
					'archive',
					'404',
					'search',
				);

				foreach ( $value as $key => $val ) {

					if ( 'display' === $key && true === $val ) {
						foreach ( $campaign_default_display_page as $campaign_page ) {
							set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_' . $campaign_page, true );
						}
					}

					if ( 'text' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text', esc_html( $val ) );
					}

					if ( 'text_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_color', esc_html( $val ) );
					}

					if ( 'text_hover_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_hover_color', esc_html( $val ) );
					}

					if ( 'button_text' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text', esc_html( $val ) );
					}

					if ( 'button_text_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_color', esc_html( $val ) );
					}

					if ( 'button_text_hover_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_hover_color', esc_html( $val ) );
					}

					if ( 'button_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_color', esc_html( $val ) );
					}

					if ( 'button_hover_color' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_hover_color', esc_html( $val ) );
					}

					if ( 'button_link' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link', esc_html( $val ) );
					}

					if ( 'button_animation' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_button_shine', true );
					}

					if ( 'type' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_type', esc_html( $val ) );
					}

					if ( 'background_color_01' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_01', esc_html( $val ) );
					}

					if ( 'background_color_02' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_02', esc_html( $val ) );
					}

					if ( 'background_color_03' === $key ) {
						set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_03', esc_html( $val ) );
					}
				}
			}
		}

		/**
		 * 各種設定初期化
		 *
		 * @return void
		 */
		public function reset_settings() {
			remove_theme_mods(); // カスタマイザーの設定
			remove_theme_mod( 'header_image' ); // ヘッダー画像
			remove_theme_mod( 'setting_archive_default_image' ); // アーカイブページの画像
			update_option( 'show_on_front', 'posts' ); // フロントページ設定を投稿にする
		}

	}
}
