<?php
if ( ! class_exists( 'NISHIKI_PRO_SPDB_PRESET' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_SPDB_PRESET extends NISHIKI_PRO_SPDB_PRESET_UTILITY {

		/**
		 * Constructor.
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'register_form' ), 20 );

			// テーマ変更後に初期設定
			add_action( 'after_switch_theme', array( $this, 'initial_setting' ) );
		}

		/**
		 * フォーム追加
		 */
		public function register_form() {
			$page_name = $this->page_name;

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'general_cb' ),
				$page_name
			);

			add_settings_field(
				'preset',
				__( 'プリセットを選ぶ', 'nishiki-pro' ),
				array( $this, 'create_form_radio_button_cb' ),
				$page_name,
				$page_name,
				array(
					'title'     => '有効化',
					'label'     => 'preset',
					'page_name' => $page_name,
					'source'    => array(
						/*
								'demo_02' => array(
									'name' => 'DEMO 02',
									//'description' => '基本機能＋ブログなどを作りたい人向け（サイドバー左）',
									'image' => plugins_url( NISHIKI_PRO_SPDB_NAME . '/assets/images/preset/02/top.jpg' ),
									'settings' => array(
										'top' => array(
											'name' => 'トップページ',
											'data' => array(
												'main_visual' => 'メインビジュアル変更',
												'description' => 'キャッチフレーズ変更',
												'sub_text' => 'サブテキスト変更',
												'button_text' => 'ボタンテキスト変更',
											),
										),
										'header' => array(
											'name' => 'ヘッダー',
											'data' => array(
												'global_nav' => 'グローバルナビ（Home）',
												'layout' => 'レイアウト（横）',
												'color' => 'カラー変更',
											),
										),
										'footer' => array(
											'name' => 'フッター',
											'data' => array(
												'footer_color' => 'カラー変更',
											),
										),
										'other' => array(
											'name' => 'その他',
											'data' => array(
												'width' => 'コンテンツ幅 1000px（ヘッダー/フッター/本文）',
												'ogp' => 'OGP/Twitter カード',
												'JSON LD' => 'Schema.org（構造化データ）',
												'toc' => '目次',
												'breadcrumb' => 'パンくずリスト（タイトル下）',
												'image_size' => '画像サイズ最適化',
												'sidebar' => 'サイドバー（左）',
												'share_button' => 'シェアボタン（本文下）',
												'related_posts' => '関連記事',
											),
										),
									)
								),
								*/
								'demo_01' => array(
									'name'     => 'ブログ向け（サイドバー右）',
									// 'description' => '基本機能＋ブログなどを作りたい人向け（サイドバー右）',
									'image'    => plugins_url( NISHIKI_PRO_SPDB_NAME . '/assets/images/preset/01/top.jpg' ),
									'settings' => array(
										'top'    => array(
											'name' => 'トップページ',
											'data' => array(
												'main_visual' => 'メインビジュアル変更',
												'description' => 'キャッチフレーズ変更',
												'sub_text' => 'サブテキスト変更',
												'button_text' => 'ボタンテキスト変更',
											),
										),
										'header' => array(
											'name' => 'ヘッダー',
											'data' => array(
												'global_nav' => 'グローバルナビ（Home）',
												'layout' => 'レイアウト（横）',
												'color'  => 'カラー変更',
											),
										),
										'footer' => array(
											'name' => 'フッター',
											'data' => array(
												'footer_nav' => 'フッターナビ（ページトップ/検索/メニュー）',
												'footer_color' => 'カラー変更',
											),
										),
										'other'  => array(
											'name' => 'その他',
											'data' => array(
												'width'    => 'コンテンツ幅 1000px（ヘッダー/フッター/本文）',
												'ogp'      => 'OGP/Twitter カード',
												'JSON LD'  => 'Schema.org（構造化データ）',
												'toc'      => '目次',
												'breadcrumb' => 'パンくずリスト（タイトル下）',
												'campaign' => 'キャンペーンリンク',
												'image_size' => '画像サイズ最適化',
												'sidebar'  => 'サイドバー（右）',
												'share_button' => 'シェアボタン（本文下）',
												'related_posts' => '関連記事',
											),
										),
									),
								),
						'basic'           => array(
							'name'        => '基本',
							'description' => '基本機能を一括で設定したい人向け',
							'image'       => plugins_url( NISHIKI_PRO_SPDB_NAME . '/assets/images/preset/00/top.jpg' ),
							'settings'    => array(
								'header' => array(
									'name' => 'ヘッダー',
									'data' => array(
										'global_nav' => 'グローバルナビ（Home）',
										'layout'     => 'レイアウト（横）',
									),
								),
								'footer' => array(
									'name' => 'フッター',
									'data' => array(
										'footer_nav' => 'フッターナビ（ページトップ/検索/メニュー）',
									),
								),
								'other'  => array(
									'name' => 'その他',
									'data' => array(
										'width'         => 'コンテンツ幅 1000px（ヘッダー/フッター/本文）',
										'ogp'           => 'OGP/Twitter カード',
										'JSON LD'       => 'Schema.org（構造化データ）',
										'toc'           => '目次',
										'breadcrumb'    => 'パンくずリスト（タイトル下）',
										'campaign'      => 'キャンペーンリンク',
										'image_size'    => '画像サイズ最適化',
										'sidebar'       => 'サイドバー（なし）',
										'share_button'  => 'シェアボタン（本文下）',
										'related_posts' => '関連記事',
									),
								),
							),
						),
					),
				)
			);

		}

		/**
		 * フォームの出力（全ページ）
		 */
		public function general_cb() {
			$nonce = wp_create_nonce( $this->page_name );
			echo '<input type="hidden" name="' . esc_attr( $this->page_name ) . '" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * フォーム作成（ラジオボタン）
		 *
		 * @param array $arg 配列
		 * @return void
		 */
		public function create_form_radio_button_cb( $arg ) {
			$label_name = $arg['page_name'] . '_' . $arg['label'];
			foreach ( $arg['source'] as $key => $preset ) {
				$list_text = '';

				if ( ! empty( $preset['image'] ) ) {
					$preset_name = '<p class="title">' . esc_html( $preset['name'] ) . '</p>';
				} else {
					$preset_name = '';
				}

				if ( ! empty( $preset['image'] ) ) {
					$preset_image = '<img src="' . esc_url( $preset['image'] ) . '">';
				} else {
					$preset_image = '';
				}

				if ( ! empty( $preset['description'] ) ) {
					$preset_desc = '<p class="description">' . esc_html( $preset['description'] ) . '</p>';
				} else {
					$preset_desc = '';
				}

				echo '<div>';
				echo '<input type="radio" data-preset-name="' . esc_attr( $preset['name'] ) . '" id="' . esc_attr( $label_name . '_' . $key ) . '" name="' . esc_attr( $arg['page_name'] ) . '" value="' . esc_attr( $key ) . '"><label for="' . esc_attr( $label_name . '_' . $key ) . '">';
				echo $preset_name; // phpcs:ignore
				echo $preset_desc; // phpcs:ignore
				echo '<div class="detail">' . $preset_image; // phpcs:ignore
				echo '<div class="list">';
				foreach ( $preset['settings'] as $settings ) {
					// var_dump( $settings['name'] );
					$list_text = '';

					foreach ( $settings['data'] as $key => $data ) {
						$list_text .= '<p class="list-small">' . $data . '</p>';
					}

					// echo $list = $settings['name'] . $list_text;
					echo '<div class="list-box"><p class="list-title">' . esc_html( $settings['name'] ) . '</p>' . wp_kses_post( $list_text ) . '</div>';
				}

				echo '</div></label></div></div>';
			}

			// $this->reset_settings();
			// remove_theme_mods();
			// remove_theme_mod ( 'header_image' );
			// remove_theme_mod ( 'setting_archive_default_image');
			// update_option( 'show_on_front', 'posts' );
			// delete_option( 'show_on_front' );
			// var_dump( get_option( 'show_on_front' ) );
			// var_dump( get_option( 'page_on_front' ) );
			// var_dump( get_theme_mod('setting_front_page_home_content_display') );
			// var_dump(get_option( 'nishiki_pro_meta_json_ld' ));
			// var_dump(get_option( 'nishiki_pro_general_profile' ));
			// update_option('fresh_site',1);

			?>
				<h3>注意事項</h3>
				<ul>
					<li>※：トップページを固定ページに設定するプリセットです。固定ページ内のコンテンツは、ご自身で作成ください。</li>
					<li>ウィジェットの設定は対応してません。</li>
				</ul>
				<hr>
				<h3>プリセットを適用しますか？</h3>
				<p style="color:#de7c00;"><strong>一度適用すると取り消しできません。適用した設定を元に戻したい場合は、設定画面で個別に変更ください。</strong></p>
			<?php
			submit_button( '適用する' );
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			// wp_die(var_dump(get_option('nishiki_pro_general_breadcrumbs')));
			$settings = $this->preset[ "$input" ];

			// wp_die(var_dump($settings));

			// 初期化
			$this->reset_settings();

			foreach ( $settings as $setting => $val ) {
				/*
				// Heading
				if( $setting == 'heading' && $val == true ){
					foreach( $val as $heading_level => $heading_data ){
						foreach( $heading_data as $heading_key => $heading_val ){
							if( $heading_key === 'type' ){
								set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type_' . $heading_level, esc_html( $heading_val ) );
							}
							if( $heading_key === 'color_1' ){
								set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_' . $heading_level . '_01', esc_html( $heading_val ) );
							}
							if( $heading_key === 'color_2' ){
								set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_' . $heading_level . '_02', esc_html( $heading_val ) );
							}
							if( $heading_key === 'color_3' ){
								set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_' . $heading_level . '_03', esc_html( $heading_val ) );
							}
							if( $heading_key === 'radius' ){
								set_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_radius_' . $heading_level, absint( $heading_val ) );
							}
						}
					}
				}
				*/

				// Site
				if ( 'site' === $setting ) {
					$this->site_settings( $setting, $val );
					continue;
				}

				// Thumbnails
				if ( 'image_size' === $setting ) {
					$this->thumbnails_settings( $setting, $val );
					continue;
				}

				// Header
				if ( 'header' === $setting ) {
					$this->header_settings( $setting, $val );
					continue;
				}

				// Footer
				if ( 'footer' === $setting ) {
					$this->footer_settings( $setting, $val );
					continue;
				}

				// Main Visual
				if ( 'main_visual' === $setting ) {
					$this->main_visual_settings( $setting, $val );
					continue;
				}

				// Post
				if ( 'post' === $setting ) {
					$this->post_settings( $setting, $val );
					continue;
				}

				// Page
				if ( 'page' === $setting ) {
					$this->page_settings( $setting, $val );
					continue;
				}

				// Front Page
				if ( 'show_on_front' === $setting ) {
					update_option( 'show_on_front', esc_html( $val ) );
					continue;
				}

				// Posts Per Page
				if ( 'posts_per_page' === $setting ) {
					update_option( 'posts_per_page', absint( $val ) );
					continue;
				}

				// Archive Page
				if ( 'archive' === $setting ) {
					$this->archive_settings( $setting, $val );
					continue;
				}

				// Share Button
				if ( 'share_button' === $setting ) {
					$this->share_settings( $setting, $val );
					continue;
				}

				// Social Account
				if ( 'social' === $setting ) {
					$this->social_settings( $setting, $val );
					continue;
				}

				// Button
				if ( 'button' === $setting ) {
					$this->button_settings( $setting, $val );
					continue;
				}

				// Tag
				if ( 'tag' === $setting ) {
					$this->tag_settings( $setting, $val );
					continue;
				}

				// Width
				if ( 'width' === $setting ) {
					$this->width_settings( $setting, $val );
					continue;
				}

				// OGP
				if ( 'ogp' === $setting ) {
					$this->ogp_settings( $setting, $val );
					continue;
				}

				// Breadcrumbs
				if ( 'breadcrumbs' === $setting ) {
					$this->breadcrumbs_settings( $setting, $val );
					continue;
				}

				// TOC
				if ( 'toc' === $setting ) {
					$this->toc_settings( $setting, $val );
					continue;
				}

				// Campaign
				if ( 'campaign' === $setting ) {
					$this->campaign_settings( $setting, $val );
					continue;
				}
			}
		}

		/**
		 * テーマ変更後 初期設定
		 *
		 * @return void
		 */
		public function initial_setting() {

			// Profile
			if ( empty( get_option( 'nishiki_pro_general_profile' ) ) ) {
				update_option( 'nishiki_pro_general_profile', $this->profile_array );
			}

			// OGP
			if ( empty( get_option( 'nishiki_pro_meta_ogp' ) ) ) {
				update_option( 'nishiki_pro_meta_ogp', $this->ogp_array );
			}

			// JSON LD
			if ( empty( get_option( 'nishiki_pro_meta_json_ld' ) ) ) {
				update_option( 'nishiki_pro_meta_json_ld', $this->json_ld_array );
			}

			// Breadcrumbs
			if ( empty( get_option( 'nishiki_pro_general_breadcrumbs' ) ) ) {
				update_option( 'nishiki_pro_general_breadcrumbs', $this->breadcrumbs_array );
			}

		}

	}
}

$output = new NISHIKI_PRO_SPDB_PRESET();
